/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.broker.transaction.rocksdb;

import io.netty.channel.Channel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.broker.BrokerController;
import org.apache.rocketmq.common.ServiceThread;
import org.apache.rocketmq.common.ThreadFactoryImpl;
import org.apache.rocketmq.common.message.Message;
import org.apache.rocketmq.common.message.MessageClientIDSetter;
import org.apache.rocketmq.common.message.MessageExt;
import org.apache.rocketmq.common.utils.ThreadUtils;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.remoting.protocol.header.CheckTransactionStateRequestHeader;
import org.apache.rocketmq.store.DefaultMessageStore;
import org.apache.rocketmq.store.MessageStore;
import org.apache.rocketmq.store.rocksdb.MessageRocksDBStorage;
import org.apache.rocketmq.store.transaction.TransMessageRocksDBStore;
import org.apache.rocketmq.store.transaction.TransRocksDBRecord;

public class TransactionalMessageRocksDBService {
    private static final Logger log = LoggerFactory.getLogger((String)"RocketmqTransaction");
    private static final int MAX_BATCH_SIZE_FROM_ROCKSDB = 2000;
    private static final int INITIAL = 0;
    private static final int RUNNING = 1;
    private static final int SHUTDOWN = 2;
    private volatile int state = 0;
    private final MessageRocksDBStorage messageRocksDBStorage;
    private final TransMessageRocksDBStore transMessageRocksDBStore;
    private final MessageStore messageStore;
    private final BrokerController brokerController;
    private TransStatusCheckService transStatusService;
    private ExecutorService checkTranStatusTaskExecutor;

    public TransactionalMessageRocksDBService(MessageStore messageStore, BrokerController brokerController) {
        this.messageStore = messageStore;
        this.transMessageRocksDBStore = messageStore.getTransMessageRocksDBStore();
        this.messageRocksDBStorage = this.transMessageRocksDBStore.getMessageRocksDBStorage();
        this.brokerController = brokerController;
    }

    public void start() {
        if (this.state == 1) {
            return;
        }
        this.initService();
        this.transStatusService.start();
        this.state = 1;
        log.info("TransactionalMessageRocksDBService start success");
    }

    private void initService() {
        this.transStatusService = new TransStatusCheckService();
        this.checkTranStatusTaskExecutor = ThreadUtils.newThreadPoolExecutor((int)2, (int)5, (long)100L, (TimeUnit)TimeUnit.SECONDS, new ArrayBlockingQueue(2000), (ThreadFactory)new ThreadFactoryImpl("Transaction-rocksdb-msg-check-thread", this.brokerController.getBrokerIdentity()), (RejectedExecutionHandler)new ThreadPoolExecutor.CallerRunsPolicy());
    }

    public void shutdown() {
        if (this.state != 1 || this.state == 2) {
            return;
        }
        if (null != this.transStatusService) {
            this.transStatusService.shutdown();
        }
        if (null != this.checkTranStatusTaskExecutor) {
            this.checkTranStatusTaskExecutor.shutdown();
        }
        this.state = 2;
        log.info("TransactionalMessageRocksDBService shutdown success");
    }

    private void checkTransStatus() {
        long count = 0L;
        byte[] lastKey = null;
        try {
            List trs;
            do {
                if (CollectionUtils.isEmpty((Collection)(trs = this.messageRocksDBStorage.scanRecordsForTrans(MessageRocksDBStorage.TRANS_COLUMN_FAMILY, 2000, lastKey)))) {
                    log.info("TransactionalMessageRocksDBService checkTransStatus trs is empty");
                    break;
                }
                count += (long)trs.size();
                this.checkTransRecordsStatus(trs);
            } while (null != (lastKey = trs.size() >= 2000 ? ((TransRocksDBRecord)trs.get(trs.size() - 1)).getKeyBytes() : null));
        }
        catch (Exception e) {
            log.error("TransactionalMessageRocksDBService checkTransStatus error, error: {}, count: {}", (Object)e.getMessage(), (Object)count);
        }
        log.info("TransactionalMessageRocksDBService checkTransStatus count: {}", (Object)count);
    }

    private void checkTransRecordsStatus(List<TransRocksDBRecord> trs) {
        if (CollectionUtils.isEmpty(trs)) {
            log.error("TransactionalMessageRocksDBService checkTransRecordsStatus, trs is empty");
            return;
        }
        try {
            ArrayList<TransRocksDBRecord> updateList = new ArrayList<TransRocksDBRecord>();
            for (TransRocksDBRecord halfRecord : trs) {
                if (null == halfRecord) {
                    log.error("TransactionalMessageRocksDBService checkTransRecordsStatus, halfRecord is null");
                    continue;
                }
                try {
                    if (halfRecord.getCheckTimes() > this.brokerController.getBrokerConfig().getTransactionCheckMax()) {
                        halfRecord.setDelete(true);
                        updateList.add(halfRecord);
                        log.info("TransactionalMessageRocksDBService checkTransRecordsStatus checkTimes > {}, need delete, checkTimes: {}, msgId: {}", new Object[]{this.brokerController.getBrokerConfig().getTransactionCheckMax(), halfRecord.getCheckTimes(), halfRecord.getUniqKey()});
                        continue;
                    }
                    MessageExt msgExt = this.transMessageRocksDBStore.getMessage(halfRecord.getOffsetPy(), halfRecord.getSizePy());
                    if (null == msgExt) {
                        log.error("TransactionalMessageRocksDBService checkTransRecordsStatus, msgExt is null, offsetPy: {}, sizePy: {}", (Object)halfRecord.getOffsetPy(), (Object)halfRecord.getSizePy());
                        halfRecord.setDelete(true);
                        updateList.add(halfRecord);
                        continue;
                    }
                    if (!this.isImmunityTimeExpired(msgExt)) continue;
                    this.resolveHalfMsg(msgExt);
                    halfRecord.setCheckTimes(halfRecord.getCheckTimes() + 1);
                    if (halfRecord.getCheckTimes() > this.brokerController.getBrokerConfig().getTransactionCheckMax()) {
                        halfRecord.setDelete(true);
                        log.info("TransactionalMessageRocksDBService checkTransRecordsStatus checkTimes > {}, need delete, checkTimes: {}, msgId: {}", new Object[]{this.brokerController.getBrokerConfig().getTransactionCheckMax(), halfRecord.getCheckTimes(), halfRecord.getUniqKey()});
                    }
                    updateList.add(halfRecord);
                }
                catch (Exception e) {
                    log.error("TransactionalMessageRocksDBService checkTransRecordsStatus error : {}", (Object)e.getMessage());
                }
            }
            if (!CollectionUtils.isEmpty(updateList)) {
                this.messageRocksDBStorage.updateRecordsForTrans(MessageRocksDBStorage.TRANS_COLUMN_FAMILY, updateList);
            }
        }
        catch (Exception e) {
            log.error("TransactionalMessageRocksDBService checkTransRecordsStatus error: {}", (Object)e.getMessage());
        }
    }

    private boolean isImmunityTimeExpired(MessageExt msgExt) {
        String immunityTimeStr = msgExt.getUserProperty("CHECK_IMMUNITY_TIME_IN_SECONDS");
        long immunityTime = this.brokerController.getBrokerConfig().getTransactionTimeOut();
        if (!StringUtils.isEmpty((CharSequence)immunityTimeStr)) {
            try {
                immunityTime = Long.parseLong(immunityTimeStr);
                immunityTime *= 1000L;
            }
            catch (Exception e) {
                log.error("parse immunityTimesStr error: {}, msgId: {}", (Object)e.getMessage(), (Object)msgExt.getMsgId());
            }
        }
        return System.currentTimeMillis() - msgExt.getBornTimestamp() >= immunityTime;
    }

    private String getServiceThreadName() {
        DefaultMessageStore messageStore;
        String brokerIdentifier = "";
        if (this.messageStore instanceof DefaultMessageStore && (messageStore = (DefaultMessageStore)this.messageStore).getBrokerConfig().isInBrokerContainer()) {
            brokerIdentifier = messageStore.getBrokerConfig().getIdentifier();
        }
        return brokerIdentifier;
    }

    private void resolveHalfMsg(final MessageExt msgExt) {
        if (this.checkTranStatusTaskExecutor != null) {
            this.checkTranStatusTaskExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        TransactionalMessageRocksDBService.this.sendCheckMessage(msgExt);
                    }
                    catch (Exception e) {
                        log.error("TransactionalMessageRocksDBService Send check message error: {}, msgId: {}", (Object)e.getMessage(), (Object)msgExt.getMsgId());
                    }
                }
            });
        } else {
            log.error("TransactionalMessageRocksDBService checkTranStatusTaskExecutor not init, msgId: {}", (Object)msgExt.getMsgId());
        }
    }

    private void sendCheckMessage(MessageExt msgExt) {
        if (null == msgExt) {
            log.info("TransactionalMessageRocksDBService sendCheckMessage msgExt is null");
            return;
        }
        try {
            CheckTransactionStateRequestHeader checkTransactionStateRequestHeader = new CheckTransactionStateRequestHeader();
            checkTransactionStateRequestHeader.setTopic(msgExt.getTopic());
            checkTransactionStateRequestHeader.setCommitLogOffset(Long.valueOf(msgExt.getCommitLogOffset()));
            checkTransactionStateRequestHeader.setOffsetMsgId(msgExt.getMsgId());
            checkTransactionStateRequestHeader.setMsgId(MessageClientIDSetter.getUniqID((Message)msgExt));
            checkTransactionStateRequestHeader.setTransactionId(checkTransactionStateRequestHeader.getMsgId());
            checkTransactionStateRequestHeader.setTranStateTableOffset(Long.valueOf(msgExt.getQueueOffset()));
            checkTransactionStateRequestHeader.setBrokerName(this.brokerController.getBrokerConfig().getBrokerName());
            msgExt.setTopic(msgExt.getUserProperty("REAL_TOPIC"));
            msgExt.setQueueId(Integer.parseInt(msgExt.getUserProperty("REAL_QID")));
            msgExt.setStoreSize(0);
            String groupId = msgExt.getProperty("PGROUP");
            Channel channel = this.brokerController.getProducerManager().getAvailableChannel(groupId);
            if (channel != null) {
                this.brokerController.getBroker2Client().checkProducerTransactionState(groupId, channel, checkTransactionStateRequestHeader, msgExt);
            } else {
                log.warn("TransactionalMessageRocksDBService checkProducerTransactionState failed, channel is null. groupId: {}, msgId: {}", (Object)groupId, (Object)msgExt.getMsgId());
            }
        }
        catch (Exception e) {
            log.error("TransactionalMessageRocksDBService sendCheckMessage error: {}, msgId: {}", (Object)e.getMessage(), (Object)msgExt.getMsgId());
        }
    }

    private class TransStatusCheckService
    extends ServiceThread {
        private final Logger log = TransactionalMessageRocksDBService.access$200();

        private TransStatusCheckService() {
        }

        public String getServiceName() {
            return TransactionalMessageRocksDBService.this.getServiceThreadName() + ((Object)((Object)this)).getClass().getSimpleName();
        }

        public void run() {
            this.log.info(this.getServiceName() + " service start");
            while (!this.isStopped()) {
                try {
                    long begin = System.currentTimeMillis();
                    TransactionalMessageRocksDBService.this.checkTransStatus();
                    this.log.info("TransactionalMessageRocksDBService ScanTransAndStatusCheckService check trans status, check cost: {}", (Object)(System.currentTimeMillis() - begin));
                    this.waitForRunning(TransactionalMessageRocksDBService.this.brokerController.getBrokerConfig().getTransactionCheckInterval());
                }
                catch (Exception e) {
                    this.log.error("TransactionalMessageRocksDBService ScanTransAndStatusCheckService error: {}", (Object)e.getMessage());
                }
            }
            this.log.info(this.getServiceName() + " service end");
        }
    }
}

