/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.broker.pop.orderly;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import io.netty.util.HashedWheelTimer;
import io.netty.util.Timeout;
import io.netty.util.Timer;
import io.netty.util.TimerTask;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.rocketmq.broker.BrokerController;
import org.apache.rocketmq.broker.pop.orderly.ConsumerOrderInfoManager;
import org.apache.rocketmq.broker.pop.orderly.QueueLevelConsumerManager;
import org.apache.rocketmq.common.ThreadFactoryImpl;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;

public class QueueLevelConsumerOrderInfoLockManager {
    private static final Logger POP_LOGGER = LoggerFactory.getLogger((String)"RocketmqPop");
    private ConsumerOrderInfoManager consumerOrderInfoManager;
    private final BrokerController brokerController;
    private final Map<Key, Timeout> timeoutMap = new ConcurrentHashMap<Key, Timeout>();
    private final Timer timer;
    private static final int TIMER_TICK_MS = 100;

    public QueueLevelConsumerOrderInfoLockManager(BrokerController brokerController) {
        this.brokerController = brokerController;
        this.timer = new HashedWheelTimer((ThreadFactory)new ThreadFactoryImpl("ConsumerOrderInfoLockManager_"), 100L, TimeUnit.MILLISECONDS);
    }

    public void recover(Map<String, ConcurrentHashMap<Integer, QueueLevelConsumerManager.OrderInfo>> table) {
        if (!this.brokerController.getBrokerConfig().isEnableNotifyAfterPopOrderLockRelease()) {
            return;
        }
        for (Map.Entry<String, ConcurrentHashMap<Integer, QueueLevelConsumerManager.OrderInfo>> entry : table.entrySet()) {
            String topicAtGroup = entry.getKey();
            ConcurrentHashMap<Integer, QueueLevelConsumerManager.OrderInfo> qs = entry.getValue();
            String[] arrays = QueueLevelConsumerManager.decodeKey(topicAtGroup);
            if (arrays.length != 2) continue;
            String topic = arrays[0];
            String group = arrays[1];
            for (Map.Entry<Integer, QueueLevelConsumerManager.OrderInfo> qsEntry : qs.entrySet()) {
                Long lockFreeTimestamp = qsEntry.getValue().getLockFreeTimestamp();
                if (lockFreeTimestamp == null || lockFreeTimestamp <= System.currentTimeMillis()) continue;
                this.updateLockFreeTimestamp(topic, group, (int)qsEntry.getKey(), lockFreeTimestamp);
            }
        }
    }

    public void updateLockFreeTimestamp(String topic, String group, int queueId, QueueLevelConsumerManager.OrderInfo orderInfo) {
        this.updateLockFreeTimestamp(topic, group, queueId, orderInfo.getLockFreeTimestamp());
    }

    public void updateLockFreeTimestamp(String topic, String group, int queueId, Long lockFreeTimestamp) {
        if (!this.brokerController.getBrokerConfig().isEnableNotifyAfterPopOrderLockRelease()) {
            return;
        }
        if (lockFreeTimestamp == null) {
            return;
        }
        try {
            this.timeoutMap.compute(new Key(topic, group, queueId), (key, oldTimeout) -> {
                try {
                    long delay = lockFreeTimestamp - System.currentTimeMillis();
                    Timeout newTimeout = this.timer.newTimeout((TimerTask)new NotifyLockFreeTimerTask((Key)key), delay, TimeUnit.MILLISECONDS);
                    if (oldTimeout != null) {
                        oldTimeout.cancel();
                    }
                    return newTimeout;
                }
                catch (Exception e) {
                    POP_LOGGER.warn("add timeout task failed. key:{}, lockFreeTimestamp:{}", new Object[]{key, lockFreeTimestamp, e});
                    return oldTimeout;
                }
            });
        }
        catch (Exception e) {
            POP_LOGGER.error("unexpect error when updateLockFreeTimestamp. topic:{}, group:{}, queueId:{}, lockFreeTimestamp:{}", new Object[]{topic, group, queueId, lockFreeTimestamp, e});
        }
    }

    protected void notifyLockIsFree(Key key) {
        try {
            this.brokerController.getPopMessageProcessor().notifyLongPollingRequestIfNeed(key.topic, key.group, key.queueId);
        }
        catch (Exception e) {
            POP_LOGGER.error("unexpect error when notifyLockIsFree. key:{}", (Object)key, (Object)e);
        }
    }

    public void shutdown() {
        this.timer.stop();
    }

    @VisibleForTesting
    protected Map<Key, Timeout> getTimeoutMap() {
        return this.timeoutMap;
    }

    private static class Key {
        private final String topic;
        private final String group;
        private final int queueId;

        public Key(String topic, String group, int queueId) {
            this.topic = topic;
            this.group = group;
            this.queueId = queueId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key key = (Key)o;
            return this.queueId == key.queueId && Objects.equal((Object)this.topic, (Object)key.topic) && Objects.equal((Object)this.group, (Object)key.group);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.topic, this.group, this.queueId});
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("topic", (Object)this.topic).add("group", (Object)this.group).add("queueId", this.queueId).toString();
        }
    }

    private class NotifyLockFreeTimerTask
    implements TimerTask {
        private final Key key;

        private NotifyLockFreeTimerTask(Key key) {
            this.key = key;
        }

        public void run(Timeout timeout) throws Exception {
            if (timeout.isCancelled() || !QueueLevelConsumerOrderInfoLockManager.this.brokerController.getBrokerConfig().isEnableNotifyAfterPopOrderLockRelease()) {
                return;
            }
            QueueLevelConsumerOrderInfoLockManager.this.notifyLockIsFree(this.key);
            QueueLevelConsumerOrderInfoLockManager.this.timeoutMap.computeIfPresent(this.key, (key1, curTimeout) -> {
                if (curTimeout == timeout) {
                    return null;
                }
                return curTimeout;
            });
        }
    }
}

