/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.common.topic;

import java.util.HashSet;
import java.util.Set;
import org.apache.rocketmq.common.UtilAll;

public class TopicValidator {
    public static final String AUTO_CREATE_TOPIC_KEY_TOPIC = "TBW102";
    public static final String RMQ_SYS_SCHEDULE_TOPIC = "SCHEDULE_TOPIC_XXXX";
    public static final String RMQ_SYS_BENCHMARK_TOPIC = "BenchmarkTest";
    public static final String RMQ_SYS_TRANS_HALF_TOPIC = "RMQ_SYS_TRANS_HALF_TOPIC";
    public static final String RMQ_SYS_TRACE_TOPIC = "RMQ_SYS_TRACE_TOPIC";
    public static final String RMQ_SYS_TRANS_OP_HALF_TOPIC = "RMQ_SYS_TRANS_OP_HALF_TOPIC";
    public static final String RMQ_SYS_TRANS_CHECK_MAX_TIME_TOPIC = "TRANS_CHECK_MAX_TIME_TOPIC";
    public static final String RMQ_SYS_SELF_TEST_TOPIC = "SELF_TEST_TOPIC";
    public static final String RMQ_SYS_OFFSET_MOVED_EVENT = "OFFSET_MOVED_EVENT";
    public static final String RMQ_SYS_ROCKSDB_OFFSET_TOPIC = "CHECKPOINT_TOPIC";
    public static final String SYSTEM_TOPIC_PREFIX = "rmq_sys_";
    public static final String SYNC_BROKER_MEMBER_GROUP_PREFIX = "rmq_sys_SYNC_BROKER_MEMBER_";
    public static final boolean[] VALID_CHAR_BIT_MAP = new boolean[128];
    private static final int TOPIC_MAX_LENGTH = 127;
    private static final int GROUP_MAX_LENGTH = 120;
    private static final int RETRY_OR_DLQ_TOPIC_MAX_LENGTH = 255;
    private static final Set<String> SYSTEM_TOPIC_SET = new HashSet<String>();
    private static final Set<String> NOT_ALLOWED_SEND_TOPIC_SET = new HashSet<String>();

    public static boolean isTopicOrGroupIllegal(String str) {
        int strLen = str.length();
        int len = VALID_CHAR_BIT_MAP.length;
        for (int i = 0; i < strLen; ++i) {
            char ch = str.charAt(i);
            if (ch < len && VALID_CHAR_BIT_MAP[ch]) continue;
            return true;
        }
        return false;
    }

    public static ValidateResult validateTopic(String topic) {
        if (UtilAll.isBlank(topic)) {
            return new ValidateResult(false, "The specified topic is blank.");
        }
        if (TopicValidator.isTopicOrGroupIllegal(topic)) {
            String falseRemark = "The specified topic: " + topic + ", contains illegal characters, allowing only ^[%|a-zA-Z0-9_-]+$";
            return new ValidateResult(false, falseRemark);
        }
        if (topic.startsWith("%RETRY%") || topic.startsWith("%DLQ%")) {
            if (topic.length() > 255) {
                String falseRemark = "The specified topic is DLQ or Retry topic: " + topic + ", and it's longer than topic max length: " + 255;
                return new ValidateResult(false, falseRemark);
            }
        } else if (topic.length() > 127) {
            String falseRemark = "The specified topic: " + topic + ", is longer than topic max length: " + 127;
            return new ValidateResult(false, falseRemark);
        }
        return new ValidateResult(true, "");
    }

    public static ValidateResult validateGroup(String group) {
        if (UtilAll.isBlank(group)) {
            return new ValidateResult(false, "The specified group is blank.");
        }
        if (TopicValidator.isTopicOrGroupIllegal(group)) {
            String falseRemark = "The specified group: " + group + ", contains illegal characters, allowing only ^[%|a-zA-Z0-9_-]+$";
            return new ValidateResult(false, falseRemark);
        }
        if (group.length() > 120) {
            String falseRemark = "The specified group: " + group + ", is longer than group max length: " + 120;
            return new ValidateResult(false, falseRemark);
        }
        return new ValidateResult(true, "");
    }

    public static boolean isSystemTopic(String topic) {
        return SYSTEM_TOPIC_SET.contains(topic) || topic.startsWith(SYSTEM_TOPIC_PREFIX);
    }

    public static boolean isNotAllowedSendTopic(String topic) {
        return NOT_ALLOWED_SEND_TOPIC_SET.contains(topic);
    }

    public static void addSystemTopic(String systemTopic) {
        SYSTEM_TOPIC_SET.add(systemTopic);
    }

    public static Set<String> getSystemTopicSet() {
        return SYSTEM_TOPIC_SET;
    }

    public static Set<String> getNotAllowedSendTopicSet() {
        return NOT_ALLOWED_SEND_TOPIC_SET;
    }

    static {
        SYSTEM_TOPIC_SET.add(AUTO_CREATE_TOPIC_KEY_TOPIC);
        SYSTEM_TOPIC_SET.add(RMQ_SYS_SCHEDULE_TOPIC);
        SYSTEM_TOPIC_SET.add(RMQ_SYS_BENCHMARK_TOPIC);
        SYSTEM_TOPIC_SET.add(RMQ_SYS_TRANS_HALF_TOPIC);
        SYSTEM_TOPIC_SET.add(RMQ_SYS_TRACE_TOPIC);
        SYSTEM_TOPIC_SET.add(RMQ_SYS_TRANS_OP_HALF_TOPIC);
        SYSTEM_TOPIC_SET.add(RMQ_SYS_TRANS_CHECK_MAX_TIME_TOPIC);
        SYSTEM_TOPIC_SET.add(RMQ_SYS_SELF_TEST_TOPIC);
        SYSTEM_TOPIC_SET.add(RMQ_SYS_OFFSET_MOVED_EVENT);
        SYSTEM_TOPIC_SET.add(RMQ_SYS_ROCKSDB_OFFSET_TOPIC);
        NOT_ALLOWED_SEND_TOPIC_SET.add(RMQ_SYS_SCHEDULE_TOPIC);
        NOT_ALLOWED_SEND_TOPIC_SET.add(RMQ_SYS_TRANS_HALF_TOPIC);
        NOT_ALLOWED_SEND_TOPIC_SET.add(RMQ_SYS_TRANS_OP_HALF_TOPIC);
        NOT_ALLOWED_SEND_TOPIC_SET.add(RMQ_SYS_TRANS_CHECK_MAX_TIME_TOPIC);
        NOT_ALLOWED_SEND_TOPIC_SET.add(RMQ_SYS_SELF_TEST_TOPIC);
        NOT_ALLOWED_SEND_TOPIC_SET.add(RMQ_SYS_OFFSET_MOVED_EVENT);
        TopicValidator.VALID_CHAR_BIT_MAP[37] = true;
        TopicValidator.VALID_CHAR_BIT_MAP[45] = true;
        TopicValidator.VALID_CHAR_BIT_MAP[95] = true;
        TopicValidator.VALID_CHAR_BIT_MAP[124] = true;
        for (int i = 0; i < VALID_CHAR_BIT_MAP.length; ++i) {
            if (i >= 48 && i <= 57) {
                TopicValidator.VALID_CHAR_BIT_MAP[i] = true;
                continue;
            }
            if (i >= 65 && i <= 90) {
                TopicValidator.VALID_CHAR_BIT_MAP[i] = true;
                continue;
            }
            if (i < 97 || i > 122) continue;
            TopicValidator.VALID_CHAR_BIT_MAP[i] = true;
        }
    }

    public static class ValidateResult {
        private final boolean valid;
        private final String remark;

        public ValidateResult(boolean valid, String remark) {
            this.valid = valid;
            this.remark = remark;
        }

        public boolean isValid() {
            return this.valid;
        }

        public String getRemark() {
            return this.remark;
        }
    }
}

