/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.tieredstore.provider;

import com.google.common.base.Stopwatch;
import com.google.common.io.ByteStreams;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Paths;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.tieredstore.MessageStoreConfig;
import org.apache.rocketmq.tieredstore.MessageStoreExecutor;
import org.apache.rocketmq.tieredstore.common.FileSegmentType;
import org.apache.rocketmq.tieredstore.metrics.TieredStoreMetricsManager;
import org.apache.rocketmq.tieredstore.provider.FileSegment;
import org.apache.rocketmq.tieredstore.stream.FileSegmentInputStream;
import org.apache.rocketmq.tieredstore.util.MessageStoreUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PosixFileSegment
extends FileSegment {
    private static final Logger log = LoggerFactory.getLogger((String)"RocketmqTieredStore");
    private static final String OPERATION_POSIX_READ = "read";
    private static final String OPERATION_POSIX_WRITE = "write";
    private final String fullPath;
    private volatile File file;
    private volatile FileChannel readFileChannel;
    private volatile FileChannel writeFileChannel;

    public PosixFileSegment(MessageStoreConfig storeConfig, FileSegmentType fileType, String filePath, long baseOffset, MessageStoreExecutor executor) {
        super(storeConfig, fileType, filePath, baseOffset, executor);
        String basePath = StringUtils.defaultString((String)storeConfig.getTieredStoreFilePath(), (String)StringUtils.appendIfMissing((String)storeConfig.getTieredStoreFilePath(), (CharSequence)File.separator, (CharSequence[])new CharSequence[0]));
        String clusterName = storeConfig.getBrokerClusterName();
        String clusterBasePath = String.format("%s_%s", MessageStoreUtil.getHash(clusterName), clusterName);
        this.fullPath = Paths.get(basePath, clusterBasePath, filePath, fileType.toString(), MessageStoreUtil.offset2FileName(baseOffset)).toString();
        log.info("Constructing Posix FileSegment, filePath: {}", (Object)this.fullPath);
        this.createFile();
    }

    protected AttributesBuilder newAttributesBuilder() {
        return TieredStoreMetricsManager.newAttributesBuilder().put("path", this.filePath).put("file_type", this.fileType.name().toLowerCase());
    }

    @Override
    public String getPath() {
        return this.filePath;
    }

    @Override
    public long getSize() {
        if (this.exists()) {
            return this.file.length();
        }
        return 0L;
    }

    @Override
    public boolean exists() {
        return this.file != null && this.file.exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createFile() {
        if (this.file == null) {
            PosixFileSegment posixFileSegment = this;
            synchronized (posixFileSegment) {
                if (this.file == null) {
                    this.createFile0();
                }
            }
        }
    }

    private void createFile0() {
        try {
            File file = new File(this.fullPath);
            File dir = file.getParentFile();
            if (!dir.exists()) {
                dir.mkdirs();
            }
            if (!file.exists() && file.createNewFile()) {
                log.debug("Create Posix FileSegment, filePath: {}", (Object)this.fullPath);
            }
            this.readFileChannel = new RandomAccessFile(file, "r").getChannel();
            this.writeFileChannel = new RandomAccessFile(file, "rwd").getChannel();
            this.file = file;
        }
        catch (Exception e) {
            log.error("PosixFileSegment#createFile: create file {} failed: ", (Object)this.filePath, (Object)e);
        }
    }

    @Override
    public void destroyFile() {
        this.close();
        if (this.file != null && this.file.exists()) {
            if (this.file.delete()) {
                log.info("Destroy Posix FileSegment, filePath: {}", (Object)this.fullPath);
            } else {
                log.warn("Destroy Posix FileSegment error, filePath: {}", (Object)this.fullPath);
            }
        }
    }

    @Override
    public void close() {
        super.close();
        try {
            if (this.readFileChannel != null && this.readFileChannel.isOpen()) {
                this.readFileChannel.close();
                this.readFileChannel = null;
            }
            if (this.writeFileChannel != null && this.writeFileChannel.isOpen()) {
                this.writeFileChannel.close();
                this.writeFileChannel = null;
            }
        }
        catch (IOException e) {
            log.error("Destroy Posix FileSegment failed, filePath: {}", (Object)this.fullPath, (Object)e);
        }
    }

    @Override
    public CompletableFuture<ByteBuffer> read0(long position, int length) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        AttributesBuilder attributesBuilder = this.newAttributesBuilder().put("operation", OPERATION_POSIX_READ);
        return CompletableFuture.supplyAsync(() -> {
            ByteBuffer byteBuffer = ByteBuffer.allocate(length);
            try {
                this.readFileChannel.position(position);
                this.readFileChannel.read(byteBuffer);
                byteBuffer.flip();
                byteBuffer.limit(length);
                attributesBuilder.put("success", true);
                long costTime = stopwatch.stop().elapsed(TimeUnit.MILLISECONDS);
                TieredStoreMetricsManager.providerRpcLatency.record(costTime, attributesBuilder.build());
                Attributes metricsAttributes = this.newAttributesBuilder().put("operation", OPERATION_POSIX_READ).build();
                int downloadedBytes = byteBuffer.remaining();
                TieredStoreMetricsManager.downloadBytes.record((long)downloadedBytes, metricsAttributes);
            }
            catch (IOException e) {
                long costTime = stopwatch.stop().elapsed(TimeUnit.MILLISECONDS);
                attributesBuilder.put("success", false);
                TieredStoreMetricsManager.providerRpcLatency.record(costTime, attributesBuilder.build());
            }
            return byteBuffer;
        }, this.executor.bufferFetchExecutor);
    }

    @Override
    public CompletableFuture<Boolean> commit0(FileSegmentInputStream inputStream, long position, int length, boolean append) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        AttributesBuilder attributesBuilder = this.newAttributesBuilder().put("operation", OPERATION_POSIX_WRITE);
        return CompletableFuture.supplyAsync(() -> {
            try {
                byte[] byteArray = ByteStreams.toByteArray((InputStream)inputStream);
                this.writeFileChannel.position(position);
                ByteBuffer buffer = ByteBuffer.wrap(byteArray);
                while (buffer.hasRemaining()) {
                    this.writeFileChannel.write(buffer);
                }
                this.writeFileChannel.force(true);
                attributesBuilder.put("success", true);
                long costTime = stopwatch.stop().elapsed(TimeUnit.MILLISECONDS);
                TieredStoreMetricsManager.providerRpcLatency.record(costTime, attributesBuilder.build());
                Attributes metricsAttributes = this.newAttributesBuilder().put("operation", OPERATION_POSIX_WRITE).build();
                TieredStoreMetricsManager.uploadBytes.record((long)length, metricsAttributes);
            }
            catch (Exception e) {
                long costTime = stopwatch.stop().elapsed(TimeUnit.MILLISECONDS);
                attributesBuilder.put("success", false);
                TieredStoreMetricsManager.providerRpcLatency.record(costTime, attributesBuilder.build());
                return false;
            }
            return true;
        }, this.executor.bufferCommitExecutor);
    }
}

