/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.proxy.remoting.activity;

import io.netty.channel.ChannelHandlerContext;
import java.time.Duration;
import org.apache.rocketmq.broker.client.ConsumerGroupInfo;
import org.apache.rocketmq.common.sysflag.PullSysFlag;
import org.apache.rocketmq.proxy.common.ProxyContext;
import org.apache.rocketmq.proxy.processor.MessagingProcessor;
import org.apache.rocketmq.proxy.remoting.activity.AbstractRemotingActivity;
import org.apache.rocketmq.proxy.remoting.pipeline.RequestPipeline;
import org.apache.rocketmq.remoting.CommandCustomHeader;
import org.apache.rocketmq.remoting.protocol.RemotingCommand;
import org.apache.rocketmq.remoting.protocol.header.PullMessageRequestHeader;
import org.apache.rocketmq.remoting.protocol.heartbeat.SubscriptionData;

public class PullMessageActivity
extends AbstractRemotingActivity {
    public PullMessageActivity(RequestPipeline requestPipeline, MessagingProcessor messagingProcessor) {
        super(requestPipeline, messagingProcessor);
    }

    @Override
    protected RemotingCommand processRequest0(ChannelHandlerContext ctx, RemotingCommand request, ProxyContext context) throws Exception {
        PullMessageRequestHeader requestHeader = (PullMessageRequestHeader)request.decodeCommandCustomHeader(PullMessageRequestHeader.class);
        int sysFlag = requestHeader.getSysFlag();
        if (!PullSysFlag.hasSubscriptionFlag((int)sysFlag)) {
            ConsumerGroupInfo consumerInfo = this.messagingProcessor.getConsumerGroupInfo(requestHeader.getConsumerGroup());
            if (consumerInfo == null) {
                return RemotingCommand.buildErrorResponse((int)25, (String)"the consumer's subscription not latest");
            }
            SubscriptionData subscriptionData = consumerInfo.findSubscriptionData(requestHeader.getTopic());
            if (subscriptionData == null) {
                return RemotingCommand.buildErrorResponse((int)24, (String)"the consumer's subscription not exist");
            }
            requestHeader.setSysFlag(Integer.valueOf(PullSysFlag.buildSysFlagWithSubscription((int)sysFlag)));
            requestHeader.setSubscription(subscriptionData.getSubString());
            requestHeader.setExpressionType(subscriptionData.getExpressionType());
            request.writeCustomHeader((CommandCustomHeader)requestHeader);
            request.makeCustomHeaderToNet();
        }
        long timeoutMillis = requestHeader.getSuspendTimeoutMillis() + Duration.ofSeconds(10L).toMillis();
        return this.request(ctx, request, context, timeoutMillis);
    }
}

