/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.container;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;
import org.apache.rocketmq.broker.BrokerController;
import org.apache.rocketmq.broker.BrokerPathConfigHelper;
import org.apache.rocketmq.broker.out.BrokerOuterAPI;
import org.apache.rocketmq.common.AbstractBrokerRunnable;
import org.apache.rocketmq.common.BrokerConfig;
import org.apache.rocketmq.common.BrokerIdentity;
import org.apache.rocketmq.common.ThreadFactoryImpl;
import org.apache.rocketmq.common.utils.ThreadUtils;
import org.apache.rocketmq.container.BrokerBootHook;
import org.apache.rocketmq.container.BrokerContainerConfig;
import org.apache.rocketmq.container.BrokerContainerProcessor;
import org.apache.rocketmq.container.ContainerClientHouseKeepingService;
import org.apache.rocketmq.container.IBrokerContainer;
import org.apache.rocketmq.container.InnerBrokerController;
import org.apache.rocketmq.container.InnerSalveBrokerController;
import org.apache.rocketmq.container.logback.BrokerLogbackConfigurator;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.remoting.ChannelEventListener;
import org.apache.rocketmq.remoting.Configuration;
import org.apache.rocketmq.remoting.RPCHook;
import org.apache.rocketmq.remoting.RemotingServer;
import org.apache.rocketmq.remoting.netty.NettyClientConfig;
import org.apache.rocketmq.remoting.netty.NettyRemotingServer;
import org.apache.rocketmq.remoting.netty.NettyRequestProcessor;
import org.apache.rocketmq.remoting.netty.NettyServerConfig;
import org.apache.rocketmq.store.config.BrokerRole;
import org.apache.rocketmq.store.config.MessageStoreConfig;

public class BrokerContainer
implements IBrokerContainer {
    private static final Logger LOG = LoggerFactory.getLogger((String)"RocketmqBroker");
    private final ScheduledExecutorService scheduledExecutorService = new ScheduledThreadPoolExecutor(1, (ThreadFactory)new BasicThreadFactory.Builder().namingPattern("BrokerContainerScheduledThread").daemon(true).build());
    private final NettyServerConfig nettyServerConfig;
    private final NettyClientConfig nettyClientConfig;
    private final BrokerOuterAPI brokerOuterAPI;
    private final ContainerClientHouseKeepingService containerClientHouseKeepingService;
    private final ConcurrentMap<BrokerIdentity, InnerSalveBrokerController> slaveBrokerControllers = new ConcurrentHashMap<BrokerIdentity, InnerSalveBrokerController>();
    private final ConcurrentMap<BrokerIdentity, InnerBrokerController> masterBrokerControllers = new ConcurrentHashMap<BrokerIdentity, InnerBrokerController>();
    private final ConcurrentMap<BrokerIdentity, InnerBrokerController> dLedgerBrokerControllers = new ConcurrentHashMap<BrokerIdentity, InnerBrokerController>();
    private final List<BrokerBootHook> brokerBootHookList = new ArrayList<BrokerBootHook>();
    private final BrokerContainerProcessor brokerContainerProcessor;
    private final Configuration configuration;
    private final BrokerContainerConfig brokerContainerConfig;
    private RemotingServer remotingServer;
    private RemotingServer fastRemotingServer;
    private ExecutorService brokerContainerExecutor;

    public BrokerContainer(BrokerContainerConfig brokerContainerConfig, NettyServerConfig nettyServerConfig, NettyClientConfig nettyClientConfig) {
        this.brokerContainerConfig = brokerContainerConfig;
        this.nettyServerConfig = nettyServerConfig;
        this.nettyClientConfig = nettyClientConfig;
        this.brokerOuterAPI = new BrokerOuterAPI(nettyClientConfig);
        this.brokerContainerProcessor = new BrokerContainerProcessor(this);
        this.brokerContainerProcessor.registerBrokerBootHook(this.brokerBootHookList);
        this.containerClientHouseKeepingService = new ContainerClientHouseKeepingService(this);
        this.configuration = new Configuration(LOG, BrokerPathConfigHelper.getBrokerConfigPath(), new Object[]{this.brokerContainerConfig, this.nettyServerConfig, this.nettyClientConfig});
    }

    @Override
    public String getBrokerContainerAddr() {
        return this.brokerContainerConfig.getBrokerContainerIP() + ":" + this.nettyServerConfig.getListenPort();
    }

    @Override
    public BrokerContainerConfig getBrokerContainerConfig() {
        return this.brokerContainerConfig;
    }

    @Override
    public NettyServerConfig getNettyServerConfig() {
        return this.nettyServerConfig;
    }

    @Override
    public NettyClientConfig getNettyClientConfig() {
        return this.nettyClientConfig;
    }

    @Override
    public BrokerOuterAPI getBrokerOuterAPI() {
        return this.brokerOuterAPI;
    }

    @Override
    public RemotingServer getRemotingServer() {
        return this.remotingServer;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    private void updateNamesrvAddr() {
        if (this.brokerContainerConfig.isFetchNameSrvAddrByDnsLookup()) {
            this.brokerOuterAPI.updateNameServerAddressListByDnsLookup(this.brokerContainerConfig.getNamesrvAddr());
        } else {
            this.brokerOuterAPI.updateNameServerAddressList(this.brokerContainerConfig.getNamesrvAddr());
        }
    }

    public boolean initialize() {
        this.remotingServer = new NettyRemotingServer(this.nettyServerConfig, (ChannelEventListener)this.containerClientHouseKeepingService);
        this.fastRemotingServer = this.remotingServer.newRemotingServer(this.nettyServerConfig.getListenPort() - 2);
        this.brokerContainerExecutor = new ThreadPoolExecutor(1, 1, 60000L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(10000), (ThreadFactory)new ThreadFactoryImpl("SharedBrokerThread_"));
        this.registerProcessor();
        if (this.brokerContainerConfig.getNamesrvAddr() != null) {
            this.updateNamesrvAddr();
            LOG.info("Set user specified name server address: {}", (Object)this.brokerContainerConfig.getNamesrvAddr());
            this.scheduledExecutorService.scheduleAtFixedRate((Runnable)new AbstractBrokerRunnable(BrokerIdentity.BROKER_CONTAINER_IDENTITY){

                public void run0() {
                    try {
                        BrokerContainer.this.updateNamesrvAddr();
                    }
                    catch (Throwable e) {
                        LOG.error("ScheduledTask fetchNameServerAddr exception", e);
                    }
                }
            }, 10000L, 120000L, TimeUnit.MILLISECONDS);
        } else if (this.brokerContainerConfig.isFetchNamesrvAddrByAddressServer()) {
            this.scheduledExecutorService.scheduleAtFixedRate((Runnable)new AbstractBrokerRunnable(BrokerIdentity.BROKER_CONTAINER_IDENTITY){

                public void run0() {
                    try {
                        BrokerContainer.this.brokerOuterAPI.fetchNameServerAddr();
                    }
                    catch (Throwable e) {
                        LOG.error("ScheduledTask fetchNameServerAddr exception", e);
                    }
                }
            }, 10000L, 120000L, TimeUnit.MILLISECONDS);
        }
        this.scheduledExecutorService.scheduleAtFixedRate((Runnable)new AbstractBrokerRunnable(BrokerIdentity.BROKER_CONTAINER_IDENTITY){

            public void run0() {
                try {
                    BrokerContainer.this.brokerOuterAPI.refreshMetadata();
                }
                catch (Exception e) {
                    LOG.error("ScheduledTask refresh metadata exception", (Throwable)e);
                }
            }
        }, 10L, 5L, TimeUnit.SECONDS);
        return true;
    }

    private void registerProcessor() {
        this.remotingServer.registerDefaultProcessor((NettyRequestProcessor)this.brokerContainerProcessor, this.brokerContainerExecutor);
        this.fastRemotingServer.registerDefaultProcessor((NettyRequestProcessor)this.brokerContainerProcessor, this.brokerContainerExecutor);
    }

    @Override
    public void start() throws Exception {
        if (this.remotingServer != null) {
            this.remotingServer.start();
        }
        if (this.fastRemotingServer != null) {
            this.fastRemotingServer.start();
        }
        if (this.brokerOuterAPI != null) {
            this.brokerOuterAPI.start();
        }
    }

    @Override
    public void shutdown() {
        for (InnerSalveBrokerController slaveBrokerController : this.slaveBrokerControllers.values()) {
            slaveBrokerController.shutdown();
        }
        this.slaveBrokerControllers.clear();
        for (BrokerController masterBrokerController : this.masterBrokerControllers.values()) {
            masterBrokerController.shutdown();
        }
        this.masterBrokerControllers.clear();
        this.dLedgerBrokerControllers.values().forEach(InnerBrokerController::shutdown);
        this.dLedgerBrokerControllers.clear();
        if (this.remotingServer != null) {
            this.remotingServer.shutdown();
        }
        if (this.fastRemotingServer != null) {
            this.fastRemotingServer.shutdown();
        }
        ThreadUtils.shutdown((ExecutorService)this.brokerContainerExecutor);
        if (this.brokerOuterAPI != null) {
            this.brokerOuterAPI.shutdown();
        }
    }

    public void registerClientRPCHook(RPCHook rpcHook) {
        this.getBrokerOuterAPI().registerRPCHook(rpcHook);
    }

    public void clearClientRPCHook() {
        this.getBrokerOuterAPI().clearRPCHook();
    }

    public List<BrokerBootHook> getBrokerBootHookList() {
        return this.brokerBootHookList;
    }

    public void registerBrokerBootHook(BrokerBootHook brokerBootHook) {
        this.brokerBootHookList.add(brokerBootHook);
        LOG.info("register BrokerBootHook, {}", (Object)brokerBootHook.hookName());
    }

    @Override
    public InnerBrokerController addBroker(BrokerConfig brokerConfig, MessageStoreConfig storeConfig) throws Exception {
        if (storeConfig.isEnableDLegerCommitLog()) {
            return this.addDLedgerBroker(brokerConfig, storeConfig);
        }
        if (brokerConfig.getBrokerId() == 0L && storeConfig.getBrokerRole() != BrokerRole.SLAVE) {
            return this.addMasterBroker(brokerConfig, storeConfig);
        }
        if (brokerConfig.getBrokerId() != 0L && storeConfig.getBrokerRole() == BrokerRole.SLAVE) {
            return this.addSlaveBroker(brokerConfig, storeConfig);
        }
        return null;
    }

    public InnerBrokerController addDLedgerBroker(BrokerConfig brokerConfig, MessageStoreConfig storeConfig) throws Exception {
        brokerConfig.setInBrokerContainer(true);
        if (storeConfig.isDuplicationEnable()) {
            LOG.error("Can not add broker to container when duplicationEnable is true currently");
            throw new Exception("Can not add broker to container when duplicationEnable is true currently");
        }
        InnerBrokerController brokerController = new InnerBrokerController(this, brokerConfig, storeConfig);
        BrokerIdentity brokerIdentity = brokerController.getBrokerIdentity();
        BrokerController previousBroker = this.dLedgerBrokerControllers.putIfAbsent(brokerIdentity, brokerController);
        if (previousBroker == null) {
            try {
                BrokerLogbackConfigurator.doConfigure(brokerIdentity);
                boolean initResult = brokerController.initialize();
                if (!initResult) {
                    this.dLedgerBrokerControllers.remove(brokerIdentity);
                    brokerController.shutdown();
                    throw new Exception("Failed to init dLedger broker " + brokerIdentity.getCanonicalName());
                }
            }
            catch (Exception e) {
                this.dLedgerBrokerControllers.remove(brokerIdentity);
                brokerController.shutdown();
                throw new Exception("Failed to initialize dLedger broker " + brokerIdentity.getCanonicalName(), e);
            }
            return brokerController;
        }
        throw new Exception(brokerIdentity.getCanonicalName() + " has already been added to current broker container");
    }

    public InnerBrokerController addMasterBroker(BrokerConfig masterBrokerConfig, MessageStoreConfig storeConfig) throws Exception {
        masterBrokerConfig.setInBrokerContainer(true);
        if (storeConfig.isDuplicationEnable()) {
            LOG.error("Can not add broker to container when duplicationEnable is true currently");
            throw new Exception("Can not add broker to container when duplicationEnable is true currently");
        }
        InnerBrokerController masterBroker = new InnerBrokerController(this, masterBrokerConfig, storeConfig);
        BrokerIdentity brokerIdentity = masterBroker.getBrokerIdentity();
        BrokerController previousBroker = this.masterBrokerControllers.putIfAbsent(brokerIdentity, masterBroker);
        if (previousBroker == null) {
            try {
                BrokerLogbackConfigurator.doConfigure((BrokerIdentity)masterBrokerConfig);
                boolean initResult = masterBroker.initialize();
                if (!initResult) {
                    this.masterBrokerControllers.remove(brokerIdentity);
                    masterBroker.shutdown();
                    throw new Exception("Failed to init master broker " + masterBrokerConfig.getCanonicalName());
                }
                for (InnerSalveBrokerController slaveBroker : this.getSlaveBrokers()) {
                    if (slaveBroker.getMessageStore().getMasterStoreInProcess() != null) continue;
                    slaveBroker.getMessageStore().setMasterStoreInProcess(masterBroker.getMessageStore());
                }
            }
            catch (Exception e) {
                this.masterBrokerControllers.remove(brokerIdentity);
                masterBroker.shutdown();
                throw new Exception("Failed to initialize master broker " + masterBrokerConfig.getCanonicalName(), e);
            }
            return masterBroker;
        }
        throw new Exception(masterBrokerConfig.getCanonicalName() + " has already been added to current broker container");
    }

    public InnerSalveBrokerController addSlaveBroker(BrokerConfig slaveBrokerConfig, MessageStoreConfig storeConfig) throws Exception {
        slaveBrokerConfig.setInBrokerContainer(true);
        if (storeConfig.isDuplicationEnable()) {
            LOG.error("Can not add broker to container when duplicationEnable is true currently");
            throw new Exception("Can not add broker to container when duplicationEnable is true currently");
        }
        int ratio = storeConfig.getAccessMessageInMemoryMaxRatio() - 10;
        storeConfig.setAccessMessageInMemoryMaxRatio(Math.max(ratio, 0));
        InnerSalveBrokerController slaveBroker = new InnerSalveBrokerController(this, slaveBrokerConfig, storeConfig);
        BrokerIdentity brokerIdentity = slaveBroker.getBrokerIdentity();
        InnerSalveBrokerController previousBroker = this.slaveBrokerControllers.putIfAbsent(brokerIdentity, slaveBroker);
        if (previousBroker == null) {
            try {
                BrokerLogbackConfigurator.doConfigure((BrokerIdentity)slaveBrokerConfig);
                boolean initResult = slaveBroker.initialize();
                if (!initResult) {
                    this.slaveBrokerControllers.remove(brokerIdentity);
                    slaveBroker.shutdown();
                    throw new Exception("Failed to init slave broker " + slaveBrokerConfig.getCanonicalName());
                }
                BrokerController masterBroker = this.peekMasterBroker();
                if (slaveBroker.getMessageStore().getMasterStoreInProcess() == null && masterBroker != null) {
                    slaveBroker.getMessageStore().setMasterStoreInProcess(masterBroker.getMessageStore());
                }
            }
            catch (Exception e) {
                this.slaveBrokerControllers.remove(brokerIdentity);
                slaveBroker.shutdown();
                throw new Exception("Failed to initialize slave broker " + slaveBrokerConfig.getCanonicalName(), e);
            }
            return slaveBroker;
        }
        throw new Exception(slaveBrokerConfig.getCanonicalName() + " has already been added to current broker container");
    }

    @Override
    public BrokerController removeBroker(BrokerIdentity brokerIdentity) throws Exception {
        InnerBrokerController dLedgerController = (InnerBrokerController)((Object)this.dLedgerBrokerControllers.remove(brokerIdentity));
        if (dLedgerController != null) {
            dLedgerController.shutdown();
            return dLedgerController;
        }
        InnerSalveBrokerController slaveBroker = (InnerSalveBrokerController)((Object)this.slaveBrokerControllers.remove(brokerIdentity));
        if (slaveBroker != null) {
            slaveBroker.shutdown();
            return slaveBroker;
        }
        BrokerController masterBroker = (BrokerController)this.masterBrokerControllers.remove(brokerIdentity);
        BrokerController nextMasterBroker = this.peekMasterBroker();
        for (InnerSalveBrokerController slave : this.getSlaveBrokers()) {
            if (nextMasterBroker == null) {
                slave.getMessageStore().setMasterStoreInProcess(null);
                continue;
            }
            slave.getMessageStore().setMasterStoreInProcess(nextMasterBroker.getMessageStore());
        }
        if (masterBroker != null) {
            masterBroker.shutdown();
            return masterBroker;
        }
        return null;
    }

    @Override
    public BrokerController getBroker(BrokerIdentity brokerIdentity) {
        InnerSalveBrokerController slaveBroker = (InnerSalveBrokerController)((Object)this.slaveBrokerControllers.get(brokerIdentity));
        if (slaveBroker != null) {
            return slaveBroker;
        }
        return (BrokerController)this.masterBrokerControllers.get(brokerIdentity);
    }

    @Override
    public Collection<InnerBrokerController> getMasterBrokers() {
        return this.masterBrokerControllers.values();
    }

    @Override
    public Collection<InnerSalveBrokerController> getSlaveBrokers() {
        return this.slaveBrokerControllers.values();
    }

    @Override
    public List<BrokerController> getBrokerControllers() {
        ArrayList<BrokerController> brokerControllers = new ArrayList<BrokerController>();
        brokerControllers.addAll(this.getMasterBrokers());
        brokerControllers.addAll(this.getSlaveBrokers());
        return brokerControllers;
    }

    @Override
    public BrokerController peekMasterBroker() {
        if (!this.masterBrokerControllers.isEmpty()) {
            return (BrokerController)this.masterBrokerControllers.values().iterator().next();
        }
        return null;
    }

    public BrokerController findBrokerControllerByBrokerName(String brokerName) {
        for (BrokerController brokerController : this.masterBrokerControllers.values()) {
            if (!brokerController.getBrokerConfig().getBrokerName().equals(brokerName)) continue;
            return brokerController;
        }
        for (BrokerController brokerController : this.slaveBrokerControllers.values()) {
            if (!brokerController.getBrokerConfig().getBrokerName().equals(brokerName)) continue;
            return brokerController;
        }
        return null;
    }
}

