/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.proxy.service.mqclient;

import java.time.Duration;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.client.ClientConfig;
import org.apache.rocketmq.client.impl.ClientRemotingProcessor;
import org.apache.rocketmq.proxy.common.StartAndShutdown;
import org.apache.rocketmq.proxy.config.ConfigurationManager;
import org.apache.rocketmq.proxy.config.ProxyConfig;
import org.apache.rocketmq.proxy.service.mqclient.MQClientAPIExt;
import org.apache.rocketmq.remoting.RPCHook;
import org.apache.rocketmq.remoting.netty.NettyClientConfig;

public class MQClientAPIFactory
implements StartAndShutdown {
    private MQClientAPIExt[] clients;
    private final String namePrefix;
    private final int clientNum;
    private final ClientRemotingProcessor clientRemotingProcessor;
    private final RPCHook rpcHook;
    private final ScheduledExecutorService scheduledExecutorService;

    public MQClientAPIFactory(String namePrefix, int clientNum, ClientRemotingProcessor clientRemotingProcessor, RPCHook rpcHook, ScheduledExecutorService scheduledExecutorService) {
        this.namePrefix = namePrefix;
        this.clientNum = clientNum;
        this.clientRemotingProcessor = clientRemotingProcessor;
        this.rpcHook = rpcHook;
        this.scheduledExecutorService = scheduledExecutorService;
        this.init();
    }

    protected void init() {
        System.setProperty("com.rocketmq.sendMessageWithVIPChannel", "false");
        ProxyConfig proxyConfig = ConfigurationManager.getProxyConfig();
        if (StringUtils.isEmpty((CharSequence)proxyConfig.getNamesrvDomain())) {
            System.setProperty("rocketmq.namesrv.addr", proxyConfig.getNamesrvAddr());
        } else {
            System.setProperty("rocketmq.namesrv.domain", proxyConfig.getNamesrvDomain());
            System.setProperty("rocketmq.namesrv.domain.subgroup", proxyConfig.getNamesrvDomainSubgroup());
        }
    }

    public MQClientAPIExt getClient() {
        if (this.clients.length == 1) {
            return this.clients[0];
        }
        int index = ThreadLocalRandom.current().nextInt(this.clients.length);
        return this.clients[index];
    }

    @Override
    public void start() throws Exception {
        this.clients = new MQClientAPIExt[this.clientNum];
        for (int i = 0; i < this.clientNum; ++i) {
            this.clients[i] = this.createAndStart(this.namePrefix + "N_" + i);
        }
    }

    @Override
    public void shutdown() throws Exception {
        for (int i = 0; i < this.clientNum; ++i) {
            this.clients[i].shutdown();
        }
    }

    protected MQClientAPIExt createAndStart(String instanceName) {
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.setInstanceName(instanceName);
        clientConfig.setDecodeReadBody(true);
        clientConfig.setDecodeDecompressBody(false);
        NettyClientConfig nettyClientConfig = new NettyClientConfig();
        nettyClientConfig.setDisableCallbackExecutor(true);
        MQClientAPIExt mqClientAPIExt = new MQClientAPIExt(clientConfig, nettyClientConfig, this.clientRemotingProcessor, this.rpcHook);
        if (!mqClientAPIExt.updateNameServerAddressList()) {
            this.scheduledExecutorService.scheduleAtFixedRate(() -> ((MQClientAPIExt)mqClientAPIExt).fetchNameServerAddr(), Duration.ofSeconds(10L).toMillis(), Duration.ofMinutes(2L).toMillis(), TimeUnit.MILLISECONDS);
        }
        mqClientAPIExt.start();
        return mqClientAPIExt;
    }
}

