/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.proxy.service.channel;

import io.netty.channel.ChannelFuture;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.rocketmq.proxy.config.ConfigurationManager;
import org.apache.rocketmq.proxy.service.channel.InvocationContextInterface;
import org.apache.rocketmq.proxy.service.channel.SimpleChannel;
import org.apache.rocketmq.remoting.protocol.RemotingCommand;

public class InvocationChannel
extends SimpleChannel {
    protected final ConcurrentMap<Integer, InvocationContextInterface> inFlightRequestMap = new ConcurrentHashMap<Integer, InvocationContextInterface>();

    public InvocationChannel(String remoteAddress, String localAddress) {
        super(remoteAddress, localAddress);
    }

    @Override
    public ChannelFuture writeAndFlush(Object msg) {
        if (msg instanceof RemotingCommand) {
            RemotingCommand responseCommand = (RemotingCommand)msg;
            InvocationContextInterface context = (InvocationContextInterface)this.inFlightRequestMap.remove(responseCommand.getOpaque());
            if (null != context) {
                context.handle(responseCommand);
            }
            this.inFlightRequestMap.remove(responseCommand.getOpaque());
        }
        return super.writeAndFlush(msg);
    }

    public boolean isWritable() {
        return this.inFlightRequestMap.size() > 0;
    }

    @Override
    public void registerInvocationContext(int opaque, InvocationContextInterface context) {
        this.inFlightRequestMap.put(opaque, context);
    }

    @Override
    public void eraseInvocationContext(int opaque) {
        this.inFlightRequestMap.remove(opaque);
    }

    @Override
    public void clearExpireContext() {
        Iterator iterator = this.inFlightRequestMap.entrySet().iterator();
        int count = 0;
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (!((InvocationContextInterface)entry.getValue()).expired(ConfigurationManager.getProxyConfig().getChannelExpiredInSeconds())) continue;
            iterator.remove();
            ++count;
            log.debug("An expired request is found, request: {}", entry.getValue());
        }
        if (count > 0) {
            log.warn("[BUG] {} expired in-flight requests is cleaned.", (Object)count);
        }
    }
}

