/*
 * Decompiled with CFR 0.152.
 */
package io.openmessaging.storage.dledger.entry;

public class DLedgerEntry {
    public static final int POS_OFFSET = 24;
    public static final int HEADER_SIZE = 44;
    public static final int BODY_OFFSET = 48;
    private int magic;
    private int size;
    private long index;
    private long term;
    private long pos;
    private int channel;
    private int chainCrc;
    private int bodyCrc;
    private byte[] body;

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public int getMagic() {
        return this.magic;
    }

    public void setMagic(int magic) {
        this.magic = magic;
    }

    public long getTerm() {
        return this.term;
    }

    public void setTerm(long term) {
        this.term = term;
    }

    public long getIndex() {
        return this.index;
    }

    public void setIndex(long index) {
        this.index = index;
    }

    public int getChainCrc() {
        return this.chainCrc;
    }

    public void setChainCrc(int chainCrc) {
        this.chainCrc = chainCrc;
    }

    public byte[] getBody() {
        return this.body;
    }

    public void setBody(byte[] body) {
        this.body = body;
    }

    public int getBodyCrc() {
        return this.bodyCrc;
    }

    public void setBodyCrc(int bodyCrc) {
        this.bodyCrc = bodyCrc;
    }

    public int computeSizeInBytes() {
        this.size = 48 + this.body.length;
        return this.size;
    }

    public long getPos() {
        return this.pos;
    }

    public void setPos(long pos) {
        this.pos = pos;
    }

    public boolean equals(Object entry) {
        if (entry == null || !(entry instanceof DLedgerEntry)) {
            return false;
        }
        DLedgerEntry other = (DLedgerEntry)entry;
        if (this.size != other.size || this.magic != other.magic || this.index != other.index || this.term != other.term || this.channel != other.channel || this.pos != other.pos) {
            return false;
        }
        if (this.body == null) {
            return other.body == null;
        }
        if (other.body == null) {
            return false;
        }
        if (this.body.length != other.body.length) {
            return false;
        }
        for (int i = 0; i < this.body.length; ++i) {
            if (this.body[i] == other.body[i]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int prime = 31;
        int h = 1;
        h = 31 * h + this.size;
        h = 31 * h + this.magic;
        h = 31 * h + (int)this.index;
        h = 31 * h + (int)this.term;
        h = 31 * h + this.channel;
        h = 31 * h + (int)this.pos;
        if (this.body != null) {
            for (int i = 0; i < this.body.length; ++i) {
                h = 31 * h + this.body[i];
            }
        } else {
            h = 31 * h;
        }
        return h;
    }

    public int getChannel() {
        return this.channel;
    }

    public void setChannel(int channel) {
        this.channel = channel;
    }
}

