/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.tools.command.acl;

import java.lang.reflect.Field;
import java.util.List;
import java.util.Set;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.rocketmq.client.exception.MQBrokerException;
import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.rocketmq.common.AclConfig;
import org.apache.rocketmq.common.PlainAccessConfig;
import org.apache.rocketmq.remoting.RPCHook;
import org.apache.rocketmq.remoting.exception.RemotingException;
import org.apache.rocketmq.srvutil.ServerUtil;
import org.apache.rocketmq.tools.admin.DefaultMQAdminExt;
import org.apache.rocketmq.tools.command.CommandUtil;
import org.apache.rocketmq.tools.command.SubCommand;
import org.apache.rocketmq.tools.command.SubCommandException;

public class GetAccessConfigSubCommand
implements SubCommand {
    @Override
    public String commandName() {
        return "getAclConfig";
    }

    @Override
    public String commandAlias() {
        return "getAccessConfigSubCommand";
    }

    @Override
    public String commandDesc() {
        return "List all of acl config information in cluster";
    }

    @Override
    public Options buildCommandlineOptions(Options options) {
        OptionGroup optionGroup = new OptionGroup();
        Option opt = new Option("b", "brokerAddr", true, "query acl config version for which broker");
        optionGroup.addOption(opt);
        opt = new Option("c", "clusterName", true, "query acl config version for specified cluster");
        optionGroup.addOption(opt);
        optionGroup.setRequired(true);
        options.addOptionGroup(optionGroup);
        return options;
    }

    @Override
    public void execute(CommandLine commandLine, Options options, RPCHook rpcHook) throws SubCommandException {
        DefaultMQAdminExt defaultMQAdminExt = new DefaultMQAdminExt(rpcHook);
        defaultMQAdminExt.setInstanceName(Long.toString(System.currentTimeMillis()));
        try {
            if (commandLine.hasOption('b')) {
                String addr = commandLine.getOptionValue('b').trim();
                defaultMQAdminExt.start();
                this.printClusterBaseInfo(defaultMQAdminExt, addr);
                return;
            }
            if (commandLine.hasOption('c')) {
                String clusterName = commandLine.getOptionValue('c').trim();
                defaultMQAdminExt.start();
                Set<String> masterSet = CommandUtil.fetchMasterAddrByClusterName(defaultMQAdminExt, clusterName);
                for (String addr : masterSet) {
                    this.printClusterBaseInfo(defaultMQAdminExt, addr);
                }
                return;
            }
            ServerUtil.printCommandLineHelp((String)("mqadmin " + this.commandName()), (Options)options);
        }
        catch (Exception e) {
            throw new SubCommandException(this.getClass().getSimpleName() + " command failed", e);
        }
        finally {
            defaultMQAdminExt.shutdown();
        }
    }

    private void printClusterBaseInfo(DefaultMQAdminExt defaultMQAdminExt, String addr) throws InterruptedException, MQBrokerException, RemotingException, MQClientException, IllegalAccessException {
        AclConfig aclConfig = defaultMQAdminExt.examineBrokerClusterAclConfig(addr);
        List configs = aclConfig.getPlainAccessConfigs();
        List globalWhiteAddrs = aclConfig.getGlobalWhiteAddrs();
        System.out.printf("\n", new Object[0]);
        System.out.printf("%-20s: %s\n", "globalWhiteRemoteAddresses", globalWhiteAddrs.toString());
        System.out.printf("\n", new Object[0]);
        System.out.printf("accounts:\n", new Object[0]);
        if (configs != null && configs.size() > 0) {
            for (PlainAccessConfig config : configs) {
                Field[] fields;
                for (Field field : fields = config.getClass().getDeclaredFields()) {
                    field.setAccessible(true);
                    if (field.get(config) != null) {
                        System.out.printf("%-1s %-18s: %s\n", "", field.getName(), field.get(config).toString());
                        continue;
                    }
                    System.out.printf("%-1s %-18s: %s\n", "", field.getName(), "");
                }
                System.out.printf("\n", new Object[0]);
            }
        }
    }
}

