/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.model.validation;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.thirdparty.com.google.common.collect.Sets;
import org.apache.ranger.plugin.errors.ValidationErrorCode;
import org.apache.ranger.plugin.model.RangerService;
import org.apache.ranger.plugin.model.RangerServiceDef;
import org.apache.ranger.plugin.model.validation.RangerValidator;
import org.apache.ranger.plugin.model.validation.ValidationFailureDetails;
import org.apache.ranger.plugin.model.validation.ValidationFailureDetailsBuilder;
import org.apache.ranger.plugin.store.ServiceStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerServiceValidator
extends RangerValidator {
    private static final Logger LOG = LoggerFactory.getLogger(RangerServiceValidator.class);
    private static final Pattern SERVICE_NAME_VALIDATION_REGEX = Pattern.compile("^[a-zA-Z0-9_-][a-zA-Z0-9_-]{0,254}", 2);
    private static final Pattern LEGACY_SERVICE_NAME_VALIDATION_REGEX = Pattern.compile("^[a-zA-Z0-9_-][a-zA-Z0-9\\s_-]{0,254}", 2);
    private static final Pattern SERVICE_DISPLAY_NAME_VALIDATION_REGEX = Pattern.compile("^[a-zA-Z0-9_-][a-zA-Z0-9\\s_-]{0,254}", 2);

    public RangerServiceValidator(ServiceStore store) {
        super(store);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validate(RangerService service, RangerValidator.Action action) throws Exception {
        String message;
        boolean valid;
        block5: {
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("==> RangerServiceValidator.validate(%s, %s)", new Object[]{service, action}));
            }
            ArrayList<ValidationFailureDetails> failures = new ArrayList<ValidationFailureDetails>();
            valid = this.isValid(service, action, failures);
            message = "";
            try {
                if (valid) break block5;
                message = RangerServiceValidator.serializeFailures(failures);
                throw new Exception(message);
            }
            catch (Throwable throwable) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(String.format("<== RangerServiceValidator.validate(%s, %s): %s, reason[%s]", new Object[]{service, action, valid, message}));
                }
                throw throwable;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("<== RangerServiceValidator.validate(%s, %s): %s, reason[%s]", new Object[]{service, action, valid, message}));
        }
    }

    @Override
    boolean isValid(Long id, RangerValidator.Action action, List<ValidationFailureDetails> failures) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerServiceValidator.isValid(" + id + ")");
        }
        boolean valid = true;
        if (action != RangerValidator.Action.DELETE) {
            ValidationErrorCode error = ValidationErrorCode.SERVICE_VALIDATION_ERR_UNSUPPORTED_ACTION;
            failures.add(new ValidationFailureDetailsBuilder().isAnInternalError().errorCode(error.getErrorCode()).becauseOf(error.getMessage(new Object[]{action})).build());
            valid = false;
        } else if (id == null) {
            ValidationErrorCode error = ValidationErrorCode.SERVICE_VALIDATION_ERR_MISSING_FIELD;
            failures.add(new ValidationFailureDetailsBuilder().field("id").isMissing().errorCode(error.getErrorCode()).becauseOf(error.getMessage(id)).build());
            valid = false;
        } else if (this.getService(id) == null && LOG.isDebugEnabled()) {
            LOG.debug("No service found for id[" + id + "]! ok!");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerServiceValidator.isValid(" + id + "): " + valid);
        }
        return valid;
    }

    boolean isValid(RangerService service, RangerValidator.Action action, List<ValidationFailureDetails> failures) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerServiceValidator.isValid(" + service + ")");
        }
        if (action != RangerValidator.Action.CREATE && action != RangerValidator.Action.UPDATE) {
            throw new IllegalArgumentException("isValid(RangerService, ...) is only supported for CREATE/UPDATE");
        }
        boolean valid = true;
        if (service == null) {
            ValidationErrorCode error = ValidationErrorCode.SERVICE_VALIDATION_ERR_NULL_SERVICE_OBJECT;
            failures.add(new ValidationFailureDetailsBuilder().field("service").isMissing().errorCode(error.getErrorCode()).becauseOf(error.getMessage(new Object[0])).build());
            valid = false;
        } else {
            RangerService maybeTagService;
            String tagServiceName;
            Set<String> inputParameters;
            Set<String> reqiredParameters;
            Sets.SetView missingParameters;
            ValidationErrorCode error;
            ValidationErrorCode error2;
            RangerService otherService;
            ValidationErrorCode error3;
            Long id = service.getId();
            if (action == RangerValidator.Action.UPDATE) {
                ValidationErrorCode error4;
                if (id == null) {
                    error4 = ValidationErrorCode.SERVICE_VALIDATION_ERR_EMPTY_SERVICE_ID;
                    failures.add(new ValidationFailureDetailsBuilder().field("id").isMissing().errorCode(error4.getErrorCode()).becauseOf(error4.getMessage(new Object[0])).build());
                    valid = false;
                } else if (this.getService(id) == null) {
                    error4 = ValidationErrorCode.SERVICE_VALIDATION_ERR_INVALID_SERVICE_ID;
                    failures.add(new ValidationFailureDetailsBuilder().field("id").isSemanticallyIncorrect().errorCode(error4.getErrorCode()).becauseOf(error4.getMessage(id)).build());
                    valid = false;
                }
            }
            String name = service.getName();
            boolean nameSpecified = StringUtils.isNotBlank((CharSequence)name);
            RangerServiceDef serviceDef = null;
            if (!nameSpecified) {
                ValidationErrorCode error5 = ValidationErrorCode.SERVICE_VALIDATION_ERR_INVALID_SERVICE_NAME;
                failures.add(new ValidationFailureDetailsBuilder().field("name").isMissing().errorCode(error5.getErrorCode()).becauseOf(error5.getMessage(name)).build());
                valid = false;
            } else {
                RangerService rangerService;
                Pattern serviceNameRegex = SERVICE_NAME_VALIDATION_REGEX;
                if (action == RangerValidator.Action.UPDATE && (rangerService = this.getService(service.getId())) != null && StringUtils.isNotBlank((CharSequence)rangerService.getName()) && rangerService.getName().contains(" ")) {
                    serviceNameRegex = LEGACY_SERVICE_NAME_VALIDATION_REGEX;
                }
                if (!this.isValidString(serviceNameRegex, name)) {
                    error3 = ValidationErrorCode.SERVICE_VALIDATION_ERR_SPECIAL_CHARACTERS_SERVICE_NAME;
                    failures.add(new ValidationFailureDetailsBuilder().field("name").isSemanticallyIncorrect().errorCode(error3.getErrorCode()).becauseOf(error3.getMessage(name)).build());
                    valid = false;
                } else {
                    otherService = this.getService(name);
                    if (otherService != null && action == RangerValidator.Action.CREATE) {
                        error2 = ValidationErrorCode.SERVICE_VALIDATION_ERR_SERVICE_NAME_CONFICT;
                        failures.add(new ValidationFailureDetailsBuilder().field("name").isSemanticallyIncorrect().errorCode(error2.getErrorCode()).becauseOf(error2.getMessage(name)).build());
                        valid = false;
                    } else if (otherService != null && otherService.getId() != null && !otherService.getId().equals(id)) {
                        error2 = ValidationErrorCode.SERVICE_VALIDATION_ERR_ID_NAME_CONFLICT;
                        failures.add(new ValidationFailureDetailsBuilder().field("id/name").isSemanticallyIncorrect().errorCode(error2.getErrorCode()).becauseOf(error2.getMessage(name, otherService.getId())).build());
                        valid = false;
                    }
                }
            }
            String displayName = service.getDisplayName();
            if (!this.isValidString(SERVICE_DISPLAY_NAME_VALIDATION_REGEX, displayName)) {
                error3 = ValidationErrorCode.SERVICE_VALIDATION_ERR_SPECIAL_CHARACTERS_SERVICE_DISPLAY_NAME;
                failures.add(new ValidationFailureDetailsBuilder().field("displayName").isSemanticallyIncorrect().errorCode(error3.getErrorCode()).becauseOf(error3.getMessage(displayName)).build());
                valid = false;
            } else {
                otherService = this.getServiceByDisplayName(displayName);
                if (otherService != null && action == RangerValidator.Action.CREATE) {
                    error2 = ValidationErrorCode.SERVICE_VALIDATION_ERR_SERVICE_DISPLAY_NAME_CONFICT;
                    failures.add(new ValidationFailureDetailsBuilder().field("displayName").isSemanticallyIncorrect().errorCode(error2.getErrorCode()).becauseOf(error2.getMessage(displayName, otherService.getName())).build());
                    valid = false;
                } else if (otherService != null && otherService.getId() != null && !otherService.getId().equals(id)) {
                    error2 = ValidationErrorCode.SERVICE_VALIDATION_ERR_SERVICE_DISPLAY_NAME_CONFICT;
                    failures.add(new ValidationFailureDetailsBuilder().field("id/displayName").isSemanticallyIncorrect().errorCode(error2.getErrorCode()).becauseOf(error2.getMessage(displayName, otherService.getName())).build());
                    valid = false;
                }
            }
            String type = service.getType();
            boolean typeSpecified = StringUtils.isNotBlank((CharSequence)type);
            if (!typeSpecified) {
                error = ValidationErrorCode.SERVICE_VALIDATION_ERR_MISSING_SERVICE_DEF;
                failures.add(new ValidationFailureDetailsBuilder().field("type").isMissing().errorCode(error.getErrorCode()).becauseOf(error.getMessage(type)).build());
                valid = false;
            } else {
                serviceDef = this.getServiceDef(type);
                if (serviceDef == null) {
                    error = ValidationErrorCode.SERVICE_VALIDATION_ERR_INVALID_SERVICE_DEF;
                    failures.add(new ValidationFailureDetailsBuilder().field("type").isSemanticallyIncorrect().errorCode(error.getErrorCode()).becauseOf(error.getMessage(type)).build());
                    valid = false;
                }
            }
            if (nameSpecified && serviceDef != null && !(missingParameters = Sets.difference(reqiredParameters = this.getRequiredParameters(serviceDef), inputParameters = this.getServiceConfigParameters(service))).isEmpty()) {
                ValidationErrorCode error6 = ValidationErrorCode.SERVICE_VALIDATION_ERR_REQUIRED_PARM_MISSING;
                failures.add(new ValidationFailureDetailsBuilder().field("configuration").subField((String)missingParameters.iterator().next()).isMissing().errorCode(error6.getErrorCode()).becauseOf(error6.getMessage(missingParameters)).build());
                valid = false;
            }
            if (StringUtils.isNotBlank((CharSequence)(tagServiceName = service.getTagService())) && StringUtils.equals((CharSequence)type, (CharSequence)"tag")) {
                failures.add(new ValidationFailureDetailsBuilder().field("tag_service").isSemanticallyIncorrect().becauseOf("tag service cannot be part of any other service").build());
                valid = false;
            }
            boolean needToEnsureServiceType = false;
            if (action == RangerValidator.Action.UPDATE) {
                String otherTagServiceName;
                RangerService otherService2 = this.getService(name);
                String string = otherTagServiceName = otherService2 == null ? null : otherService2.getTagService();
                if (StringUtils.isNotBlank((CharSequence)tagServiceName) && !StringUtils.equals((CharSequence)tagServiceName, (CharSequence)otherTagServiceName)) {
                    needToEnsureServiceType = true;
                }
            } else if (StringUtils.isNotBlank((CharSequence)tagServiceName)) {
                needToEnsureServiceType = true;
            }
            if (needToEnsureServiceType && ((maybeTagService = this.getService(tagServiceName)) == null || !StringUtils.equals((CharSequence)maybeTagService.getType(), (CharSequence)"tag"))) {
                failures.add(new ValidationFailureDetailsBuilder().field("tag_service").isSemanticallyIncorrect().becauseOf("tag service name does not refer to existing tag service:" + tagServiceName).build());
                valid = false;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerServiceValidator.isValid(" + service + "): " + valid);
        }
        return valid;
    }

    public boolean isValidString(Pattern pattern, String name) {
        return pattern != null && StringUtils.isNotBlank((CharSequence)name) && pattern.matcher(name).matches();
    }
}

