/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.cloud.autoscaling;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.solr.client.solrj.impl.ClusterStateProvider;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.DocCollection;

public class DelegatingClusterStateProvider
implements ClusterStateProvider {
    protected ClusterStateProvider delegate;

    public DelegatingClusterStateProvider(ClusterStateProvider delegate) {
        this.delegate = delegate;
    }

    @Override
    public ClusterState.CollectionRef getState(String collection) {
        if (this.delegate != null) {
            return this.delegate.getState(collection);
        }
        return null;
    }

    @Override
    public Set<String> getLiveNodes() {
        if (this.delegate != null) {
            return this.delegate.getLiveNodes();
        }
        return Collections.emptySet();
    }

    @Override
    public List<String> resolveAlias(String alias) {
        if (this.delegate != null) {
            return this.delegate.resolveAlias(alias);
        }
        return Collections.singletonList(alias);
    }

    @Override
    public Map<String, String> getAliasProperties(String alias) {
        if (this.delegate != null) {
            return this.delegate.getAliasProperties(alias);
        }
        return Collections.emptyMap();
    }

    @Override
    public String resolveSimpleAlias(String alias) throws IllegalArgumentException {
        if (this.delegate != null) {
            return this.delegate.resolveSimpleAlias(alias);
        }
        return alias;
    }

    @Override
    public ClusterState getClusterState() throws IOException {
        if (this.delegate != null) {
            return this.delegate.getClusterState();
        }
        return null;
    }

    @Override
    public Map<String, Object> getClusterProperties() {
        if (this.delegate != null) {
            return this.delegate.getClusterProperties();
        }
        return Collections.emptyMap();
    }

    @Override
    public String getPolicyNameByCollection(String coll) {
        if (this.delegate != null) {
            return this.delegate.getPolicyNameByCollection(coll);
        }
        return null;
    }

    @Override
    public DocCollection getCollection(String name) throws IOException {
        ClusterState cs = this.getClusterState();
        return cs == null ? null : cs.getCollectionOrNull(name);
    }

    @Override
    public void connect() {
        if (this.delegate != null) {
            this.delegate.connect();
        }
    }

    @Override
    public void close() throws IOException {
        if (this.delegate != null) {
            this.delegate.close();
        }
    }
}

