/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.policyengine;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.ranger.plugin.model.RangerInlinePolicy;
import org.apache.ranger.plugin.policyengine.RangerAccessRequest;
import org.apache.ranger.plugin.policyengine.RangerAccessRequestReadOnly;
import org.apache.ranger.plugin.policyengine.RangerAccessResource;
import org.apache.ranger.plugin.util.RangerAccessRequestUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerAccessRequestImpl
implements RangerAccessRequest {
    private static final Logger LOG = LoggerFactory.getLogger(RangerAccessRequestImpl.class);
    private RangerAccessResource resource;
    private String accessType;
    private String user;
    private Set<String> userGroups;
    private Set<String> userRoles;
    private Date accessTime;
    private String clientIPAddress;
    private List<String> forwardedAddresses;
    private String remoteIPAddress;
    private String clientType;
    private String action;
    private String requestData;
    private String sessionId;
    private Map<String, Object> context;
    private String clusterName;
    private String clusterType;
    private Boolean isDescendantDenyIgnored = true;
    private boolean isAccessTypeAny;
    private boolean isAccessTypeDelegatedAdmin;
    private RangerAccessRequest.ResourceMatchingScope resourceMatchingScope = RangerAccessRequest.ResourceMatchingScope.SELF;
    private Map<String, RangerAccessRequest.ResourceElementMatchingScope> resourceElementMatchingScopes = Collections.emptyMap();
    private RangerInlinePolicy inlinePolicy;

    public RangerAccessRequestImpl() {
        this(null, null, null, null, null);
    }

    public RangerAccessRequestImpl(RangerAccessResource resource, String accessType, String user, Set<String> userGroups, Set<String> userRoles) {
        this.setResource(resource);
        this.setAccessType(accessType);
        this.setUser(user);
        this.setUserGroups(userGroups);
        this.setUserRoles(userRoles);
        this.setForwardedAddresses(null);
        this.setAccessTime(null);
        this.setRemoteIPAddress(null);
        this.setClientType(null);
        this.setAction(null);
        this.setRequestData(null);
        this.setSessionId(null);
        this.setContext(null);
        this.setClusterName(null);
        this.setIgnoreDescendantDeny(null);
    }

    public RangerAccessRequestImpl(RangerAccessRequest request) {
        this.setResource(request.getResource());
        this.setAccessType(request.getAccessType());
        this.setUser(request.getUser());
        this.setUserGroups(request.getUserGroups());
        this.setUserRoles(request.getUserRoles());
        this.setForwardedAddresses(request.getForwardedAddresses());
        this.setAccessTime(request.getAccessTime());
        this.setRemoteIPAddress(request.getRemoteIPAddress());
        this.setClientType(request.getClientType());
        this.setAction(request.getAction());
        this.setRequestData(request.getRequestData());
        this.setSessionId(request.getSessionId());
        this.setContext(request.getContext());
        this.setClusterName(request.getClusterName());
        this.setResourceMatchingScope(request.getResourceMatchingScope());
        this.setResourceElementMatchingScopes(request.getResourceElementMatchingScopes());
        this.setClientIPAddress(request.getClientIPAddress());
        this.setClusterType(request.getClusterType());
        this.setIgnoreDescendantDeny(request.ignoreDescendantDeny());
    }

    @Override
    public RangerAccessResource getResource() {
        return this.resource;
    }

    @Override
    public String getAccessType() {
        return this.accessType;
    }

    @Override
    public boolean ignoreDescendantDeny() {
        return this.isDescendantDenyIgnored == null || this.isDescendantDenyIgnored != false;
    }

    @Override
    public String getUser() {
        return this.user;
    }

    @Override
    public Set<String> getUserGroups() {
        return this.userGroups;
    }

    @Override
    public Set<String> getUserRoles() {
        return this.userRoles;
    }

    @Override
    public Date getAccessTime() {
        return this.accessTime;
    }

    @Override
    public String getClientIPAddress() {
        return this.clientIPAddress;
    }

    @Override
    public String getRemoteIPAddress() {
        return this.remoteIPAddress;
    }

    @Override
    public List<String> getForwardedAddresses() {
        return this.forwardedAddresses;
    }

    @Override
    public String getClientType() {
        return this.clientType;
    }

    @Override
    public String getAction() {
        return this.action;
    }

    @Override
    public String getRequestData() {
        return this.requestData;
    }

    @Override
    public String getSessionId() {
        return this.sessionId;
    }

    @Override
    public Map<String, Object> getContext() {
        return this.context;
    }

    @Override
    public RangerAccessRequest.ResourceMatchingScope getResourceMatchingScope() {
        return this.resourceMatchingScope;
    }

    @Override
    public Map<String, RangerAccessRequest.ResourceElementMatchingScope> getResourceElementMatchingScopes() {
        return this.resourceElementMatchingScopes;
    }

    @Override
    public boolean isAccessTypeAny() {
        return this.isAccessTypeAny;
    }

    @Override
    public boolean isAccessTypeDelegatedAdmin() {
        return this.isAccessTypeDelegatedAdmin;
    }

    @Override
    public RangerInlinePolicy getInlinePolicy() {
        return this.inlinePolicy;
    }

    public void setResource(RangerAccessResource resource) {
        this.resource = resource;
        if (this.context != null) {
            RangerAccessRequestUtil.setIsRequestPreprocessed(this.context, Boolean.FALSE);
        }
    }

    public void setAccessType(String accessType) {
        if (StringUtils.isEmpty((CharSequence)accessType)) {
            accessType = "_any";
        }
        this.accessType = accessType;
        this.isAccessTypeAny = StringUtils.equals((CharSequence)accessType, (CharSequence)"_any");
        this.isAccessTypeDelegatedAdmin = StringUtils.equals((CharSequence)accessType, (CharSequence)"_admin");
    }

    public void setIgnoreDescendantDeny(Boolean isDescendantDenyIgnored) {
        this.isDescendantDenyIgnored = isDescendantDenyIgnored == null || isDescendantDenyIgnored != false;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public void setUserGroups(Set<String> userGroups) {
        this.userGroups = userGroups == null ? new HashSet() : userGroups;
    }

    public void setUserRoles(Set<String> userRoles) {
        this.userRoles = userRoles == null ? new HashSet() : userRoles;
    }

    public void setAccessTime(Date accessTime) {
        this.accessTime = accessTime;
    }

    public void setClientIPAddress(String ipAddress) {
        this.clientIPAddress = ipAddress;
    }

    public void setForwardedAddresses(List<String> forwardedAddresses) {
        this.forwardedAddresses = forwardedAddresses == null ? new ArrayList() : forwardedAddresses;
    }

    public void setRemoteIPAddress(String remoteIPAddress) {
        this.remoteIPAddress = remoteIPAddress;
    }

    public void setClientType(String clientType) {
        this.clientType = clientType;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public void setRequestData(String requestData) {
        this.requestData = requestData;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    @Override
    public String getClusterName() {
        return this.clusterName;
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    @Override
    public String getClusterType() {
        return this.clusterType;
    }

    public void setClusterType(String clusterType) {
        this.clusterType = clusterType;
    }

    public void setResourceMatchingScope(RangerAccessRequest.ResourceMatchingScope scope) {
        this.resourceMatchingScope = scope;
        if (this.context != null) {
            RangerAccessRequestUtil.setIsRequestPreprocessed(this.context, Boolean.FALSE);
        }
    }

    public void setResourceElementMatchingScopes(Map<String, RangerAccessRequest.ResourceElementMatchingScope> resourceElementMatchingScopes) {
        this.resourceElementMatchingScopes = resourceElementMatchingScopes == null ? Collections.emptyMap() : resourceElementMatchingScopes;
    }

    public void setContext(Map<String, Object> context) {
        this.context = context == null ? new HashMap<String, Object>() : context;
        RangerAccessRequest current = RangerAccessRequestUtil.getRequestFromContext(this.context);
        if (current == null) {
            RangerAccessRequestUtil.setRequestInContext(this);
        }
    }

    public void setInlinePolicy(RangerInlinePolicy inlinePolicy) {
        this.inlinePolicy = inlinePolicy;
    }

    public void extractAndSetClientIPAddress(boolean useForwardedIPAddress, String[] trustedProxyAddresses) {
        String ip = this.getRemoteIPAddress();
        if (ip == null) {
            ip = this.getClientIPAddress();
        }
        String newIp = ip;
        if (useForwardedIPAddress) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Using X-Forward-For...");
            }
            if (CollectionUtils.isNotEmpty(this.getForwardedAddresses())) {
                if (trustedProxyAddresses != null && trustedProxyAddresses.length > 0) {
                    if (StringUtils.isNotEmpty((CharSequence)ip)) {
                        for (String trustedProxyAddress : trustedProxyAddresses) {
                            if (!StringUtils.equals((CharSequence)ip, (CharSequence)trustedProxyAddress)) continue;
                            newIp = this.getForwardedAddresses().get(0);
                            break;
                        }
                    }
                } else {
                    newIp = this.getForwardedAddresses().get(0);
                }
            } else if (LOG.isDebugEnabled()) {
                LOG.debug("No X-Forwarded-For addresses in the access-request");
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Old Remote/Client IP Address=" + ip + ", new IP Address=" + newIp);
        }
        this.setClientIPAddress(newIp);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.toString(sb);
        return sb.toString();
    }

    public StringBuilder toString(StringBuilder sb) {
        sb.append("RangerAccessRequestImpl={");
        sb.append("resource={").append(this.resource).append("} ");
        sb.append("accessType={").append(this.accessType).append("} ");
        sb.append("user={").append(this.user).append("} ");
        sb.append("userGroups={");
        if (this.userGroups != null) {
            for (String string : this.userGroups) {
                sb.append(string).append(" ");
            }
        }
        sb.append("} ");
        sb.append("userRoles={");
        if (this.userRoles != null) {
            for (String string : this.userRoles) {
                sb.append(string).append(" ");
            }
        }
        sb.append("} ");
        sb.append("accessTime={").append(this.accessTime).append("} ");
        sb.append("clientIPAddress={").append(this.getClientIPAddress()).append("} ");
        sb.append("forwardedAddresses={").append(StringUtils.join(this.forwardedAddresses, (String)" ")).append("} ");
        sb.append("remoteIPAddress={").append(this.remoteIPAddress).append("} ");
        sb.append("clientType={").append(this.clientType).append("} ");
        sb.append("action={").append(this.action).append("} ");
        sb.append("requestData={").append(this.requestData).append("} ");
        sb.append("sessionId={").append(this.sessionId).append("} ");
        sb.append("resourceMatchingScope={").append((Object)this.resourceMatchingScope).append("} ");
        sb.append("resourceElementMatchingScopes={").append(this.resourceElementMatchingScopes).append("} ");
        sb.append("clusterName={").append(this.clusterName).append("} ");
        sb.append("clusterType={").append(this.clusterType).append("} ");
        sb.append("inlinePolicy={").append(this.inlinePolicy).append("} ");
        sb.append("context={");
        if (this.context != null) {
            for (Map.Entry entry : this.context.entrySet()) {
                Object val = entry.getValue();
                if (val instanceof RangerAccessRequest) continue;
                sb.append((String)entry.getKey()).append("={").append(val).append("} ");
            }
        }
        sb.append("} ");
        sb.append("}");
        return sb;
    }

    @Override
    public RangerAccessRequest getReadOnlyCopy() {
        return new RangerAccessRequestReadOnly(this);
    }
}

