/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.pc;

import java.util.Queue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class WorkItemConsumer<T>
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(WorkItemConsumer.class);
    private static final int POLLING_DURATION_SECONDS = 5;
    private static final int DEFAULT_COMMIT_TIME_IN_MS = 15000;
    private final BlockingQueue<T> queue;
    private final AtomicBoolean isDirty = new AtomicBoolean(false);
    private final AtomicLong maxCommitTimeInMs = new AtomicLong(15000L);
    private CountDownLatch countdownLatch;
    private Queue<Object> results;

    public WorkItemConsumer(BlockingQueue<T> queue) {
        this.queue = queue;
        this.countdownLatch = null;
    }

    @Override
    public void run() {
        try {
            while (!Thread.currentThread().isInterrupted()) {
                T item = this.queue.poll(5L, TimeUnit.SECONDS);
                if (item == null) {
                    LOG.debug("WorkItemConsumer.run(): no more items found in the queue. Will exit after committing");
                    this.commitDirty();
                    return;
                }
                this.isDirty.set(true);
                this.processItem(item);
            }
        }
        catch (InterruptedException e) {
            LOG.error("WorkItemConsumer: Interrupted: ", (Throwable)e);
        }
        finally {
            this.maxCommitTimeInMs.set(0L);
            this.countdownLatch.countDown();
        }
    }

    public long getMaxCommitTimeInMs() {
        long commitTime = this.maxCommitTimeInMs.get();
        return commitTime > 15000L ? commitTime : 15000L;
    }

    protected void commitDirty() {
        if (!this.isDirty.get()) {
            return;
        }
        LOG.info("isDirty");
        this.commit();
    }

    protected void commit() {
        long start = System.currentTimeMillis();
        this.doCommit();
        long end = System.currentTimeMillis();
        this.updateCommitTime(end - start);
        this.isDirty.set(false);
    }

    protected abstract void doCommit();

    protected abstract void processItem(T var1);

    protected void addResult(Object value) {
        this.results.add(value);
    }

    protected void updateCommitTime(long commitTime) {
        if (this.maxCommitTimeInMs.get() < commitTime) {
            this.maxCommitTimeInMs.set(commitTime);
        }
    }

    public void setCountDownLatch(CountDownLatch countdownLatch) {
        this.countdownLatch = countdownLatch;
    }

    public <V> void setResults(Queue<Object> queue) {
        this.results = queue;
    }
}

