/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.sql.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.sql.implementation.JobStepInner;
import com.microsoft.azure.management.sql.implementation.PageImpl1;
import com.microsoft.azure.management.sql.implementation.SqlManagementClientImpl;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class JobStepsInner {
    private JobStepsService service;
    private SqlManagementClientImpl client;

    public JobStepsInner(Retrofit retrofit, SqlManagementClientImpl client) {
        this.service = (JobStepsService)retrofit.create(JobStepsService.class);
        this.client = client;
    }

    public PagedList<JobStepInner> listByVersion(String resourceGroupName, String serverName, String jobAgentName, String jobName, int jobVersion) {
        ServiceResponse response = (ServiceResponse)this.listByVersionSinglePageAsync(resourceGroupName, serverName, jobAgentName, jobName, jobVersion).toBlocking().single();
        return new PagedList<JobStepInner>((Page)response.body()){

            public Page<JobStepInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)JobStepsInner.this.listByVersionNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<JobStepInner>> listByVersionAsync(String resourceGroupName, String serverName, String jobAgentName, String jobName, int jobVersion, ListOperationCallback<JobStepInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByVersionSinglePageAsync(resourceGroupName, serverName, jobAgentName, jobName, jobVersion), (Func1)new Func1<String, Observable<ServiceResponse<Page<JobStepInner>>>>(){

            public Observable<ServiceResponse<Page<JobStepInner>>> call(String nextPageLink) {
                return JobStepsInner.this.listByVersionNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<JobStepInner>> listByVersionAsync(String resourceGroupName, String serverName, String jobAgentName, String jobName, int jobVersion) {
        return this.listByVersionWithServiceResponseAsync(resourceGroupName, serverName, jobAgentName, jobName, jobVersion).map((Func1)new Func1<ServiceResponse<Page<JobStepInner>>, Page<JobStepInner>>(){

            public Page<JobStepInner> call(ServiceResponse<Page<JobStepInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<JobStepInner>>> listByVersionWithServiceResponseAsync(String resourceGroupName, String serverName, String jobAgentName, String jobName, int jobVersion) {
        return this.listByVersionSinglePageAsync(resourceGroupName, serverName, jobAgentName, jobName, jobVersion).concatMap((Func1)new Func1<ServiceResponse<Page<JobStepInner>>, Observable<ServiceResponse<Page<JobStepInner>>>>(){

            public Observable<ServiceResponse<Page<JobStepInner>>> call(ServiceResponse<Page<JobStepInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(JobStepsInner.this.listByVersionNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<JobStepInner>>> listByVersionSinglePageAsync(String resourceGroupName, String serverName, String jobAgentName, String jobName, int jobVersion) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (jobAgentName == null) {
            throw new IllegalArgumentException("Parameter jobAgentName is required and cannot be null.");
        }
        if (jobName == null) {
            throw new IllegalArgumentException("Parameter jobName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2017-03-01-preview";
        return this.service.listByVersion(resourceGroupName, serverName, jobAgentName, jobName, jobVersion, this.client.subscriptionId(), "2017-03-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<JobStepInner>>>>(){

            public Observable<ServiceResponse<Page<JobStepInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = JobStepsInner.this.listByVersionDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<JobStepInner>> listByVersionDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl1<JobStepInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public JobStepInner getByVersion(String resourceGroupName, String serverName, String jobAgentName, String jobName, int jobVersion, String stepName) {
        return (JobStepInner)((ServiceResponse)this.getByVersionWithServiceResponseAsync(resourceGroupName, serverName, jobAgentName, jobName, jobVersion, stepName).toBlocking().single()).body();
    }

    public ServiceFuture<JobStepInner> getByVersionAsync(String resourceGroupName, String serverName, String jobAgentName, String jobName, int jobVersion, String stepName, ServiceCallback<JobStepInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getByVersionWithServiceResponseAsync(resourceGroupName, serverName, jobAgentName, jobName, jobVersion, stepName), serviceCallback);
    }

    public Observable<JobStepInner> getByVersionAsync(String resourceGroupName, String serverName, String jobAgentName, String jobName, int jobVersion, String stepName) {
        return this.getByVersionWithServiceResponseAsync(resourceGroupName, serverName, jobAgentName, jobName, jobVersion, stepName).map((Func1)new Func1<ServiceResponse<JobStepInner>, JobStepInner>(){

            public JobStepInner call(ServiceResponse<JobStepInner> response) {
                return (JobStepInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<JobStepInner>> getByVersionWithServiceResponseAsync(String resourceGroupName, String serverName, String jobAgentName, String jobName, int jobVersion, String stepName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (jobAgentName == null) {
            throw new IllegalArgumentException("Parameter jobAgentName is required and cannot be null.");
        }
        if (jobName == null) {
            throw new IllegalArgumentException("Parameter jobName is required and cannot be null.");
        }
        if (stepName == null) {
            throw new IllegalArgumentException("Parameter stepName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2017-03-01-preview";
        return this.service.getByVersion(resourceGroupName, serverName, jobAgentName, jobName, jobVersion, stepName, this.client.subscriptionId(), "2017-03-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<JobStepInner>>>(){

            public Observable<ServiceResponse<JobStepInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = JobStepsInner.this.getByVersionDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<JobStepInner> getByVersionDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<JobStepInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<JobStepInner> listByJob(String resourceGroupName, String serverName, String jobAgentName, String jobName) {
        ServiceResponse response = (ServiceResponse)this.listByJobSinglePageAsync(resourceGroupName, serverName, jobAgentName, jobName).toBlocking().single();
        return new PagedList<JobStepInner>((Page)response.body()){

            public Page<JobStepInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)JobStepsInner.this.listByJobNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<JobStepInner>> listByJobAsync(String resourceGroupName, String serverName, String jobAgentName, String jobName, ListOperationCallback<JobStepInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByJobSinglePageAsync(resourceGroupName, serverName, jobAgentName, jobName), (Func1)new Func1<String, Observable<ServiceResponse<Page<JobStepInner>>>>(){

            public Observable<ServiceResponse<Page<JobStepInner>>> call(String nextPageLink) {
                return JobStepsInner.this.listByJobNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<JobStepInner>> listByJobAsync(String resourceGroupName, String serverName, String jobAgentName, String jobName) {
        return this.listByJobWithServiceResponseAsync(resourceGroupName, serverName, jobAgentName, jobName).map((Func1)new Func1<ServiceResponse<Page<JobStepInner>>, Page<JobStepInner>>(){

            public Page<JobStepInner> call(ServiceResponse<Page<JobStepInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<JobStepInner>>> listByJobWithServiceResponseAsync(String resourceGroupName, String serverName, String jobAgentName, String jobName) {
        return this.listByJobSinglePageAsync(resourceGroupName, serverName, jobAgentName, jobName).concatMap((Func1)new Func1<ServiceResponse<Page<JobStepInner>>, Observable<ServiceResponse<Page<JobStepInner>>>>(){

            public Observable<ServiceResponse<Page<JobStepInner>>> call(ServiceResponse<Page<JobStepInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(JobStepsInner.this.listByJobNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<JobStepInner>>> listByJobSinglePageAsync(String resourceGroupName, String serverName, String jobAgentName, String jobName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (jobAgentName == null) {
            throw new IllegalArgumentException("Parameter jobAgentName is required and cannot be null.");
        }
        if (jobName == null) {
            throw new IllegalArgumentException("Parameter jobName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2017-03-01-preview";
        return this.service.listByJob(resourceGroupName, serverName, jobAgentName, jobName, this.client.subscriptionId(), "2017-03-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<JobStepInner>>>>(){

            public Observable<ServiceResponse<Page<JobStepInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = JobStepsInner.this.listByJobDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<JobStepInner>> listByJobDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl1<JobStepInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public JobStepInner get(String resourceGroupName, String serverName, String jobAgentName, String jobName, String stepName) {
        return (JobStepInner)((ServiceResponse)this.getWithServiceResponseAsync(resourceGroupName, serverName, jobAgentName, jobName, stepName).toBlocking().single()).body();
    }

    public ServiceFuture<JobStepInner> getAsync(String resourceGroupName, String serverName, String jobAgentName, String jobName, String stepName, ServiceCallback<JobStepInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getWithServiceResponseAsync(resourceGroupName, serverName, jobAgentName, jobName, stepName), serviceCallback);
    }

    public Observable<JobStepInner> getAsync(String resourceGroupName, String serverName, String jobAgentName, String jobName, String stepName) {
        return this.getWithServiceResponseAsync(resourceGroupName, serverName, jobAgentName, jobName, stepName).map((Func1)new Func1<ServiceResponse<JobStepInner>, JobStepInner>(){

            public JobStepInner call(ServiceResponse<JobStepInner> response) {
                return (JobStepInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<JobStepInner>> getWithServiceResponseAsync(String resourceGroupName, String serverName, String jobAgentName, String jobName, String stepName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (jobAgentName == null) {
            throw new IllegalArgumentException("Parameter jobAgentName is required and cannot be null.");
        }
        if (jobName == null) {
            throw new IllegalArgumentException("Parameter jobName is required and cannot be null.");
        }
        if (stepName == null) {
            throw new IllegalArgumentException("Parameter stepName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2017-03-01-preview";
        return this.service.get(resourceGroupName, serverName, jobAgentName, jobName, stepName, this.client.subscriptionId(), "2017-03-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<JobStepInner>>>(){

            public Observable<ServiceResponse<JobStepInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = JobStepsInner.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<JobStepInner> getDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<JobStepInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public JobStepInner createOrUpdate(String resourceGroupName, String serverName, String jobAgentName, String jobName, String stepName, JobStepInner parameters) {
        return (JobStepInner)((ServiceResponse)this.createOrUpdateWithServiceResponseAsync(resourceGroupName, serverName, jobAgentName, jobName, stepName, parameters).toBlocking().single()).body();
    }

    public ServiceFuture<JobStepInner> createOrUpdateAsync(String resourceGroupName, String serverName, String jobAgentName, String jobName, String stepName, JobStepInner parameters, ServiceCallback<JobStepInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createOrUpdateWithServiceResponseAsync(resourceGroupName, serverName, jobAgentName, jobName, stepName, parameters), serviceCallback);
    }

    public Observable<JobStepInner> createOrUpdateAsync(String resourceGroupName, String serverName, String jobAgentName, String jobName, String stepName, JobStepInner parameters) {
        return this.createOrUpdateWithServiceResponseAsync(resourceGroupName, serverName, jobAgentName, jobName, stepName, parameters).map((Func1)new Func1<ServiceResponse<JobStepInner>, JobStepInner>(){

            public JobStepInner call(ServiceResponse<JobStepInner> response) {
                return (JobStepInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<JobStepInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, String serverName, String jobAgentName, String jobName, String stepName, JobStepInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (jobAgentName == null) {
            throw new IllegalArgumentException("Parameter jobAgentName is required and cannot be null.");
        }
        if (jobName == null) {
            throw new IllegalArgumentException("Parameter jobName is required and cannot be null.");
        }
        if (stepName == null) {
            throw new IllegalArgumentException("Parameter stepName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        String apiVersion = "2017-03-01-preview";
        return this.service.createOrUpdate(resourceGroupName, serverName, jobAgentName, jobName, stepName, this.client.subscriptionId(), parameters, "2017-03-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<JobStepInner>>>(){

            public Observable<ServiceResponse<JobStepInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = JobStepsInner.this.createOrUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<JobStepInner> createOrUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<JobStepInner>(){}.getType()).register(201, new TypeToken<JobStepInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void delete(String resourceGroupName, String serverName, String jobAgentName, String jobName, String stepName) {
        ((ServiceResponse)this.deleteWithServiceResponseAsync(resourceGroupName, serverName, jobAgentName, jobName, stepName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String serverName, String jobAgentName, String jobName, String stepName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteWithServiceResponseAsync(resourceGroupName, serverName, jobAgentName, jobName, stepName), serviceCallback);
    }

    public Observable<Void> deleteAsync(String resourceGroupName, String serverName, String jobAgentName, String jobName, String stepName) {
        return this.deleteWithServiceResponseAsync(resourceGroupName, serverName, jobAgentName, jobName, stepName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String serverName, String jobAgentName, String jobName, String stepName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (serverName == null) {
            throw new IllegalArgumentException("Parameter serverName is required and cannot be null.");
        }
        if (jobAgentName == null) {
            throw new IllegalArgumentException("Parameter jobAgentName is required and cannot be null.");
        }
        if (jobName == null) {
            throw new IllegalArgumentException("Parameter jobName is required and cannot be null.");
        }
        if (stepName == null) {
            throw new IllegalArgumentException("Parameter stepName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        String apiVersion = "2017-03-01-preview";
        return this.service.delete(resourceGroupName, serverName, jobAgentName, jobName, stepName, this.client.subscriptionId(), "2017-03-01-preview", this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = JobStepsInner.this.deleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> deleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).register(204, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<JobStepInner> listByVersionNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listByVersionNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<JobStepInner>((Page)response.body()){

            public Page<JobStepInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)JobStepsInner.this.listByVersionNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<JobStepInner>> listByVersionNextAsync(String nextPageLink, ServiceFuture<List<JobStepInner>> serviceFuture, ListOperationCallback<JobStepInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByVersionNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<JobStepInner>>>>(){

            public Observable<ServiceResponse<Page<JobStepInner>>> call(String nextPageLink) {
                return JobStepsInner.this.listByVersionNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<JobStepInner>> listByVersionNextAsync(String nextPageLink) {
        return this.listByVersionNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<JobStepInner>>, Page<JobStepInner>>(){

            public Page<JobStepInner> call(ServiceResponse<Page<JobStepInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<JobStepInner>>> listByVersionNextWithServiceResponseAsync(String nextPageLink) {
        return this.listByVersionNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<JobStepInner>>, Observable<ServiceResponse<Page<JobStepInner>>>>(){

            public Observable<ServiceResponse<Page<JobStepInner>>> call(ServiceResponse<Page<JobStepInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(JobStepsInner.this.listByVersionNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<JobStepInner>>> listByVersionNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listByVersionNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<JobStepInner>>>>(){

            public Observable<ServiceResponse<Page<JobStepInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = JobStepsInner.this.listByVersionNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<JobStepInner>> listByVersionNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl1<JobStepInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<JobStepInner> listByJobNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listByJobNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<JobStepInner>((Page)response.body()){

            public Page<JobStepInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)JobStepsInner.this.listByJobNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<JobStepInner>> listByJobNextAsync(String nextPageLink, ServiceFuture<List<JobStepInner>> serviceFuture, ListOperationCallback<JobStepInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listByJobNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<JobStepInner>>>>(){

            public Observable<ServiceResponse<Page<JobStepInner>>> call(String nextPageLink) {
                return JobStepsInner.this.listByJobNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<JobStepInner>> listByJobNextAsync(String nextPageLink) {
        return this.listByJobNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<JobStepInner>>, Page<JobStepInner>>(){

            public Page<JobStepInner> call(ServiceResponse<Page<JobStepInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<JobStepInner>>> listByJobNextWithServiceResponseAsync(String nextPageLink) {
        return this.listByJobNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<JobStepInner>>, Observable<ServiceResponse<Page<JobStepInner>>>>(){

            public Observable<ServiceResponse<Page<JobStepInner>>> call(ServiceResponse<Page<JobStepInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(JobStepsInner.this.listByJobNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<JobStepInner>>> listByJobNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listByJobNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<JobStepInner>>>>(){

            public Observable<ServiceResponse<Page<JobStepInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = JobStepsInner.this.listByJobNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl1<JobStepInner>> listByJobNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl1<JobStepInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface JobStepsService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.JobSteps listByVersion"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/jobAgents/{jobAgentName}/jobs/{jobName}/versions/{jobVersion}/steps")
        public Observable<Response<ResponseBody>> listByVersion(@Path(value="resourceGroupName") String var1, @Path(value="serverName") String var2, @Path(value="jobAgentName") String var3, @Path(value="jobName") String var4, @Path(value="jobVersion") int var5, @Path(value="subscriptionId") String var6, @Query(value="api-version") String var7, @Header(value="accept-language") String var8, @Header(value="User-Agent") String var9);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.JobSteps getByVersion"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/jobAgents/{jobAgentName}/jobs/{jobName}/versions/{jobVersion}/steps/{stepName}")
        public Observable<Response<ResponseBody>> getByVersion(@Path(value="resourceGroupName") String var1, @Path(value="serverName") String var2, @Path(value="jobAgentName") String var3, @Path(value="jobName") String var4, @Path(value="jobVersion") int var5, @Path(value="stepName") String var6, @Path(value="subscriptionId") String var7, @Query(value="api-version") String var8, @Header(value="accept-language") String var9, @Header(value="User-Agent") String var10);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.JobSteps listByJob"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/jobAgents/{jobAgentName}/jobs/{jobName}/steps")
        public Observable<Response<ResponseBody>> listByJob(@Path(value="resourceGroupName") String var1, @Path(value="serverName") String var2, @Path(value="jobAgentName") String var3, @Path(value="jobName") String var4, @Path(value="subscriptionId") String var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.JobSteps get"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/jobAgents/{jobAgentName}/jobs/{jobName}/steps/{stepName}")
        public Observable<Response<ResponseBody>> get(@Path(value="resourceGroupName") String var1, @Path(value="serverName") String var2, @Path(value="jobAgentName") String var3, @Path(value="jobName") String var4, @Path(value="stepName") String var5, @Path(value="subscriptionId") String var6, @Query(value="api-version") String var7, @Header(value="accept-language") String var8, @Header(value="User-Agent") String var9);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.JobSteps createOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/jobAgents/{jobAgentName}/jobs/{jobName}/steps/{stepName}")
        public Observable<Response<ResponseBody>> createOrUpdate(@Path(value="resourceGroupName") String var1, @Path(value="serverName") String var2, @Path(value="jobAgentName") String var3, @Path(value="jobName") String var4, @Path(value="stepName") String var5, @Path(value="subscriptionId") String var6, @Body JobStepInner var7, @Query(value="api-version") String var8, @Header(value="accept-language") String var9, @Header(value="User-Agent") String var10);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.JobSteps delete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/jobAgents/{jobAgentName}/jobs/{jobName}/steps/{stepName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="resourceGroupName") String var1, @Path(value="serverName") String var2, @Path(value="jobAgentName") String var3, @Path(value="jobName") String var4, @Path(value="stepName") String var5, @Path(value="subscriptionId") String var6, @Query(value="api-version") String var7, @Header(value="accept-language") String var8, @Header(value="User-Agent") String var9);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.JobSteps listByVersionNext"})
        @GET
        public Observable<Response<ResponseBody>> listByVersionNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.sql.JobSteps listByJobNext"})
        @GET
        public Observable<Response<ResponseBody>> listByJobNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

