/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.locks.implementation;

import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.locks.ManagementLock;
import com.microsoft.azure.management.locks.ManagementLocks;
import com.microsoft.azure.management.locks.implementation.AuthorizationManager;
import com.microsoft.azure.management.locks.implementation.ManagementLockClientImpl;
import com.microsoft.azure.management.locks.implementation.ManagementLockImpl;
import com.microsoft.azure.management.locks.implementation.ManagementLockObjectInner;
import com.microsoft.azure.management.locks.implementation.ManagementLocksInner;
import com.microsoft.azure.management.resources.fluentcore.arm.ResourceUtils;
import com.microsoft.azure.management.resources.fluentcore.arm.collection.implementation.CreatableResourcesImpl;
import com.microsoft.azure.management.resources.fluentcore.utils.RXMapper;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import rx.Completable;
import rx.Observable;
import rx.functions.Func1;

@LangDefinition
class ManagementLocksImpl
extends CreatableResourcesImpl<ManagementLock, ManagementLockImpl, ManagementLockObjectInner>
implements ManagementLocks {
    private final AuthorizationManager manager;

    ManagementLocksImpl(AuthorizationManager manager) {
        this.manager = manager;
    }

    public static String resourceIdFromLockId(String lockId) {
        String[] lockIdParts = ManagementLocksImpl.lockIdParts(lockId);
        if (lockIdParts == null) {
            return null;
        }
        StringBuilder resourceId = new StringBuilder();
        for (int i = 0; i < lockIdParts.length - 4; ++i) {
            if (lockIdParts[i].isEmpty()) continue;
            resourceId.append("/").append(lockIdParts[i]);
        }
        return resourceId.toString();
    }

    private static String[] lockIdParts(String lockId) {
        if (lockId == null) {
            return null;
        }
        String[] parts = lockId.split("/");
        if (parts.length < 4) {
            return null;
        }
        if (!(parts[parts.length - 2].equalsIgnoreCase("locks") && parts[parts.length - 3].equalsIgnoreCase("Microsoft.Authorization") && parts[parts.length - 4].equalsIgnoreCase("providers"))) {
            return null;
        }
        return parts;
    }

    public ManagementLockImpl define(String name) {
        return this.wrapModel(name);
    }

    protected ManagementLockImpl wrapModel(String name) {
        ManagementLockObjectInner inner = new ManagementLockObjectInner();
        return new ManagementLockImpl(name, inner, this.manager());
    }

    protected ManagementLockImpl wrapModel(ManagementLockObjectInner inner) {
        if (inner == null) {
            return null;
        }
        return new ManagementLockImpl(inner.id(), inner, this.manager());
    }

    public PagedList<ManagementLock> list() {
        return this.wrapList(this.inner().list());
    }

    public Observable<ManagementLock> listAsync() {
        return this.wrapPageAsync(this.inner().listAsync());
    }

    public Completable deleteByIdAsync(String id) {
        String scope = ManagementLocksImpl.resourceIdFromLockId(id);
        String lockName = ResourceUtils.nameFromResourceId((String)id);
        if (scope != null && lockName != null) {
            return this.inner().deleteByScopeAsync(scope, lockName).toCompletable();
        }
        return Observable.empty().toCompletable();
    }

    public PagedList<ManagementLock> listByResourceGroup(String resourceGroupName) {
        return this.wrapList(this.inner().listByResourceGroup(resourceGroupName));
    }

    public Observable<ManagementLock> listByResourceGroupAsync(String resourceGroupName) {
        return this.wrapPageAsync(this.inner().listByResourceGroupAsync(resourceGroupName));
    }

    public ManagementLock getByResourceGroup(String resourceGroupName, String name) {
        return (ManagementLock)this.getByResourceGroupAsync(resourceGroupName, name).toBlocking().last();
    }

    public ServiceFuture<ManagementLock> getByResourceGroupAsync(String resourceGroupName, String name, ServiceCallback<ManagementLock> callback) {
        return ServiceFuture.fromBody(this.getByResourceGroupAsync(resourceGroupName, name), callback);
    }

    public Observable<ManagementLock> getByResourceGroupAsync(String resourceGroupName, String name) {
        return this.inner().getByResourceGroupAsync(resourceGroupName, name).map((Func1)new Func1<ManagementLockObjectInner, ManagementLock>(){

            public ManagementLock call(ManagementLockObjectInner innerT) {
                return ManagementLocksImpl.this.wrapModel(innerT);
            }
        });
    }

    public ManagementLock getById(String id) {
        return (ManagementLock)this.getByIdAsync(id).toBlocking().last();
    }

    public Observable<ManagementLock> getByIdAsync(String id) {
        String resourceId = ManagementLocksImpl.resourceIdFromLockId(id);
        String lockName = ResourceUtils.nameFromResourceId((String)id);
        if (resourceId != null && lockName != null) {
            return this.inner().getByScopeAsync(resourceId, lockName).map((Func1)new Func1<ManagementLockObjectInner, ManagementLock>(){

                public ManagementLock call(ManagementLockObjectInner inner) {
                    return ManagementLocksImpl.this.wrapModel(inner);
                }
            });
        }
        return null;
    }

    public ServiceFuture<ManagementLock> getByIdAsync(String id, ServiceCallback<ManagementLock> callback) {
        return ServiceFuture.fromBody(this.getByIdAsync(id), callback);
    }

    public ServiceFuture<Void> deleteByResourceGroupAsync(String resourceGroupName, String name, ServiceCallback<Void> callback) {
        return ServiceFuture.fromBody((Observable)this.deleteByResourceGroupAsync(resourceGroupName, name).andThen(Observable.just(null)), callback);
    }

    public void deleteByResourceGroup(String resourceGroupName, String name) {
        this.deleteByResourceGroupAsync(resourceGroupName, name).await();
    }

    public Completable deleteByResourceGroupAsync(String resourceGroupName, String name) {
        return this.inner().deleteAtResourceGroupLevelAsync(resourceGroupName, name).toCompletable();
    }

    public Observable<String> deleteByIdsAsync(Collection<String> ids) {
        if (ids == null || ids.isEmpty()) {
            return Observable.empty();
        }
        ArrayList<Observable> observables = new ArrayList<Observable>();
        for (String id : ids) {
            String lockName = ResourceUtils.nameFromResourceId((String)id);
            String scopeName = ManagementLocksImpl.resourceIdFromLockId(id);
            if (lockName == null || scopeName == null) continue;
            Observable o = RXMapper.map(this.inner().deleteByScopeAsync(scopeName, lockName), (Object)id);
            observables.add(o);
        }
        return Observable.mergeDelayError(observables);
    }

    public Observable<String> deleteByIdsAsync(String ... ids) {
        return this.deleteByIdsAsync(new ArrayList<String>(Arrays.asList(ids)));
    }

    public void deleteByIds(Collection<String> ids) {
        this.deleteByIdsAsync(ids).toCompletable().await();
    }

    public void deleteByIds(String ... ids) {
        this.deleteByIdsAsync(ids).toCompletable().await();
    }

    public AuthorizationManager manager() {
        return this.manager;
    }

    public ManagementLocksInner inner() {
        return ((ManagementLockClientImpl)((Object)this.manager().inner())).managementLocks();
    }

    @Override
    public PagedList<ManagementLock> listForResource(String resourceId) {
        return this.wrapList(this.inner().listAtResourceLevel(ResourceUtils.groupFromResourceId((String)resourceId), ResourceUtils.resourceProviderFromResourceId((String)resourceId), ResourceUtils.parentRelativePathFromResourceId((String)resourceId), ResourceUtils.resourceTypeFromResourceId((String)resourceId), ResourceUtils.nameFromResourceId((String)resourceId)));
    }

    @Override
    public Observable<ManagementLock> listForResourceAsync(String resourceId) {
        return this.wrapPageAsync(this.inner().listAtResourceLevelAsync(ResourceUtils.groupFromResourceId((String)resourceId), ResourceUtils.resourceProviderFromResourceId((String)resourceId), ResourceUtils.parentRelativePathFromResourceId((String)resourceId), ResourceUtils.resourceTypeFromResourceId((String)resourceId), ResourceUtils.nameFromResourceId((String)resourceId)));
    }
}

