/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.security;

import java.util.Arrays;
import java.util.Objects;
import org.elasticsearch.client.Validatable;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.util.CollectionUtils;

public final class GetPrivilegesRequest
implements Validatable {
    private final String applicationName;
    private final String[] privilegeNames;

    public GetPrivilegesRequest(@Nullable String applicationName, String ... privilegeNames) {
        if (!CollectionUtils.isEmpty((Object[])privilegeNames) && Strings.isNullOrEmpty((String)applicationName)) {
            throw new IllegalArgumentException("privilege cannot be specified when application is missing");
        }
        this.applicationName = applicationName;
        this.privilegeNames = privilegeNames;
    }

    public static GetPrivilegesRequest getAllPrivileges() {
        return new GetPrivilegesRequest(null, new String[0]);
    }

    public static GetPrivilegesRequest getApplicationPrivileges(String applicationName) {
        if (Strings.isNullOrEmpty((String)applicationName)) {
            throw new IllegalArgumentException("application name is required");
        }
        return new GetPrivilegesRequest(applicationName, new String[0]);
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public String[] getPrivilegeNames() {
        return this.privilegeNames;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetPrivilegesRequest that = (GetPrivilegesRequest)o;
        return Objects.equals(this.applicationName, that.applicationName) && Arrays.equals(this.privilegeNames, that.privilegeNames);
    }

    public int hashCode() {
        int result = Objects.hash(this.applicationName);
        result = 31 * result + Arrays.hashCode(this.privilegeNames);
        return result;
    }
}

