/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.engine.impl;

import org.apache.qpid.protonj2.buffer.ProtonBuffer;
import org.apache.qpid.protonj2.engine.EventHandler;
import org.apache.qpid.protonj2.engine.OutgoingDelivery;
import org.apache.qpid.protonj2.engine.impl.ProtonAttachments;
import org.apache.qpid.protonj2.engine.impl.ProtonSender;
import org.apache.qpid.protonj2.types.DeliveryTag;
import org.apache.qpid.protonj2.types.transport.DeliveryState;

public class ProtonOutgoingDelivery
implements OutgoingDelivery {
    private static final long DELIVERY_INACTIVE = -1L;
    private static final long DELIVERY_ABORTED = -2L;
    private final ProtonSender link;
    private long deliveryId = -1L;
    private DeliveryTag deliveryTag;
    private boolean complete;
    private int messageFormat;
    private boolean aborted;
    private int transferCount;
    private DeliveryState localState;
    private boolean locallySettled;
    private DeliveryState remoteState;
    private boolean remotelySettled;
    private ProtonAttachments attachments;
    private Object linkedResource;
    private EventHandler<OutgoingDelivery> deliveryUpdatedEventHandler = null;

    public ProtonOutgoingDelivery(ProtonSender link) {
        this.link = link;
    }

    @Override
    public ProtonSender getLink() {
        return this.link;
    }

    @Override
    public ProtonAttachments getAttachments() {
        return this.attachments == null ? (this.attachments = new ProtonAttachments()) : this.attachments;
    }

    @Override
    public ProtonOutgoingDelivery setLinkedResource(Object resource) {
        this.linkedResource = resource;
        return this;
    }

    @Override
    public <T> T getLinkedResource() {
        return (T)this.linkedResource;
    }

    @Override
    public <T> T getLinkedResource(Class<T> typeClass) {
        return typeClass.cast(this.linkedResource);
    }

    @Override
    public DeliveryTag getTag() {
        return this.deliveryTag;
    }

    @Override
    public OutgoingDelivery setTag(byte[] deliveryTag) {
        if (this.transferCount > 0) {
            throw new IllegalStateException("Cannot change delivery tag once Delivery has sent Transfer frames");
        }
        if (this.deliveryTag != null) {
            this.deliveryTag.release();
            this.deliveryTag = null;
        }
        this.deliveryTag = new DeliveryTag.ProtonDeliveryTag(deliveryTag);
        return this;
    }

    @Override
    public OutgoingDelivery setTag(DeliveryTag deliveryTag) {
        this.deliveryTag = deliveryTag;
        return this;
    }

    @Override
    public DeliveryState getState() {
        return this.localState;
    }

    @Override
    public DeliveryState getRemoteState() {
        return this.remoteState;
    }

    @Override
    public int getMessageFormat() {
        return this.messageFormat;
    }

    @Override
    public OutgoingDelivery setMessageFormat(int messageFormat) {
        if (this.transferCount > 0 && this.messageFormat != messageFormat) {
            throw new IllegalStateException("Cannot change the message format once Delivery has sent Transfer frames");
        }
        this.messageFormat = messageFormat;
        return this;
    }

    @Override
    public boolean isPartial() {
        return !this.complete && !this.aborted;
    }

    @Override
    public boolean isAborted() {
        return this.aborted;
    }

    @Override
    public boolean isSettled() {
        return this.locallySettled;
    }

    @Override
    public boolean isRemotelySettled() {
        return this.remotelySettled;
    }

    @Override
    public OutgoingDelivery disposition(DeliveryState state) {
        return this.disposition(state, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OutgoingDelivery disposition(DeliveryState state, boolean settle) {
        if (this.locallySettled) {
            if (this.localState != null && !this.localState.equals(state) || this.localState != state) {
                throw new IllegalStateException("Cannot update disposition on an already settled Delivery");
            }
            return this;
        }
        DeliveryState oldState = this.localState;
        this.locallySettled = settle;
        this.localState = state;
        if (this.complete && (oldState != this.localState || settle)) {
            try {
                this.link.disposition(this);
            }
            finally {
                this.tryRetireDeliveryTag();
            }
        }
        return this;
    }

    @Override
    public OutgoingDelivery settle() {
        return this.disposition(this.localState, true);
    }

    @Override
    public OutgoingDelivery writeBytes(ProtonBuffer buffer) {
        this.checkCompleteOrAborted();
        try {
            this.link.send(this, buffer, true);
        }
        finally {
            this.tryRetireDeliveryTag();
        }
        return this;
    }

    @Override
    public OutgoingDelivery streamBytes(ProtonBuffer buffer) {
        return this.streamBytes(buffer, false);
    }

    @Override
    public OutgoingDelivery streamBytes(ProtonBuffer buffer, boolean complete) {
        this.checkCompleteOrAborted();
        try {
            this.link.send(this, buffer, complete);
        }
        finally {
            this.tryRetireDeliveryTag();
        }
        return this;
    }

    @Override
    public OutgoingDelivery abort() {
        this.checkComplete();
        if (this.deliveryId != -2L) {
            this.locallySettled = true;
            this.aborted = true;
            try {
                this.link.abort(this);
            }
            finally {
                this.tryRetireDeliveryTag();
                this.deliveryId = -2L;
            }
        }
        return this;
    }

    @Override
    public ProtonOutgoingDelivery deliveryStateUpdatedHandler(EventHandler<OutgoingDelivery> handler) {
        this.deliveryUpdatedEventHandler = handler;
        return this;
    }

    EventHandler<OutgoingDelivery> deliveryStateUpdatedHandler() {
        return this.deliveryUpdatedEventHandler;
    }

    public String toString() {
        return "ProtonOutgoingDelivery { deliveryId = " + this.deliveryId + ", deliveryTag = " + this.deliveryTag + " };";
    }

    private void tryRetireDeliveryTag() {
        if (this.deliveryTag != null && this.isSettled()) {
            this.deliveryTag.release();
        }
    }

    long getDeliveryId() {
        return this.deliveryId;
    }

    int getDeliveryIdInt() {
        return (int)this.deliveryId;
    }

    void setDeliveryId(long deliveryId) {
        this.deliveryId = deliveryId;
    }

    @Override
    public int getTransferCount() {
        return this.transferCount;
    }

    void afterTransferWritten() {
        ++this.transferCount;
    }

    ProtonOutgoingDelivery remotelySettled() {
        this.remotelySettled = true;
        return this;
    }

    ProtonOutgoingDelivery remoteState(DeliveryState remoteState) {
        this.remoteState = remoteState;
        return this;
    }

    ProtonOutgoingDelivery locallySettled() {
        this.locallySettled = true;
        return this;
    }

    ProtonOutgoingDelivery localState(DeliveryState localState) {
        this.localState = localState;
        return this;
    }

    ProtonOutgoingDelivery markComplete() {
        this.complete = true;
        return this;
    }

    private void checkComplete() {
        if (this.complete) {
            throw new IllegalArgumentException("Cannot write to a delivery already marked as complete.");
        }
    }

    private void checkCompleteOrAborted() {
        if (this.complete || this.aborted) {
            throw new IllegalArgumentException("Cannot write to a delivery already marked as complete or has been aborted.");
        }
    }
}

