/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je;

import com.sleepycat.je.EnvironmentFailureException;
import java.util.StringTokenizer;

public class Durability {
    public static final Durability COMMIT_SYNC = new Durability(SyncPolicy.SYNC, SyncPolicy.NO_SYNC, ReplicaAckPolicy.SIMPLE_MAJORITY);
    public static final Durability COMMIT_NO_SYNC = new Durability(SyncPolicy.NO_SYNC, SyncPolicy.NO_SYNC, ReplicaAckPolicy.SIMPLE_MAJORITY);
    public static final Durability COMMIT_WRITE_NO_SYNC = new Durability(SyncPolicy.WRITE_NO_SYNC, SyncPolicy.NO_SYNC, ReplicaAckPolicy.SIMPLE_MAJORITY);
    public static final Durability READ_ONLY_TXN = new Durability(SyncPolicy.NO_SYNC, SyncPolicy.NO_SYNC, ReplicaAckPolicy.NONE);
    private final SyncPolicy localSync;
    private final SyncPolicy replicaSync;
    private final ReplicaAckPolicy replicaAck;

    public Durability(SyncPolicy localSync, SyncPolicy replicaSync, ReplicaAckPolicy replicaAck) {
        this.localSync = localSync;
        this.replicaSync = replicaSync;
        this.replicaAck = replicaAck;
    }

    public static Durability parse(String durabilityString) {
        if (durabilityString == null) {
            return null;
        }
        StringTokenizer tokenizer = new StringTokenizer(durabilityString.toUpperCase(), ",");
        if (!tokenizer.hasMoreTokens()) {
            throw new IllegalArgumentException("Bad string format: \"" + durabilityString + '\"');
        }
        SyncPolicy localSync = SyncPolicy.valueOf(tokenizer.nextToken());
        SyncPolicy replicaSync = tokenizer.hasMoreTokens() ? SyncPolicy.valueOf(tokenizer.nextToken()) : SyncPolicy.NO_SYNC;
        ReplicaAckPolicy replicaAck = tokenizer.hasMoreTokens() ? ReplicaAckPolicy.valueOf(tokenizer.nextToken()) : ReplicaAckPolicy.SIMPLE_MAJORITY;
        return new Durability(localSync, replicaSync, replicaAck);
    }

    public String toString() {
        return this.localSync.toString() + "," + this.replicaSync.toString() + "," + this.replicaAck.toString();
    }

    public SyncPolicy getLocalSync() {
        return this.localSync;
    }

    public SyncPolicy getReplicaSync() {
        return this.replicaSync;
    }

    public ReplicaAckPolicy getReplicaAck() {
        return this.replicaAck;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.localSync == null ? 0 : this.localSync.hashCode());
        result = 31 * result + (this.replicaAck == null ? 0 : this.replicaAck.hashCode());
        result = 31 * result + (this.replicaSync == null ? 0 : this.replicaSync.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Durability)) {
            return false;
        }
        Durability other = (Durability)obj;
        if (this.localSync == null ? other.localSync != null : !this.localSync.equals((Object)other.localSync)) {
            return false;
        }
        if (this.replicaAck == null ? other.replicaAck != null : !this.replicaAck.equals((Object)other.replicaAck)) {
            return false;
        }
        return !(this.replicaSync == null ? other.replicaSync != null : !this.replicaSync.equals((Object)other.replicaSync));
    }

    public static enum ReplicaAckPolicy {
        ALL,
        NONE,
        SIMPLE_MAJORITY;


        public int minAckNodes(int groupSize) {
            switch (this) {
                case ALL: {
                    return groupSize;
                }
                case NONE: {
                    return 1;
                }
                case SIMPLE_MAJORITY: {
                    return groupSize / 2 + 1;
                }
            }
            throw EnvironmentFailureException.unexpectedState("Unknown ack policy: " + (Object)((Object)this));
        }
    }

    public static enum SyncPolicy {
        SYNC,
        NO_SYNC,
        WRITE_NO_SYNC;

    }
}

