/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.transport;

import java.util.EnumSet;
import java.util.Set;
import org.apache.qpid.server.model.Broker;
import org.apache.qpid.server.model.Protocol;
import org.apache.qpid.server.model.Transport;
import org.apache.qpid.server.model.port.AmqpPort;
import org.apache.qpid.server.transport.AcceptingTransport;
import org.apache.qpid.server.transport.MultiVersionProtocolEngineFactory;
import org.apache.qpid.server.transport.NetworkConnectionScheduler;
import org.apache.qpid.server.transport.NonBlockingNetworkTransport;
import org.apache.qpid.server.transport.network.TransportEncryption;

class TCPandSSLTransport
implements AcceptingTransport {
    private final AmqpPort<?> _port;
    private final Set<Protocol> _supported;
    private final Protocol _defaultSupportedProtocolReply;
    private NonBlockingNetworkTransport _networkTransport;
    private volatile Set<Transport> _transports;
    private NetworkConnectionScheduler _scheduler;

    TCPandSSLTransport(Set<Transport> transports, AmqpPort<?> port, Set<Protocol> supported, Protocol defaultSupportedProtocolReply) {
        this._transports = transports;
        this._port = port;
        this._supported = supported;
        this._defaultSupportedProtocolReply = defaultSupportedProtocolReply;
    }

    @Override
    public void start() {
        MultiVersionProtocolEngineFactory protocolEngineFactory = new MultiVersionProtocolEngineFactory((Broker)this._port.getParent(), this._supported, this._defaultSupportedProtocolReply, this._port, this._transports.contains((Object)Transport.TCP) ? Transport.TCP : Transport.SSL);
        EnumSet<TransportEncryption> encryptionSet = this.buildEncryptionSet(this._transports);
        long threadPoolKeepAliveTimeout = this._port.getContextValue(Long.class, "qpid.port.amqp.threadPool.keep_alive_timeout");
        this._scheduler = new NetworkConnectionScheduler("Port-" + this._port.getName(), this._port.getNumberOfSelectors(), this._port.getThreadPoolSize(), threadPoolKeepAliveTimeout);
        this._scheduler.start();
        this._networkTransport = new NonBlockingNetworkTransport(protocolEngineFactory, encryptionSet, this._scheduler, this._port);
        this._networkTransport.start();
    }

    private EnumSet<TransportEncryption> buildEncryptionSet(Set<Transport> transports) {
        EnumSet<TransportEncryption> encryptionSet = EnumSet.noneOf(TransportEncryption.class);
        if (transports.contains((Object)Transport.TCP)) {
            encryptionSet.add(TransportEncryption.NONE);
        }
        if (transports.contains((Object)Transport.SSL)) {
            encryptionSet.add(TransportEncryption.TLS);
        }
        return encryptionSet;
    }

    @Override
    public int getAcceptingPort() {
        NonBlockingNetworkTransport networkTransport = this._networkTransport;
        return networkTransport == null ? this._port.getPort() : networkTransport.getAcceptingPort();
    }

    @Override
    public boolean updatesSSLContext() {
        Set<Transport> transports = this._port.getTransports();
        this._transports = transports;
        this._networkTransport.setEncryptionSet(this.buildEncryptionSet(transports));
        return true;
    }

    @Override
    public void close() {
        if (this._networkTransport != null) {
            this._networkTransport.close();
        }
        if (this._scheduler != null) {
            this._scheduler.close();
        }
    }
}

