/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security.auth.manager.oauth2;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.Map;
import org.apache.qpid.server.util.ServerScopedRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuth2Utils {
    private static final Logger LOGGER = LoggerFactory.getLogger(OAuth2Utils.class);

    public static String buildRequestQuery(Map<String, String> requestBodyParameters) {
        try {
            String charset = StandardCharsets.UTF_8.name();
            StringBuilder bodyBuilder = new StringBuilder();
            Iterator<Map.Entry<String, String>> iterator = requestBodyParameters.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, String> entry = iterator.next();
                bodyBuilder.append(URLEncoder.encode(entry.getKey(), charset));
                bodyBuilder.append("=");
                bodyBuilder.append(URLEncoder.encode(entry.getValue(), charset));
                if (!iterator.hasNext()) continue;
                bodyBuilder.append("&");
            }
            return bodyBuilder.toString();
        }
        catch (UnsupportedEncodingException e) {
            throw new ServerScopedRuntimeException("Failed to encode as UTF-8", e);
        }
    }

    public static InputStream getResponseStream(HttpURLConnection connection) throws IOException {
        try {
            return connection.getInputStream();
        }
        catch (IOException ioe) {
            InputStream errorStream = connection.getErrorStream();
            if (errorStream != null) {
                return errorStream;
            }
            throw ioe;
        }
    }
}

