/*
 * Decompiled with CFR 0.152.
 */
package org.apache.distributedlog;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.bookkeeper.common.concurrent.FutureUtils;
import org.apache.bookkeeper.versioning.Versioned;
import org.apache.distributedlog.BKAsyncLogWriter;
import org.apache.distributedlog.BKDistributedLogManager;
import org.apache.distributedlog.BKLogReadHandler;
import org.apache.distributedlog.DLMTestUtil;
import org.apache.distributedlog.DLSN;
import org.apache.distributedlog.DistributedLogConfiguration;
import org.apache.distributedlog.DistributedLogConstants;
import org.apache.distributedlog.LogRecord;
import org.apache.distributedlog.LogRecordWithDLSN;
import org.apache.distributedlog.LogSegmentMetadata;
import org.apache.distributedlog.TestDistributedLogBase;
import org.apache.distributedlog.api.AsyncLogWriter;
import org.apache.distributedlog.api.DistributedLogManager;
import org.apache.distributedlog.api.LogWriter;
import org.apache.distributedlog.exceptions.LogNotFoundException;
import org.apache.distributedlog.exceptions.OwnershipAcquireFailedException;
import org.apache.distributedlog.io.AsyncCloseable;
import org.apache.distributedlog.logsegment.LogSegmentFilter;
import org.apache.distributedlog.util.Utils;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestBKLogReadHandler
extends TestDistributedLogBase {
    static final Logger LOG = LoggerFactory.getLogger(TestBKLogReadHandler.class);
    @Rule
    public TestName runtime = new TestName();

    private void prepareLogSegmentsNonPartitioned(String name, int numSegments, int numEntriesPerSegment) throws Exception {
        BKDistributedLogManager dlm = this.createNewDLM(conf, name);
        long txid = 1L;
        for (int sid = 0; sid < numSegments; ++sid) {
            LogWriter out = dlm.startLogSegmentNonPartitioned();
            for (int eid = 0; eid < numEntriesPerSegment; ++eid) {
                LogRecord record = DLMTestUtil.getLargeLogRecordInstance(txid);
                out.write(record);
                ++txid;
            }
            out.close();
        }
        dlm.close();
    }

    @Test(timeout=60000L)
    public void testGetFirstDLSNWithOpenLedger() throws Exception {
        String dlName = this.runtime.getMethodName();
        DistributedLogConfiguration confLocal = new DistributedLogConfiguration();
        confLocal.loadConf(conf);
        confLocal.setImmediateFlushEnabled(false);
        confLocal.setOutputBufferSize(0);
        int numEntriesPerSegment = 10;
        BKDistributedLogManager dlm1 = this.createNewDLM(confLocal, dlName);
        long txid = 1L;
        ArrayList<CompletableFuture> futures = new ArrayList<CompletableFuture>(numEntriesPerSegment);
        AsyncLogWriter out = dlm1.startAsyncLogSegmentNonPartitioned();
        for (int eid = 0; eid < numEntriesPerSegment; ++eid) {
            futures.add(out.write(DLMTestUtil.getLogRecordInstance(txid)));
            ++txid;
        }
        Utils.ioResult((CompletableFuture)FutureUtils.collect(futures));
        LogRecord controlRecord = new LogRecord(txid, DistributedLogConstants.CONTROL_RECORD_CONTENT);
        controlRecord.setControl();
        Utils.ioResult((CompletableFuture)out.write(controlRecord));
        DLSN last = dlm1.getLastDLSN();
        Assert.assertEquals((Object)new DLSN(1L, 9L, 0L), (Object)last);
        DLSN first = (DLSN)Utils.ioResult((CompletableFuture)dlm1.getFirstDLSNAsync());
        Assert.assertEquals((Object)new DLSN(1L, 0L, 0L), (Object)first);
        Utils.close((AsyncCloseable)out);
    }

    @Test(timeout=60000L)
    public void testGetFirstDLSNNoLogSegments() throws Exception {
        String dlName = this.runtime.getMethodName();
        BKDistributedLogManager dlm = this.createNewDLM(conf, dlName);
        BKLogReadHandler readHandler = dlm.createReadHandler();
        CompletableFuture futureRecord = readHandler.asyncGetFirstLogRecord();
        try {
            Utils.ioResult((CompletableFuture)futureRecord);
            Assert.fail((String)"should have thrown exception");
        }
        catch (LogNotFoundException logNotFoundException) {
            // empty catch block
        }
    }

    @Test(timeout=60000L)
    public void testGetFirstDLSNWithLogSegments() throws Exception {
        String dlName = this.runtime.getMethodName();
        BKDistributedLogManager dlm = this.createNewDLM(conf, dlName);
        DLMTestUtil.generateCompletedLogSegments((DistributedLogManager)dlm, conf, 3L, 3L);
        BKLogReadHandler readHandler = dlm.createReadHandler();
        CompletableFuture futureRecord = readHandler.asyncGetFirstLogRecord();
        try {
            LogRecordWithDLSN record = (LogRecordWithDLSN)Utils.ioResult((CompletableFuture)futureRecord);
            Assert.assertEquals((Object)new DLSN(1L, 0L, 0L), (Object)record.getDlsn());
        }
        catch (Exception ex) {
            Assert.fail((String)("should not have thrown exception: " + ex));
        }
    }

    @Test(timeout=60000L)
    public void testGetFirstDLSNAfterCleanTruncation() throws Exception {
        String dlName = this.runtime.getMethodName();
        this.prepareLogSegmentsNonPartitioned(dlName, 3, 10);
        BKDistributedLogManager dlm = this.createNewDLM(conf, dlName);
        BKLogReadHandler readHandler = dlm.createReadHandler();
        AsyncLogWriter writer = dlm.startAsyncLogSegmentNonPartitioned();
        CompletableFuture futureSuccess = writer.truncate(new DLSN(2L, 0L, 0L));
        Boolean success = (Boolean)Utils.ioResult((CompletableFuture)futureSuccess);
        Assert.assertTrue((boolean)success);
        CompletableFuture futureRecord = readHandler.asyncGetFirstLogRecord();
        LogRecordWithDLSN record = (LogRecordWithDLSN)Utils.ioResult((CompletableFuture)futureRecord);
        Assert.assertEquals((Object)new DLSN(2L, 0L, 0L), (Object)record.getDlsn());
    }

    @Test(timeout=60000L)
    public void testGetFirstDLSNAfterPartialTruncation() throws Exception {
        String dlName = this.runtime.getMethodName();
        this.prepareLogSegmentsNonPartitioned(dlName, 3, 10);
        BKDistributedLogManager dlm = this.createNewDLM(conf, dlName);
        BKLogReadHandler readHandler = dlm.createReadHandler();
        AsyncLogWriter writer = dlm.startAsyncLogSegmentNonPartitioned();
        CompletableFuture futureSuccess = writer.truncate(new DLSN(2L, 5L, 0L));
        Boolean success = (Boolean)Utils.ioResult((CompletableFuture)futureSuccess);
        Assert.assertTrue((boolean)success);
        CompletableFuture futureRecord = readHandler.asyncGetFirstLogRecord();
        LogRecordWithDLSN record = (LogRecordWithDLSN)Utils.ioResult((CompletableFuture)futureRecord);
        Assert.assertEquals((Object)new DLSN(2L, 0L, 0L), (Object)record.getDlsn());
    }

    @Test(timeout=60000L)
    public void testGetLogRecordCountEmptyLedger() throws Exception {
        String dlName = this.runtime.getMethodName();
        BKDistributedLogManager dlm = this.createNewDLM(conf, dlName);
        BKLogReadHandler readHandler = dlm.createReadHandler();
        CompletableFuture count = null;
        count = readHandler.asyncGetLogRecordCount(DLSN.InitialDLSN);
        try {
            Utils.ioResult((CompletableFuture)count);
            Assert.fail((String)"log is empty, should have returned log empty ex");
        }
        catch (LogNotFoundException logNotFoundException) {
            // empty catch block
        }
    }

    @Test(timeout=60000L)
    public void testGetLogRecordCountTotalCount() throws Exception {
        String dlName = this.runtime.getMethodName();
        this.prepareLogSegmentsNonPartitioned(dlName, 11, 3);
        BKDistributedLogManager dlm = this.createNewDLM(conf, dlName);
        BKLogReadHandler readHandler = dlm.createReadHandler();
        CompletableFuture count = null;
        count = readHandler.asyncGetLogRecordCount(DLSN.InitialDLSN);
        Assert.assertEquals((long)33L, (long)((Long)Utils.ioResult((CompletableFuture)count)));
    }

    @Test(timeout=60000L)
    public void testGetLogRecordCountAtLedgerBoundary() throws Exception {
        String dlName = this.runtime.getMethodName();
        this.prepareLogSegmentsNonPartitioned(dlName, 11, 3);
        BKDistributedLogManager dlm = this.createNewDLM(conf, dlName);
        BKLogReadHandler readHandler = dlm.createReadHandler();
        CompletableFuture count = null;
        count = readHandler.asyncGetLogRecordCount(new DLSN(2L, 0L, 0L));
        Assert.assertEquals((long)30L, (long)((Long)Utils.ioResult((CompletableFuture)count)));
        count = readHandler.asyncGetLogRecordCount(new DLSN(3L, 0L, 0L));
        Assert.assertEquals((long)27L, (long)((Long)Utils.ioResult((CompletableFuture)count)));
    }

    @Test(timeout=60000L)
    public void testGetLogRecordCountPastEnd() throws Exception {
        String dlName = this.runtime.getMethodName();
        this.prepareLogSegmentsNonPartitioned(dlName, 11, 3);
        BKDistributedLogManager dlm = this.createNewDLM(conf, dlName);
        BKLogReadHandler readHandler = dlm.createReadHandler();
        CompletableFuture count = null;
        count = readHandler.asyncGetLogRecordCount(new DLSN(12L, 0L, 0L));
        Assert.assertEquals((long)0L, (long)((Long)Utils.ioResult((CompletableFuture)count)));
    }

    @Test(timeout=60000L)
    public void testGetLogRecordCountLastRecord() throws Exception {
        String dlName = this.runtime.getMethodName();
        this.prepareLogSegmentsNonPartitioned(dlName, 11, 3);
        BKDistributedLogManager dlm = this.createNewDLM(conf, dlName);
        BKLogReadHandler readHandler = dlm.createReadHandler();
        CompletableFuture count = null;
        count = readHandler.asyncGetLogRecordCount(new DLSN(11L, 2L, 0L));
        Assert.assertEquals((long)1L, (long)((Long)Utils.ioResult((CompletableFuture)count)));
    }

    @Test(timeout=60000L)
    public void testGetLogRecordCountInteriorRecords() throws Exception {
        String dlName = this.runtime.getMethodName();
        this.prepareLogSegmentsNonPartitioned(dlName, 5, 10);
        BKDistributedLogManager dlm = this.createNewDLM(conf, dlName);
        BKLogReadHandler readHandler = dlm.createReadHandler();
        CompletableFuture count = null;
        count = readHandler.asyncGetLogRecordCount(new DLSN(3L, 5L, 0L));
        Assert.assertEquals((long)25L, (long)((Long)Utils.ioResult((CompletableFuture)count)));
        count = readHandler.asyncGetLogRecordCount(new DLSN(2L, 5L, 0L));
        Assert.assertEquals((long)35L, (long)((Long)Utils.ioResult((CompletableFuture)count)));
    }

    @Test(timeout=60000L)
    public void testGetLogRecordCountWithControlRecords() throws Exception {
        BKDistributedLogManager dlm = this.createNewDLM(conf, this.runtime.getMethodName());
        long txid = 1L;
        txid += DLMTestUtil.generateLogSegmentNonPartitioned((DistributedLogManager)dlm, 5, 5, txid);
        txid += DLMTestUtil.generateLogSegmentNonPartitioned((DistributedLogManager)dlm, 0, 10, txid);
        BKLogReadHandler readHandler = dlm.createReadHandler();
        CompletableFuture count = null;
        count = readHandler.asyncGetLogRecordCount(new DLSN(1L, 0L, 0L));
        Assert.assertEquals((long)15L, (long)((Long)Utils.ioResult((CompletableFuture)count)));
    }

    @Test(timeout=60000L)
    public void testGetLogRecordCountWithAllControlRecords() throws Exception {
        BKDistributedLogManager dlm = this.createNewDLM(conf, this.runtime.getMethodName());
        long txid = 1L;
        txid += DLMTestUtil.generateLogSegmentNonPartitioned((DistributedLogManager)dlm, 5, 0, txid);
        txid += DLMTestUtil.generateLogSegmentNonPartitioned((DistributedLogManager)dlm, 10, 0, txid);
        BKLogReadHandler readHandler = dlm.createReadHandler();
        CompletableFuture count = null;
        count = readHandler.asyncGetLogRecordCount(new DLSN(1L, 0L, 0L));
        Assert.assertEquals((long)0L, (long)((Long)Utils.ioResult((CompletableFuture)count)));
    }

    @Test(timeout=60000L)
    public void testGetLogRecordCountWithSingleInProgressLedger() throws Exception {
        String streamName = this.runtime.getMethodName();
        BKDistributedLogManager bkdlm = this.createNewDLM(conf, streamName);
        BKAsyncLogWriter out = bkdlm.startAsyncLogSegmentNonPartitioned();
        int txid = 1;
        Utils.ioResult((CompletableFuture)out.write(DLMTestUtil.getLargeLogRecordInstance(txid++, false)));
        Utils.ioResult((CompletableFuture)out.write(DLMTestUtil.getLargeLogRecordInstance(txid++, false)));
        Utils.ioResult((CompletableFuture)out.write(DLMTestUtil.getLargeLogRecordInstance(txid++, false)));
        BKLogReadHandler readHandler = bkdlm.createReadHandler();
        List ledgerList = (List)((Versioned)Utils.ioResult((CompletableFuture)readHandler.readLogSegmentsFromStore(LogSegmentMetadata.COMPARATOR, LogSegmentFilter.DEFAULT_FILTER, null))).getValue();
        Assert.assertEquals((long)1L, (long)ledgerList.size());
        Assert.assertTrue((boolean)((LogSegmentMetadata)ledgerList.get(0)).isInProgress());
        CompletableFuture count = null;
        count = readHandler.asyncGetLogRecordCount(new DLSN(1L, 0L, 0L));
        Assert.assertEquals((long)2L, (long)((Long)Utils.ioResult((CompletableFuture)count)));
        Utils.close((AsyncCloseable)out);
    }

    @Test(timeout=60000L)
    public void testGetLogRecordCountWithCompletedAndInprogressLedgers() throws Exception {
        String streamName = this.runtime.getMethodName();
        BKDistributedLogManager bkdlm = this.createNewDLM(conf, streamName);
        long txid = 1L;
        txid += DLMTestUtil.generateLogSegmentNonPartitioned((DistributedLogManager)bkdlm, 0, 5, txid);
        BKAsyncLogWriter out = bkdlm.startAsyncLogSegmentNonPartitioned();
        Utils.ioResult((CompletableFuture)out.write(DLMTestUtil.getLargeLogRecordInstance(txid++, false)));
        Utils.ioResult((CompletableFuture)out.write(DLMTestUtil.getLargeLogRecordInstance(txid++, false)));
        Utils.ioResult((CompletableFuture)out.write(DLMTestUtil.getLargeLogRecordInstance(txid++, false)));
        BKLogReadHandler readHandler = bkdlm.createReadHandler();
        List ledgerList = (List)((Versioned)Utils.ioResult((CompletableFuture)readHandler.readLogSegmentsFromStore(LogSegmentMetadata.COMPARATOR, LogSegmentFilter.DEFAULT_FILTER, null))).getValue();
        Assert.assertEquals((long)2L, (long)ledgerList.size());
        Assert.assertFalse((boolean)((LogSegmentMetadata)ledgerList.get(0)).isInProgress());
        Assert.assertTrue((boolean)((LogSegmentMetadata)ledgerList.get(1)).isInProgress());
        CompletableFuture count = null;
        count = readHandler.asyncGetLogRecordCount(new DLSN(1L, 0L, 0L));
        Assert.assertEquals((long)7L, (long)((Long)Utils.ioResult((CompletableFuture)count)));
        Utils.close((AsyncCloseable)out);
    }

    @Test(timeout=60000L)
    public void testLockStreamWithMissingLog() throws Exception {
        String streamName = this.runtime.getMethodName();
        BKDistributedLogManager bkdlm = this.createNewDLM(conf, streamName);
        BKLogReadHandler readHandler = bkdlm.createReadHandler();
        try {
            Utils.ioResult((CompletableFuture)readHandler.lockStream());
            Assert.fail((String)"Should fail lock stream if log not found");
        }
        catch (LogNotFoundException logNotFoundException) {
            // empty catch block
        }
        BKLogReadHandler subscriberReadHandler = bkdlm.createReadHandler(Optional.of("test-subscriber"));
        try {
            Utils.ioResult((CompletableFuture)subscriberReadHandler.lockStream());
            Assert.fail((String)"Subscriber should fail lock stream if log not found");
        }
        catch (LogNotFoundException logNotFoundException) {
            // empty catch block
        }
    }

    @Test(timeout=60000L)
    public void testLockStreamDifferentSubscribers() throws Exception {
        String streamName = this.runtime.getMethodName();
        BKDistributedLogManager bkdlm = this.createNewDLM(conf, streamName);
        DLMTestUtil.generateLogSegmentNonPartitioned((DistributedLogManager)bkdlm, 0, 5, 1L);
        BKLogReadHandler readHandler = bkdlm.createReadHandler();
        Utils.ioResult((CompletableFuture)readHandler.lockStream());
        BKDistributedLogManager bkdlm10 = this.createNewDLM(conf, streamName);
        BKLogReadHandler s10Handler = bkdlm10.createReadHandler(Optional.of("s1"));
        Utils.ioResult((CompletableFuture)s10Handler.lockStream());
        BKDistributedLogManager bkdlm20 = this.createNewDLM(conf, streamName);
        BKLogReadHandler s20Handler = bkdlm20.createReadHandler(Optional.of("s2"));
        Utils.ioResult((CompletableFuture)s20Handler.lockStream());
        readHandler.asyncClose();
        bkdlm.close();
        s10Handler.asyncClose();
        bkdlm10.close();
        s20Handler.asyncClose();
        bkdlm20.close();
    }

    @Test(timeout=60000L)
    public void testLockStreamSameSubscriber() throws Exception {
        String streamName = this.runtime.getMethodName();
        BKDistributedLogManager bkdlm = this.createNewDLM(conf, streamName);
        DLMTestUtil.generateLogSegmentNonPartitioned((DistributedLogManager)bkdlm, 0, 5, 1L);
        BKLogReadHandler readHandler = bkdlm.createReadHandler();
        Utils.ioResult((CompletableFuture)readHandler.lockStream());
        BKDistributedLogManager bkdlm10 = this.createNewDLM(conf, streamName);
        BKLogReadHandler s10Handler = bkdlm10.createReadHandler(Optional.of("s1"));
        Utils.ioResult((CompletableFuture)s10Handler.lockStream());
        BKDistributedLogManager bkdlm11 = this.createNewDLM(conf, streamName);
        BKLogReadHandler s11Handler = bkdlm11.createReadHandler(Optional.of("s1"));
        try {
            Utils.ioResult((CompletableFuture)s11Handler.lockStream(), (long)10000L, (TimeUnit)TimeUnit.MILLISECONDS);
            Assert.fail((String)"Should fail lock stream using same subscriber id");
        }
        catch (OwnershipAcquireFailedException ownershipAcquireFailedException) {
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
        readHandler.asyncClose();
        bkdlm.close();
        s10Handler.asyncClose();
        bkdlm10.close();
        s11Handler.asyncClose();
        bkdlm11.close();
    }
}

