/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.loadbalance.extensions.models;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.pulsar.common.stats.Metrics;

public class AssignCounter {
    final Map<Label, AtomicLong> breakdownCounters = Map.of(Label.Success, new AtomicLong(), Label.Failure, new AtomicLong(), Label.Skip, new AtomicLong());

    public void incrementSuccess() {
        this.breakdownCounters.get((Object)Label.Success).incrementAndGet();
    }

    public void incrementFailure() {
        this.breakdownCounters.get((Object)Label.Failure).incrementAndGet();
    }

    public void incrementSkip() {
        this.breakdownCounters.get((Object)Label.Skip).incrementAndGet();
    }

    public List<Metrics> toMetrics(String advertisedBrokerAddress) {
        ArrayList<Metrics> metrics = new ArrayList<Metrics>();
        HashMap<String, String> dimensions = new HashMap<String, String>();
        dimensions.put("metric", "assign");
        dimensions.put("broker", advertisedBrokerAddress);
        for (Map.Entry<Label, AtomicLong> etr : this.breakdownCounters.entrySet()) {
            Label label = etr.getKey();
            long count = etr.getValue().get();
            HashMap<String, String> breakdownDims = new HashMap<String, String>(dimensions);
            breakdownDims.put("result", label.toString());
            Metrics breakdownMetric = Metrics.create(breakdownDims);
            breakdownMetric.put("brk_lb_assign_broker_breakdown_total", (Object)count);
            metrics.add(breakdownMetric);
        }
        return metrics;
    }

    static enum Label {
        Success,
        Failure,
        Skip;

    }
}

