/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import io.trino.matching.Capture;
import io.trino.matching.Captures;
import io.trino.matching.Pattern;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.plan.LimitNode;
import io.trino.sql.planner.plan.Patterns;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.SemiJoinNode;
import java.util.List;

public class PushLimitThroughSemiJoin
implements Rule<LimitNode> {
    private static final Capture<SemiJoinNode> CHILD = Capture.newCapture();
    private static final Pattern<LimitNode> PATTERN = Patterns.limit().with(Patterns.source().matching(Patterns.semiJoin().capturedAs(CHILD)));

    @Override
    public Pattern<LimitNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(LimitNode parent, Captures captures, Rule.Context context) {
        SemiJoinNode semiJoinNode = (SemiJoinNode)captures.get(CHILD);
        if (parent.isWithTies() && parent.getTiesResolvingScheme().get().getOrderBy().contains(semiJoinNode.getSemiJoinOutput())) {
            return Rule.Result.empty();
        }
        if (parent.getPreSortedInputs().contains(semiJoinNode.getSemiJoinOutput())) {
            return Rule.Result.empty();
        }
        return Rule.Result.ofPlanNode(semiJoinNode.replaceChildren((List<PlanNode>)ImmutableList.of((Object)parent.replaceChildren((List<PlanNode>)ImmutableList.of((Object)semiJoinNode.getSource())), (Object)semiJoinNode.getFilteringSource())));
    }
}

