/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server.security;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import io.trino.server.security.AuthenticationException;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.ws.rs.container.ContainerRequestContext;

public class BasicAuthCredentials {
    public static final String AUTHENTICATE_HEADER = "Basic realm=\"Trino\"";
    private final String user;
    private final Optional<String> password;

    public static Optional<BasicAuthCredentials> extractBasicAuthCredentials(ContainerRequestContext request) throws AuthenticationException {
        Objects.requireNonNull(request, "request is null");
        String header = Strings.nullToEmpty((String)((String)request.getHeaders().getFirst((Object)"Authorization")));
        return BasicAuthCredentials.extractBasicAuthCredentials(header);
    }

    public static Optional<BasicAuthCredentials> extractBasicAuthCredentials(String header) throws AuthenticationException {
        Objects.requireNonNull(header, "header is null");
        int space = header.indexOf(32);
        if (space < 0 || !header.substring(0, space).equalsIgnoreCase("basic")) {
            return Optional.empty();
        }
        String credentials = BasicAuthCredentials.decodeCredentials(header.substring(space + 1).trim());
        List parts = Splitter.on((char)':').limit(2).splitToList((CharSequence)credentials);
        String user = (String)parts.get(0);
        if (user.isEmpty()) {
            throw new AuthenticationException("Malformed credentials: user is empty");
        }
        Optional<Object> password = Optional.ofNullable(parts.size() == 2 ? Strings.emptyToNull((String)((String)parts.get(1))) : null);
        return Optional.of(new BasicAuthCredentials(user, password));
    }

    public BasicAuthCredentials(String user, Optional<String> password) {
        this.user = Objects.requireNonNull(user, "user is null");
        this.password = Objects.requireNonNull(password, "password is null");
    }

    public String getUser() {
        return this.user;
    }

    public Optional<String> getPassword() {
        return this.password;
    }

    private static String decodeCredentials(String credentials) throws AuthenticationException {
        try {
            return new String(Base64.getDecoder().decode(credentials), StandardCharsets.ISO_8859_1);
        }
        catch (IllegalArgumentException e) {
            throw new AuthenticationException("Invalid base64 encoded credentials");
        }
    }
}

