/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.jetcd.shaded.io.vertx.core.impl;

import io.grpc.netty.shaded.io.netty.channel.EventLoop;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.AsyncResult;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.Context;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.Future;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.Handler;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.Promise;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.ThreadingModel;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.impl.CloseFuture;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.impl.ContextBase;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.impl.ContextInternal;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.impl.Deployment;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.impl.DuplicatedContext;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.impl.EventExecutor;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.impl.TaskQueue;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.impl.VertxInternal;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.impl.WorkerPool;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.impl.future.PromiseInternal;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.impl.logging.Logger;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.impl.logging.LoggerFactory;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.json.JsonObject;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.spi.metrics.PoolMetrics;
import org.apache.pulsar.jetcd.shaded.io.vertx.core.spi.tracing.VertxTracer;

public final class ContextImpl
extends ContextBase
implements ContextInternal {
    private static final Logger log = LoggerFactory.getLogger(ContextImpl.class);
    private static final String DISABLE_TIMINGS_PROP_NAME = "vertx.disableContextTimings";
    static final boolean DISABLE_TIMINGS = Boolean.getBoolean("vertx.disableContextTimings");
    private final ThreadingModel threadingModel;
    private final VertxInternal owner;
    private final JsonObject config;
    private final Deployment deployment;
    private final CloseFuture closeFuture;
    private final ClassLoader tccl;
    private final EventLoop eventLoop;
    private final EventExecutor executor;
    private ConcurrentMap<Object, Object> data;
    private volatile Handler<Throwable> exceptionHandler;
    final TaskQueue internalOrderedTasks;
    final WorkerPool internalWorkerPool;
    final WorkerPool workerPool;
    final TaskQueue orderedTasks;

    static <T> void setResultHandler(ContextInternal ctx, Future<T> fut, Handler<AsyncResult<T>> resultHandler) {
        if (resultHandler != null) {
            fut.onComplete(resultHandler);
        } else {
            fut.onFailure(ctx::reportException);
        }
    }

    public ContextImpl(VertxInternal vertx, int localsLength, ThreadingModel threadingModel, EventLoop eventLoop, EventExecutor executor, WorkerPool internalWorkerPool, WorkerPool workerPool, TaskQueue orderedTasks, Deployment deployment, CloseFuture closeFuture, ClassLoader tccl) {
        super(localsLength);
        this.threadingModel = threadingModel;
        this.deployment = deployment;
        this.config = deployment != null ? deployment.config() : new JsonObject();
        this.eventLoop = eventLoop;
        this.executor = executor;
        this.tccl = tccl;
        this.owner = vertx;
        this.workerPool = workerPool;
        this.closeFuture = closeFuture;
        this.internalWorkerPool = internalWorkerPool;
        this.orderedTasks = orderedTasks;
        this.internalOrderedTasks = new TaskQueue();
    }

    @Override
    public Deployment getDeployment() {
        return this.deployment;
    }

    @Override
    public CloseFuture closeFuture() {
        return this.closeFuture;
    }

    @Override
    public JsonObject config() {
        return this.config;
    }

    @Override
    public EventLoop nettyEventLoop() {
        return this.eventLoop;
    }

    @Override
    public VertxInternal owner() {
        return this.owner;
    }

    @Override
    public <T> Future<T> executeBlockingInternal(Handler<Promise<T>> action) {
        return ContextImpl.executeBlocking((ContextInternal)this, action, this.internalWorkerPool, this.internalOrderedTasks);
    }

    @Override
    public <T> Future<T> executeBlockingInternal(Callable<T> action) {
        return ContextImpl.executeBlocking((ContextInternal)this, action, this.internalWorkerPool, this.internalOrderedTasks);
    }

    @Override
    public <T> Future<T> executeBlockingInternal(Handler<Promise<T>> action, boolean ordered) {
        return ContextImpl.executeBlocking((ContextInternal)this, action, this.internalWorkerPool, ordered ? this.internalOrderedTasks : null);
    }

    @Override
    public <T> Future<T> executeBlockingInternal(Callable<T> action, boolean ordered) {
        return ContextImpl.executeBlocking((ContextInternal)this, action, this.internalWorkerPool, ordered ? this.internalOrderedTasks : null);
    }

    @Override
    public <T> Future<T> executeBlocking(Handler<Promise<T>> blockingCodeHandler, boolean ordered) {
        return ContextImpl.executeBlocking((ContextInternal)this, blockingCodeHandler, this.workerPool, ordered ? this.orderedTasks : null);
    }

    @Override
    public <T> Future<T> executeBlocking(Callable<T> blockingCodeHandler, boolean ordered) {
        return ContextImpl.executeBlocking((ContextInternal)this, blockingCodeHandler, this.workerPool, ordered ? this.orderedTasks : null);
    }

    @Override
    public EventExecutor executor() {
        return this.executor;
    }

    @Override
    public boolean isEventLoopContext() {
        return this.threadingModel == ThreadingModel.EVENT_LOOP;
    }

    @Override
    public boolean isWorkerContext() {
        return this.threadingModel == ThreadingModel.WORKER;
    }

    @Override
    public ThreadingModel threadingModel() {
        return this.threadingModel;
    }

    @Override
    public boolean inThread() {
        return this.executor.inThread();
    }

    @Override
    public <T> Future<T> executeBlocking(Handler<Promise<T>> blockingCodeHandler, TaskQueue queue) {
        return ContextImpl.executeBlocking((ContextInternal)this, blockingCodeHandler, this.workerPool, queue);
    }

    @Override
    public <T> Future<T> executeBlocking(Callable<T> blockingCodeHandler, TaskQueue queue) {
        return ContextImpl.executeBlocking((ContextInternal)this, blockingCodeHandler, this.workerPool, queue);
    }

    static <T> Future<T> executeBlocking(ContextInternal context, Callable<T> blockingCodeHandler, WorkerPool workerPool, TaskQueue queue) {
        return ContextImpl.internalExecuteBlocking(context, promise -> {
            Object result;
            try {
                result = blockingCodeHandler.call();
            }
            catch (Throwable e) {
                promise.fail(e);
                return;
            }
            promise.complete(result);
        }, workerPool, queue);
    }

    static <T> Future<T> executeBlocking(ContextInternal context, Handler<Promise<T>> blockingCodeHandler, WorkerPool workerPool, TaskQueue queue) {
        return ContextImpl.internalExecuteBlocking(context, promise -> {
            try {
                blockingCodeHandler.handle((Promise)promise);
            }
            catch (Throwable e) {
                promise.tryFail(e);
            }
        }, workerPool, queue);
    }

    private static <T> Future<T> internalExecuteBlocking(ContextInternal context, Handler<Promise<T>> blockingCodeHandler, WorkerPool workerPool, TaskQueue queue) {
        PoolMetrics metrics = workerPool.metrics();
        Object queueMetric = metrics != null ? (Object)metrics.submitted() : null;
        PromiseInternal promise = context.promise();
        Future fut = promise.future();
        try {
            Runnable command = () -> {
                Object execMetric = null;
                if (metrics != null) {
                    execMetric = metrics.begin(queueMetric);
                }
                context.dispatch(promise, blockingCodeHandler);
                if (metrics != null) {
                    metrics.end(execMetric, fut.succeeded());
                }
            };
            ExecutorService exec = workerPool.executor();
            if (queue != null) {
                queue.execute(command, exec);
            } else {
                exec.execute(command);
            }
        }
        catch (RejectedExecutionException e) {
            if (metrics != null) {
                metrics.rejected(queueMetric);
            }
            throw e;
        }
        return fut;
    }

    @Override
    public VertxTracer tracer() {
        return this.owner.tracer();
    }

    @Override
    public ClassLoader classLoader() {
        return this.tccl;
    }

    @Override
    public WorkerPool workerPool() {
        return this.workerPool;
    }

    @Override
    public synchronized ConcurrentMap<Object, Object> contextData() {
        if (this.data == null) {
            this.data = new ConcurrentHashMap<Object, Object>();
        }
        return this.data;
    }

    @Override
    public void reportException(Throwable t) {
        Handler<Throwable> handler = this.exceptionHandler;
        if (handler == null) {
            handler = this.owner.exceptionHandler();
        }
        if (handler != null) {
            handler.handle(t);
        } else {
            log.error("Unhandled exception", t);
        }
    }

    @Override
    public Context exceptionHandler(Handler<Throwable> handler) {
        this.exceptionHandler = handler;
        return this;
    }

    @Override
    public Handler<Throwable> exceptionHandler() {
        return this.exceptionHandler;
    }

    protected void runOnContext(ContextInternal ctx, Handler<Void> action) {
        try {
            Executor exec = ctx.executor();
            exec.execute(() -> ctx.dispatch(action));
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
    }

    @Override
    public void execute(Runnable task) {
        this.execute(this, task);
    }

    @Override
    public final <T> void execute(T argument, Handler<T> task) {
        this.execute(this, argument, task);
    }

    protected void execute(ContextInternal ctx, Runnable task) {
        if (this.inThread()) {
            task.run();
        } else {
            this.executor.execute(task);
        }
    }

    protected <T> void execute(ContextInternal ctx, T argument, Handler<T> task) {
        if (this.inThread()) {
            task.handle(argument);
        } else {
            this.executor.execute(() -> task.handle(argument));
        }
    }

    @Override
    public <T> void emit(T argument, Handler<T> task) {
        this.emit(this, argument, task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> void emit(ContextInternal ctx, T argument, Handler<T> task) {
        if (this.inThread()) {
            ContextInternal prev = ctx.beginDispatch();
            try {
                task.handle(argument);
            }
            catch (Throwable t) {
                this.reportException(t);
            }
            finally {
                ctx.endDispatch(prev);
            }
        } else {
            this.executor.execute(() -> this.emit(ctx, argument, task));
        }
    }

    @Override
    public ContextInternal duplicate() {
        return new DuplicatedContext(this);
    }
}

