/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.gcp.auth;

import com.google.auth.oauth2.AccessToken;
import com.google.auth.oauth2.GoogleCredentials;
import java.io.IOException;
import java.io.UncheckedIOException;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.rest.HTTPHeaders;
import org.apache.iceberg.rest.HTTPRequest;
import org.apache.iceberg.rest.ImmutableHTTPRequest;
import org.apache.iceberg.rest.auth.AuthSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class GoogleAuthSession
implements AuthSession {
    private static final Logger LOG = LoggerFactory.getLogger(GoogleAuthSession.class);
    private final GoogleCredentials credentials;

    GoogleAuthSession(GoogleCredentials credentials) {
        Preconditions.checkArgument((credentials != null ? 1 : 0) != 0, (Object)"Invalid credentials: null");
        this.credentials = credentials;
    }

    public HTTPRequest authenticate(HTTPRequest request) {
        try {
            this.credentials.refreshIfExpired();
            AccessToken token = this.credentials.getAccessToken();
            if (token != null && token.getTokenValue() != null) {
                HTTPHeaders newHeaders = request.headers().putIfAbsent(HTTPHeaders.of((HTTPHeaders.HTTPHeader[])new HTTPHeaders.HTTPHeader[]{HTTPHeaders.HTTPHeader.of((String)"Authorization", (String)("Bearer " + token.getTokenValue()))}));
                return newHeaders.equals(request.headers()) ? request : ImmutableHTTPRequest.builder().from(request).headers(newHeaders).build();
            }
            throw new IllegalStateException("Failed to obtain Google access token. Cannot authenticate request.");
        }
        catch (IOException e) {
            LOG.error("IOException while trying to refresh Google access token", (Throwable)e);
            throw new UncheckedIOException("Failed to refresh Google access token", e);
        }
    }

    public void close() {
    }
}

