/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.opentelemetry.runtime.config.runtime;

import io.quarkus.opentelemetry.runtime.config.runtime.AttributeConfig;
import io.quarkus.opentelemetry.runtime.config.runtime.BatchLogRecordProcessorConfig;
import io.quarkus.opentelemetry.runtime.config.runtime.BatchSpanProcessorConfig;
import io.quarkus.opentelemetry.runtime.config.runtime.InstrumentRuntimeConfig;
import io.quarkus.opentelemetry.runtime.config.runtime.LogsRuntimeConfig;
import io.quarkus.opentelemetry.runtime.config.runtime.MetricsRuntimeConfig;
import io.quarkus.opentelemetry.runtime.config.runtime.OTelRuntimeConfig;
import io.quarkus.opentelemetry.runtime.config.runtime.SpanConfig;
import io.quarkus.opentelemetry.runtime.config.runtime.TracesRuntimeConfig;
import io.smallrye.config.ConfigMapping;
import io.smallrye.config.ConfigMappingContext;
import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class OTelRuntimeConfig$$CMImpl
implements OTelRuntimeConfig {
    private AttributeConfig attribute;
    private BatchLogRecordProcessorConfig blrp;
    private BatchSpanProcessorConfig bsp;
    private Optional experimentalResourceDisabledKeys;
    private Duration experimentalShutdownWaitTime;
    private InstrumentRuntimeConfig instrument;
    private LogsRuntimeConfig logs;
    private MetricsRuntimeConfig metric;
    private boolean mpCompatibility;
    private Optional resourceAttributes;
    private boolean sdkDisabled;
    private Optional serviceName;
    private SpanConfig span;
    private TracesRuntimeConfig traces;
    private static final Map<String, String> PROPERTIES = new HashMap<String, String>(49);
    private static final Set<String> SECRETS = Collections.emptySet();

    public OTelRuntimeConfig$$CMImpl() {
    }

    public OTelRuntimeConfig$$CMImpl(ConfigMappingContext mc) {
        mc.applyNamingStrategy(ConfigMapping.NamingStrategy.KEBAB_CASE);
        mc.applyBeanStyleGetters(Boolean.valueOf(false));
        try {
            this.attribute = (AttributeConfig)new ConfigMappingContext.ObjectCreator(mc, "attribute", true).group(AttributeConfig.class).get();
        }
        catch (RuntimeException runtimeException) {
            mc.reportProblem(runtimeException);
        }
        try {
            this.blrp = (BatchLogRecordProcessorConfig)new ConfigMappingContext.ObjectCreator(mc, "blrp", true).group(BatchLogRecordProcessorConfig.class).get();
        }
        catch (RuntimeException runtimeException) {
            mc.reportProblem(runtimeException);
        }
        try {
            this.bsp = (BatchSpanProcessorConfig)new ConfigMappingContext.ObjectCreator(mc, "bsp", true).group(BatchSpanProcessorConfig.class).get();
        }
        catch (RuntimeException runtimeException) {
            mc.reportProblem(runtimeException);
        }
        try {
            this.experimentalResourceDisabledKeys = ConfigMappingContext.ObjectCreator.optionalValues((ConfigMappingContext)mc, (boolean)false, (String)"experimental.resource.disabled-keys", String.class, null, List.class);
        }
        catch (RuntimeException runtimeException) {
            mc.reportProblem(runtimeException);
        }
        try {
            this.experimentalShutdownWaitTime = (Duration)ConfigMappingContext.ObjectCreator.value((ConfigMappingContext)mc, (boolean)false, (String)"experimental.shutdown-wait-time", Duration.class, null);
        }
        catch (RuntimeException runtimeException) {
            mc.reportProblem(runtimeException);
        }
        try {
            this.instrument = (InstrumentRuntimeConfig)new ConfigMappingContext.ObjectCreator(mc, "instrument", true).group(InstrumentRuntimeConfig.class).get();
        }
        catch (RuntimeException runtimeException) {
            mc.reportProblem(runtimeException);
        }
        try {
            this.logs = (LogsRuntimeConfig)new ConfigMappingContext.ObjectCreator(mc, "logs", true).group(LogsRuntimeConfig.class).get();
        }
        catch (RuntimeException runtimeException) {
            mc.reportProblem(runtimeException);
        }
        try {
            this.metric = (MetricsRuntimeConfig)new ConfigMappingContext.ObjectCreator(mc, "metric", true).group(MetricsRuntimeConfig.class).get();
        }
        catch (RuntimeException runtimeException) {
            mc.reportProblem(runtimeException);
        }
        try {
            this.mpCompatibility = (Boolean)ConfigMappingContext.ObjectCreator.value((ConfigMappingContext)mc, (boolean)false, (String)"mp.compatibility", Boolean.class, null);
        }
        catch (RuntimeException runtimeException) {
            mc.reportProblem(runtimeException);
        }
        try {
            this.resourceAttributes = ConfigMappingContext.ObjectCreator.optionalValues((ConfigMappingContext)mc, (boolean)false, (String)"resource.attributes", String.class, null, List.class);
        }
        catch (RuntimeException runtimeException) {
            mc.reportProblem(runtimeException);
        }
        try {
            this.sdkDisabled = (Boolean)ConfigMappingContext.ObjectCreator.value((ConfigMappingContext)mc, (boolean)false, (String)"sdk.disabled", Boolean.class, null);
        }
        catch (RuntimeException runtimeException) {
            mc.reportProblem(runtimeException);
        }
        try {
            this.serviceName = ConfigMappingContext.ObjectCreator.optionalValue((ConfigMappingContext)mc, (boolean)false, (String)"service.name", String.class, null);
        }
        catch (RuntimeException runtimeException) {
            mc.reportProblem(runtimeException);
        }
        try {
            this.span = (SpanConfig)new ConfigMappingContext.ObjectCreator(mc, "span", true).group(SpanConfig.class).get();
        }
        catch (RuntimeException runtimeException) {
            mc.reportProblem(runtimeException);
        }
        try {
            this.traces = (TracesRuntimeConfig)new ConfigMappingContext.ObjectCreator(mc, "traces", true).group(TracesRuntimeConfig.class).get();
        }
        catch (RuntimeException runtimeException) {
            mc.reportProblem(runtimeException);
        }
    }

    public AttributeConfig attribute() {
        return this.attribute;
    }

    public BatchLogRecordProcessorConfig blrp() {
        return this.blrp;
    }

    public BatchSpanProcessorConfig bsp() {
        return this.bsp;
    }

    public Optional experimentalResourceDisabledKeys() {
        return this.experimentalResourceDisabledKeys;
    }

    public Duration experimentalShutdownWaitTime() {
        return this.experimentalShutdownWaitTime;
    }

    public InstrumentRuntimeConfig instrument() {
        return this.instrument;
    }

    public LogsRuntimeConfig logs() {
        return this.logs;
    }

    public MetricsRuntimeConfig metric() {
        return this.metric;
    }

    public boolean mpCompatibility() {
        return this.mpCompatibility;
    }

    public Optional resourceAttributes() {
        return this.resourceAttributes;
    }

    public boolean sdkDisabled() {
        return this.sdkDisabled;
    }

    public Optional serviceName() {
        return this.serviceName;
    }

    public SpanConfig span() {
        return this.span;
    }

    public TracesRuntimeConfig traces() {
        return this.traces;
    }

    static {
        PROPERTIES.put("attribute.count.limit", "128");
        PROPERTIES.put("attribute.value.length.limit", null);
        PROPERTIES.put("blrp.export.timeout", "30s");
        PROPERTIES.put("blrp.max.export.batch.size", "512");
        PROPERTIES.put("blrp.max.queue.size", "2048");
        PROPERTIES.put("blrp.schedule.delay", "1s");
        PROPERTIES.put("bsp.export.timeout", "30s");
        PROPERTIES.put("bsp.max.export.batch.size", "512");
        PROPERTIES.put("bsp.max.queue.size", "2048");
        PROPERTIES.put("bsp.schedule.delay", "5s");
        PROPERTIES.put("experimental.resource.disabled-keys", null);
        PROPERTIES.put("experimental.resource.disabled-keys[*]", null);
        PROPERTIES.put("experimental.shutdown-wait-time", "2s");
        PROPERTIES.put("instrument.http-server-metrics", "true");
        PROPERTIES.put("instrument.jvm-metrics", "true");
        PROPERTIES.put("instrument.vertx-event-bus", "true");
        PROPERTIES.put("instrument.vertx-http", "true");
        PROPERTIES.put("instrument.vertx-redis-client", "true");
        PROPERTIES.put("instrument.vertx-sql-client", "true");
        PROPERTIES.put("logs.handler.enabled", "true");
        PROPERTIES.put("logs.level", "ALL");
        PROPERTIES.put("metric.export.interval", "60s");
        PROPERTIES.put("mp.compatibility", "false");
        PROPERTIES.put("resource.attributes", null);
        PROPERTIES.put("resource.attributes[*]", null);
        PROPERTIES.put("sdk.disabled", "false");
        PROPERTIES.put("service.name", "${quarkus.application.name:unset}");
        PROPERTIES.put("span.attribute.count.limit", "128");
        PROPERTIES.put("span.attribute.value.length.limit", null);
        PROPERTIES.put("span.event.count.limit", "128");
        PROPERTIES.put("span.link.count.limit", "128");
        PROPERTIES.put("traces.include-static-resources", "false");
        PROPERTIES.put("traces.sampler.arg", "1.0d");
        PROPERTIES.put("traces.suppress-application-uris", null);
        PROPERTIES.put("traces.suppress-application-uris[*]", null);
        PROPERTIES.put("traces.suppress-non-application-uris", "true");
    }

    public static Map<String, String> getProperties() {
        return PROPERTIES;
    }

    public static Set<String> getSecrets() {
        return SECRETS;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        OTelRuntimeConfig$$CMImpl oTelRuntimeConfig$$CMImpl = (OTelRuntimeConfig$$CMImpl)object;
        return Objects.equals(this.attribute(), oTelRuntimeConfig$$CMImpl.attribute()) && Objects.equals(this.blrp(), oTelRuntimeConfig$$CMImpl.blrp()) && Objects.equals(this.bsp(), oTelRuntimeConfig$$CMImpl.bsp()) && Objects.equals(this.experimentalResourceDisabledKeys(), oTelRuntimeConfig$$CMImpl.experimentalResourceDisabledKeys()) && Objects.equals(this.experimentalShutdownWaitTime(), oTelRuntimeConfig$$CMImpl.experimentalShutdownWaitTime()) && Objects.equals(this.instrument(), oTelRuntimeConfig$$CMImpl.instrument()) && Objects.equals(this.logs(), oTelRuntimeConfig$$CMImpl.logs()) && Objects.equals(this.metric(), oTelRuntimeConfig$$CMImpl.metric()) && this.mpCompatibility() == oTelRuntimeConfig$$CMImpl.mpCompatibility() && Objects.equals(this.resourceAttributes(), oTelRuntimeConfig$$CMImpl.resourceAttributes()) && this.sdkDisabled() == oTelRuntimeConfig$$CMImpl.sdkDisabled() && Objects.equals(this.serviceName(), oTelRuntimeConfig$$CMImpl.serviceName()) && Objects.equals(this.span(), oTelRuntimeConfig$$CMImpl.span()) && Objects.equals(this.traces(), oTelRuntimeConfig$$CMImpl.traces());
    }

    public int hashCode() {
        Object[] objectArray = new Object[]{this.attribute, this.blrp, this.bsp, this.experimentalResourceDisabledKeys, this.experimentalShutdownWaitTime, this.instrument, this.logs, this.metric, this.mpCompatibility, this.resourceAttributes, this.sdkDisabled, this.serviceName, this.span, this.traces};
        Object[] objectArray2 = objectArray;
        return Objects.hash(objectArray);
    }
}

