/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetSpecialEventPeriodCalendarReference is the corresponding interface of BACnetSpecialEventPeriodCalendarReference
type BACnetSpecialEventPeriodCalendarReference interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BACnetSpecialEventPeriod
	// GetCalendarReference returns CalendarReference (property field)
	GetCalendarReference() BACnetContextTagObjectIdentifier
	// IsBACnetSpecialEventPeriodCalendarReference is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetSpecialEventPeriodCalendarReference()
	// CreateBuilder creates a BACnetSpecialEventPeriodCalendarReferenceBuilder
	CreateBACnetSpecialEventPeriodCalendarReferenceBuilder() BACnetSpecialEventPeriodCalendarReferenceBuilder
}

// _BACnetSpecialEventPeriodCalendarReference is the data-structure of this message
type _BACnetSpecialEventPeriodCalendarReference struct {
	BACnetSpecialEventPeriodContract
	CalendarReference BACnetContextTagObjectIdentifier
}

var _ BACnetSpecialEventPeriodCalendarReference = (*_BACnetSpecialEventPeriodCalendarReference)(nil)
var _ BACnetSpecialEventPeriodRequirements = (*_BACnetSpecialEventPeriodCalendarReference)(nil)

// NewBACnetSpecialEventPeriodCalendarReference factory function for _BACnetSpecialEventPeriodCalendarReference
func NewBACnetSpecialEventPeriodCalendarReference(peekedTagHeader BACnetTagHeader, calendarReference BACnetContextTagObjectIdentifier) *_BACnetSpecialEventPeriodCalendarReference {
	if calendarReference == nil {
		panic("calendarReference of type BACnetContextTagObjectIdentifier for BACnetSpecialEventPeriodCalendarReference must not be nil")
	}
	_result := &_BACnetSpecialEventPeriodCalendarReference{
		BACnetSpecialEventPeriodContract: NewBACnetSpecialEventPeriod(peekedTagHeader),
		CalendarReference:                calendarReference,
	}
	_result.BACnetSpecialEventPeriodContract.(*_BACnetSpecialEventPeriod)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetSpecialEventPeriodCalendarReferenceBuilder is a builder for BACnetSpecialEventPeriodCalendarReference
type BACnetSpecialEventPeriodCalendarReferenceBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(calendarReference BACnetContextTagObjectIdentifier) BACnetSpecialEventPeriodCalendarReferenceBuilder
	// WithCalendarReference adds CalendarReference (property field)
	WithCalendarReference(BACnetContextTagObjectIdentifier) BACnetSpecialEventPeriodCalendarReferenceBuilder
	// WithCalendarReferenceBuilder adds CalendarReference (property field) which is build by the builder
	WithCalendarReferenceBuilder(func(BACnetContextTagObjectIdentifierBuilder) BACnetContextTagObjectIdentifierBuilder) BACnetSpecialEventPeriodCalendarReferenceBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BACnetSpecialEventPeriodBuilder
	// Build builds the BACnetSpecialEventPeriodCalendarReference or returns an error if something is wrong
	Build() (BACnetSpecialEventPeriodCalendarReference, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetSpecialEventPeriodCalendarReference
}

// NewBACnetSpecialEventPeriodCalendarReferenceBuilder() creates a BACnetSpecialEventPeriodCalendarReferenceBuilder
func NewBACnetSpecialEventPeriodCalendarReferenceBuilder() BACnetSpecialEventPeriodCalendarReferenceBuilder {
	return &_BACnetSpecialEventPeriodCalendarReferenceBuilder{_BACnetSpecialEventPeriodCalendarReference: new(_BACnetSpecialEventPeriodCalendarReference)}
}

type _BACnetSpecialEventPeriodCalendarReferenceBuilder struct {
	*_BACnetSpecialEventPeriodCalendarReference

	parentBuilder *_BACnetSpecialEventPeriodBuilder

	collectedErr []error
}

var _ (BACnetSpecialEventPeriodCalendarReferenceBuilder) = (*_BACnetSpecialEventPeriodCalendarReferenceBuilder)(nil)

func (b *_BACnetSpecialEventPeriodCalendarReferenceBuilder) setParent(contract BACnetSpecialEventPeriodContract) {
	b.BACnetSpecialEventPeriodContract = contract
	contract.(*_BACnetSpecialEventPeriod)._SubType = b._BACnetSpecialEventPeriodCalendarReference
}

func (b *_BACnetSpecialEventPeriodCalendarReferenceBuilder) WithMandatoryFields(calendarReference BACnetContextTagObjectIdentifier) BACnetSpecialEventPeriodCalendarReferenceBuilder {
	return b.WithCalendarReference(calendarReference)
}

func (b *_BACnetSpecialEventPeriodCalendarReferenceBuilder) WithCalendarReference(calendarReference BACnetContextTagObjectIdentifier) BACnetSpecialEventPeriodCalendarReferenceBuilder {
	b.CalendarReference = calendarReference
	return b
}

func (b *_BACnetSpecialEventPeriodCalendarReferenceBuilder) WithCalendarReferenceBuilder(builderSupplier func(BACnetContextTagObjectIdentifierBuilder) BACnetContextTagObjectIdentifierBuilder) BACnetSpecialEventPeriodCalendarReferenceBuilder {
	builder := builderSupplier(b.CalendarReference.CreateBACnetContextTagObjectIdentifierBuilder())
	var err error
	b.CalendarReference, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetContextTagObjectIdentifierBuilder failed"))
	}
	return b
}

func (b *_BACnetSpecialEventPeriodCalendarReferenceBuilder) Build() (BACnetSpecialEventPeriodCalendarReference, error) {
	if b.CalendarReference == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'calendarReference' not set"))
	}
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._BACnetSpecialEventPeriodCalendarReference.deepCopy(), nil
}

func (b *_BACnetSpecialEventPeriodCalendarReferenceBuilder) MustBuild() BACnetSpecialEventPeriodCalendarReference {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetSpecialEventPeriodCalendarReferenceBuilder) Done() BACnetSpecialEventPeriodBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBACnetSpecialEventPeriodBuilder().(*_BACnetSpecialEventPeriodBuilder)
	}
	return b.parentBuilder
}

func (b *_BACnetSpecialEventPeriodCalendarReferenceBuilder) buildForBACnetSpecialEventPeriod() (BACnetSpecialEventPeriod, error) {
	return b.Build()
}

func (b *_BACnetSpecialEventPeriodCalendarReferenceBuilder) DeepCopy() any {
	_copy := b.CreateBACnetSpecialEventPeriodCalendarReferenceBuilder().(*_BACnetSpecialEventPeriodCalendarReferenceBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateBACnetSpecialEventPeriodCalendarReferenceBuilder creates a BACnetSpecialEventPeriodCalendarReferenceBuilder
func (b *_BACnetSpecialEventPeriodCalendarReference) CreateBACnetSpecialEventPeriodCalendarReferenceBuilder() BACnetSpecialEventPeriodCalendarReferenceBuilder {
	if b == nil {
		return NewBACnetSpecialEventPeriodCalendarReferenceBuilder()
	}
	return &_BACnetSpecialEventPeriodCalendarReferenceBuilder{_BACnetSpecialEventPeriodCalendarReference: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetSpecialEventPeriodCalendarReference) GetParent() BACnetSpecialEventPeriodContract {
	return m.BACnetSpecialEventPeriodContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetSpecialEventPeriodCalendarReference) GetCalendarReference() BACnetContextTagObjectIdentifier {
	return m.CalendarReference
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetSpecialEventPeriodCalendarReference(structType any) BACnetSpecialEventPeriodCalendarReference {
	if casted, ok := structType.(BACnetSpecialEventPeriodCalendarReference); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetSpecialEventPeriodCalendarReference); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetSpecialEventPeriodCalendarReference) GetTypeName() string {
	return "BACnetSpecialEventPeriodCalendarReference"
}

func (m *_BACnetSpecialEventPeriodCalendarReference) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BACnetSpecialEventPeriodContract.(*_BACnetSpecialEventPeriod).getLengthInBits(ctx))

	// Simple field (calendarReference)
	lengthInBits += m.CalendarReference.GetLengthInBits(ctx)

	return lengthInBits
}

func (m *_BACnetSpecialEventPeriodCalendarReference) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BACnetSpecialEventPeriodCalendarReference) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BACnetSpecialEventPeriod) (__bACnetSpecialEventPeriodCalendarReference BACnetSpecialEventPeriodCalendarReference, err error) {
	m.BACnetSpecialEventPeriodContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetSpecialEventPeriodCalendarReference"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetSpecialEventPeriodCalendarReference")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	calendarReference, err := ReadSimpleField[BACnetContextTagObjectIdentifier](ctx, "calendarReference", ReadComplex[BACnetContextTagObjectIdentifier](BACnetContextTagParseWithBufferProducer[BACnetContextTagObjectIdentifier]((uint8)(uint8(1)), (BACnetDataType)(BACnetDataType_BACNET_OBJECT_IDENTIFIER)), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'calendarReference' field"))
	}
	m.CalendarReference = calendarReference

	if closeErr := readBuffer.CloseContext("BACnetSpecialEventPeriodCalendarReference"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetSpecialEventPeriodCalendarReference")
	}

	return m, nil
}

func (m *_BACnetSpecialEventPeriodCalendarReference) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetSpecialEventPeriodCalendarReference) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetSpecialEventPeriodCalendarReference"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetSpecialEventPeriodCalendarReference")
		}

		if err := WriteSimpleField[BACnetContextTagObjectIdentifier](ctx, "calendarReference", m.GetCalendarReference(), WriteComplex[BACnetContextTagObjectIdentifier](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'calendarReference' field")
		}

		if popErr := writeBuffer.PopContext("BACnetSpecialEventPeriodCalendarReference"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetSpecialEventPeriodCalendarReference")
		}
		return nil
	}
	return m.BACnetSpecialEventPeriodContract.(*_BACnetSpecialEventPeriod).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetSpecialEventPeriodCalendarReference) IsBACnetSpecialEventPeriodCalendarReference() {}

func (m *_BACnetSpecialEventPeriodCalendarReference) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetSpecialEventPeriodCalendarReference) deepCopy() *_BACnetSpecialEventPeriodCalendarReference {
	if m == nil {
		return nil
	}
	_BACnetSpecialEventPeriodCalendarReferenceCopy := &_BACnetSpecialEventPeriodCalendarReference{
		m.BACnetSpecialEventPeriodContract.(*_BACnetSpecialEventPeriod).deepCopy(),
		utils.DeepCopy[BACnetContextTagObjectIdentifier](m.CalendarReference),
	}
	_BACnetSpecialEventPeriodCalendarReferenceCopy.BACnetSpecialEventPeriodContract.(*_BACnetSpecialEventPeriod)._SubType = m
	return _BACnetSpecialEventPeriodCalendarReferenceCopy
}

func (m *_BACnetSpecialEventPeriodCalendarReference) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
