/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetClosingTag is the corresponding interface of BACnetClosingTag
type BACnetClosingTag interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	// GetHeader returns Header (property field)
	GetHeader() BACnetTagHeader
	// IsBACnetClosingTag is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetClosingTag()
	// CreateBuilder creates a BACnetClosingTagBuilder
	CreateBACnetClosingTagBuilder() BACnetClosingTagBuilder
}

// _BACnetClosingTag is the data-structure of this message
type _BACnetClosingTag struct {
	Header BACnetTagHeader

	// Arguments.
	TagNumberArgument uint8
}

var _ BACnetClosingTag = (*_BACnetClosingTag)(nil)

// NewBACnetClosingTag factory function for _BACnetClosingTag
func NewBACnetClosingTag(header BACnetTagHeader, tagNumberArgument uint8) *_BACnetClosingTag {
	if header == nil {
		panic("header of type BACnetTagHeader for BACnetClosingTag must not be nil")
	}
	return &_BACnetClosingTag{Header: header, TagNumberArgument: tagNumberArgument}
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetClosingTagBuilder is a builder for BACnetClosingTag
type BACnetClosingTagBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(header BACnetTagHeader) BACnetClosingTagBuilder
	// WithHeader adds Header (property field)
	WithHeader(BACnetTagHeader) BACnetClosingTagBuilder
	// WithHeaderBuilder adds Header (property field) which is build by the builder
	WithHeaderBuilder(func(BACnetTagHeaderBuilder) BACnetTagHeaderBuilder) BACnetClosingTagBuilder
	// WithArgTagNumberArgument sets a parser argument
	WithArgTagNumberArgument(uint8) BACnetClosingTagBuilder
	// Build builds the BACnetClosingTag or returns an error if something is wrong
	Build() (BACnetClosingTag, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetClosingTag
}

// NewBACnetClosingTagBuilder() creates a BACnetClosingTagBuilder
func NewBACnetClosingTagBuilder() BACnetClosingTagBuilder {
	return &_BACnetClosingTagBuilder{_BACnetClosingTag: new(_BACnetClosingTag)}
}

type _BACnetClosingTagBuilder struct {
	*_BACnetClosingTag

	collectedErr []error
}

var _ (BACnetClosingTagBuilder) = (*_BACnetClosingTagBuilder)(nil)

func (b *_BACnetClosingTagBuilder) WithMandatoryFields(header BACnetTagHeader) BACnetClosingTagBuilder {
	return b.WithHeader(header)
}

func (b *_BACnetClosingTagBuilder) WithHeader(header BACnetTagHeader) BACnetClosingTagBuilder {
	b.Header = header
	return b
}

func (b *_BACnetClosingTagBuilder) WithHeaderBuilder(builderSupplier func(BACnetTagHeaderBuilder) BACnetTagHeaderBuilder) BACnetClosingTagBuilder {
	builder := builderSupplier(b.Header.CreateBACnetTagHeaderBuilder())
	var err error
	b.Header, err = builder.Build()
	if err != nil {
		b.collectedErr = append(b.collectedErr, errors.Wrap(err, "BACnetTagHeaderBuilder failed"))
	}
	return b
}

func (b *_BACnetClosingTagBuilder) WithArgTagNumberArgument(tagNumberArgument uint8) BACnetClosingTagBuilder {
	b.TagNumberArgument = tagNumberArgument
	return b
}

func (b *_BACnetClosingTagBuilder) Build() (BACnetClosingTag, error) {
	if b.Header == nil {
		b.collectedErr = append(b.collectedErr, errors.New("mandatory field 'header' not set"))
	}
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._BACnetClosingTag.deepCopy(), nil
}

func (b *_BACnetClosingTagBuilder) MustBuild() BACnetClosingTag {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetClosingTagBuilder) DeepCopy() any {
	_copy := b.CreateBACnetClosingTagBuilder().(*_BACnetClosingTagBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateBACnetClosingTagBuilder creates a BACnetClosingTagBuilder
func (b *_BACnetClosingTag) CreateBACnetClosingTagBuilder() BACnetClosingTagBuilder {
	if b == nil {
		return NewBACnetClosingTagBuilder()
	}
	return &_BACnetClosingTagBuilder{_BACnetClosingTag: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetClosingTag) GetHeader() BACnetTagHeader {
	return m.Header
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetClosingTag(structType any) BACnetClosingTag {
	if casted, ok := structType.(BACnetClosingTag); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetClosingTag); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetClosingTag) GetTypeName() string {
	return "BACnetClosingTag"
}

func (m *_BACnetClosingTag) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(0)

	// Simple field (header)
	lengthInBits += m.Header.GetLengthInBits(ctx)

	return lengthInBits
}

func (m *_BACnetClosingTag) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func BACnetClosingTagParse(ctx context.Context, theBytes []byte, tagNumberArgument uint8) (BACnetClosingTag, error) {
	return BACnetClosingTagParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes), tagNumberArgument)
}

func BACnetClosingTagParseWithBufferProducer(tagNumberArgument uint8) func(ctx context.Context, readBuffer utils.ReadBuffer) (BACnetClosingTag, error) {
	return func(ctx context.Context, readBuffer utils.ReadBuffer) (BACnetClosingTag, error) {
		return BACnetClosingTagParseWithBuffer(ctx, readBuffer, tagNumberArgument)
	}
}

func BACnetClosingTagParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer, tagNumberArgument uint8) (BACnetClosingTag, error) {
	v, err := (&_BACnetClosingTag{TagNumberArgument: tagNumberArgument}).parse(ctx, readBuffer, tagNumberArgument)
	if err != nil {
		return nil, err
	}
	return v, nil
}

func (m *_BACnetClosingTag) parse(ctx context.Context, readBuffer utils.ReadBuffer, tagNumberArgument uint8) (__bACnetClosingTag BACnetClosingTag, err error) {
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetClosingTag"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetClosingTag")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	header, err := ReadSimpleField[BACnetTagHeader](ctx, "header", ReadComplex[BACnetTagHeader](BACnetTagHeaderParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'header' field"))
	}
	m.Header = header

	// Validation
	if !(bool((header.GetActualTagNumber()) == (tagNumberArgument))) {
		return nil, errors.WithStack(utils.ParseAssertError{Message: "tagnumber doesn't match"})
	}

	// Validation
	if !(bool((header.GetTagClass()) == (TagClass_CONTEXT_SPECIFIC_TAGS))) {
		return nil, errors.WithStack(utils.ParseValidationError{Message: "should be a context tag"})
	}

	// Validation
	if !(bool((header.GetLengthValueType()) == (7))) {
		return nil, errors.WithStack(utils.ParseValidationError{Message: "closing tag should have a value of 7"})
	}

	if closeErr := readBuffer.CloseContext("BACnetClosingTag"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetClosingTag")
	}

	return m, nil
}

func (m *_BACnetClosingTag) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetClosingTag) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pushErr := writeBuffer.PushContext("BACnetClosingTag"); pushErr != nil {
		return errors.Wrap(pushErr, "Error pushing for BACnetClosingTag")
	}

	if err := WriteSimpleField[BACnetTagHeader](ctx, "header", m.GetHeader(), WriteComplex[BACnetTagHeader](writeBuffer)); err != nil {
		return errors.Wrap(err, "Error serializing 'header' field")
	}

	if popErr := writeBuffer.PopContext("BACnetClosingTag"); popErr != nil {
		return errors.Wrap(popErr, "Error popping for BACnetClosingTag")
	}
	return nil
}

////
// Arguments Getter

func (m *_BACnetClosingTag) GetTagNumberArgument() uint8 {
	return m.TagNumberArgument
}

//
////

func (m *_BACnetClosingTag) IsBACnetClosingTag() {}

func (m *_BACnetClosingTag) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetClosingTag) deepCopy() *_BACnetClosingTag {
	if m == nil {
		return nil
	}
	_BACnetClosingTagCopy := &_BACnetClosingTag{
		utils.DeepCopy[BACnetTagHeader](m.Header),
		m.TagNumberArgument,
	}
	return _BACnetClosingTagCopy
}

func (m *_BACnetClosingTag) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
