/*
 * Decompiled with CFR 0.152.
 */
package tachyon.util.io;

import com.google.common.base.CharMatcher;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import org.apache.commons.io.FilenameUtils;
import tachyon.exception.InvalidPathException;

public final class PathUtils {
    public static String cleanPath(String path) throws InvalidPathException {
        PathUtils.validatePath(path);
        return FilenameUtils.separatorsToUnix((String)FilenameUtils.normalizeNoEndSeparator((String)path));
    }

    public static String concatPath(Object base, Object ... paths) throws IllegalArgumentException {
        Preconditions.checkArgument((base != null ? 1 : 0) != 0, (Object)"Failed to concatPath: base is null");
        Preconditions.checkArgument((paths != null ? 1 : 0) != 0, (Object)"Failed to concatPath: a null set of paths");
        ArrayList<String> trimmedPathList = new ArrayList<String>();
        String trimmedBase = CharMatcher.is((char)"/".charAt(0)).trimTrailingFrom((CharSequence)base.toString().trim());
        trimmedPathList.add(trimmedBase);
        for (Object path : paths) {
            String trimmedPath;
            if (path == null || (trimmedPath = CharMatcher.is((char)"/".charAt(0)).trimFrom((CharSequence)path.toString().trim())).isEmpty()) continue;
            trimmedPathList.add(trimmedPath);
        }
        if (trimmedPathList.size() == 1 && trimmedBase.isEmpty()) {
            return "/";
        }
        return Joiner.on((String)"/").join(trimmedPathList);
    }

    public static String getParent(String path) throws InvalidPathException {
        String cleanedPath = PathUtils.cleanPath(path);
        String name = FilenameUtils.getName((String)cleanedPath);
        String parent = cleanedPath.substring(0, cleanedPath.length() - name.length() - 1);
        if (parent.isEmpty()) {
            return "/";
        }
        return parent;
    }

    public static String[] getPathComponents(String path) throws InvalidPathException {
        if (PathUtils.isRoot(path = PathUtils.cleanPath(path))) {
            String[] ret = new String[]{""};
            return ret;
        }
        return path.split("/");
    }

    public static boolean hasPrefix(String path, String prefix) throws InvalidPathException {
        String[] prefixComponents;
        String[] pathComponents = PathUtils.getPathComponents(path);
        if (pathComponents.length < (prefixComponents = PathUtils.getPathComponents(prefix)).length) {
            return false;
        }
        for (int i = 0; i < prefixComponents.length; ++i) {
            if (pathComponents[i].equals(prefixComponents[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean isRoot(String path) throws InvalidPathException {
        return "/".equals(PathUtils.cleanPath(path));
    }

    public static void validatePath(String path) throws InvalidPathException {
        if (path == null || path.isEmpty() || !path.startsWith("/") || path.contains(" ")) {
            throw new InvalidPathException("Path " + path + " is invalid.");
        }
    }

    public static final String temporaryFileName(long fileId, long nonce, String path) {
        return path + ".tachyon." + fileId + "." + String.format("0x%16X", nonce) + ".tmp";
    }

    public static final String uniqPath() {
        StackTraceElement caller = new Throwable().getStackTrace()[1];
        long time = System.nanoTime();
        return "/" + caller.getClassName() + "/" + caller.getMethodName() + "/" + time;
    }

    private PathUtils() {
    }
}

