/*
 * Decompiled with CFR 0.152.
 */
package tachyon.security.login;

import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import tachyon.security.User;

public final class AppLoginModule
implements LoginModule {
    private Subject mSubject;
    private User mUser;

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        this.mSubject = subject;
    }

    @Override
    public boolean login() throws LoginException {
        String userName = System.getProperty("tachyon.security.login.username", "");
        if (!userName.isEmpty()) {
            this.mUser = new User(userName);
            return true;
        }
        return false;
    }

    @Override
    public boolean abort() throws LoginException {
        this.logout();
        this.mUser = null;
        return true;
    }

    @Override
    public boolean commit() throws LoginException {
        if (!this.mSubject.getPrincipals(User.class).isEmpty()) {
            return true;
        }
        if (this.mUser != null) {
            this.mSubject.getPrincipals().add(this.mUser);
            return true;
        }
        throw new LoginException("Cannot find a user");
    }

    @Override
    public boolean logout() throws LoginException {
        if (this.mSubject.isReadOnly()) {
            throw new LoginException("logout Failed: Subject is Readonly.");
        }
        if (this.mUser != null) {
            this.mSubject.getPrincipals().remove(this.mUser);
        }
        return true;
    }
}

