/*
 * Decompiled with CFR 0.152.
 */
package tachyon.resource;

import com.google.common.base.Preconditions;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;

public abstract class ResourcePool<T> {
    protected final Object mCapacityLock;
    protected final int mMaxCapacity;
    protected final BlockingQueue<T> mResources;
    protected int mCurrentCapacity;

    public ResourcePool(int maxCapacity) {
        this(maxCapacity, new LinkedBlockingQueue(maxCapacity));
    }

    protected ResourcePool(int maxCapacity, BlockingQueue<T> resources) {
        Preconditions.checkArgument((maxCapacity > 0 ? 1 : 0) != 0, (Object)"Capacity must be non-negative");
        this.mCapacityLock = new Object();
        this.mMaxCapacity = maxCapacity;
        this.mCurrentCapacity = 0;
        this.mResources = resources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T acquire() {
        Object object = this.mCapacityLock;
        synchronized (object) {
            if (this.mResources.isEmpty() && this.mCurrentCapacity < this.mMaxCapacity) {
                T newResource = this.createNewResource();
                ++this.mCurrentCapacity;
                return newResource;
            }
        }
        try {
            return this.mResources.take();
        }
        catch (InterruptedException ie) {
            throw new RuntimeException(ie);
        }
    }

    public abstract void close();

    public void release(T resource) {
        this.mResources.add(resource);
    }

    protected abstract T createNewResource();
}

