/*
 * Decompiled with CFR 0.152.
 */
package tachyon.client;

import com.google.common.base.Preconditions;
import java.net.InetSocketAddress;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import tachyon.client.block.BlockStoreContext;
import tachyon.client.file.FileSystemContext;
import tachyon.conf.TachyonConf;
import tachyon.util.ThreadFactoryUtils;
import tachyon.worker.ClientMetrics;

public final class ClientContext {
    private static final String ERR_NOT_INITIALIZED = "Client Context not initialized.";
    private static ExecutorService sExecutorService;
    private static TachyonConf sTachyonConf;
    private static InetSocketAddress sMasterAddress;
    private static ClientMetrics sClientMetrics;
    private static Random sRandom;
    private static boolean sInitialized;

    public static synchronized void reset() {
        if (sInitialized) {
            return;
        }
        ClientContext.reset(new TachyonConf());
    }

    public static synchronized void reset(TachyonConf conf) {
        sTachyonConf = conf;
        String masterHostname = (String)Preconditions.checkNotNull((Object)sTachyonConf.get("tachyon.master.hostname"));
        int masterPort = sTachyonConf.getInt("tachyon.master.port");
        sMasterAddress = new InetSocketAddress(masterHostname, masterPort);
        sClientMetrics = new ClientMetrics();
        sRandom = new Random();
        if (sExecutorService != null) {
            sExecutorService.shutdown();
        }
        sExecutorService = Executors.newFixedThreadPool(sTachyonConf.getInt("tachyon.user.block.worker.client.threads"), ThreadFactoryUtils.build("block-worker-heartbeat-%d", true));
        sInitialized = true;
        BlockStoreContext.INSTANCE.reset();
        FileSystemContext.INSTANCE.reset();
    }

    public static synchronized TachyonConf getConf() {
        ClientContext.checkContextInitialized();
        return sTachyonConf;
    }

    public static synchronized ClientMetrics getClientMetrics() {
        ClientContext.checkContextInitialized();
        return sClientMetrics;
    }

    public static synchronized InetSocketAddress getMasterAddress() {
        ClientContext.checkContextInitialized();
        return sMasterAddress;
    }

    public static synchronized long getRandomNonNegativeLong() {
        ClientContext.checkContextInitialized();
        return Math.abs(sRandom.nextLong());
    }

    public static synchronized ExecutorService getExecutorService() {
        ClientContext.checkContextInitialized();
        return sExecutorService;
    }

    private static void checkContextInitialized() {
        Preconditions.checkState((boolean)sInitialized, (Object)ERR_NOT_INITIALIZED);
    }

    private ClientContext() {
    }

    static {
        sInitialized = false;
        ClientContext.reset();
    }
}

