/*
 * Decompiled with CFR 0.152.
 */
package tachyon;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import java.io.IOException;
import java.net.InetSocketAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tachyon.ClientBase;
import tachyon.Constants;
import tachyon.LeaderInquireClient;
import tachyon.conf.TachyonConf;
import tachyon.util.network.NetworkAddressUtils;

public abstract class MasterClientBase
extends ClientBase {
    private static final Logger LOG = LoggerFactory.getLogger((String)Constants.LOGGER_TYPE);
    protected final boolean mUseZookeeper;

    public MasterClientBase(InetSocketAddress masterAddress, TachyonConf tachyonConf) {
        super(masterAddress, tachyonConf, "master");
        this.mUseZookeeper = this.mTachyonConf.getBoolean("tachyon.zookeeper.enabled");
    }

    @Override
    protected synchronized InetSocketAddress getAddress() {
        if (!this.mUseZookeeper) {
            return super.getAddress();
        }
        Preconditions.checkState((boolean)this.mTachyonConf.containsKey("tachyon.zookeeper.address"));
        Preconditions.checkState((boolean)this.mTachyonConf.containsKey("tachyon.zookeeper.leader.path"));
        LeaderInquireClient leaderInquireClient = LeaderInquireClient.getClient(this.mTachyonConf.get("tachyon.zookeeper.address"), this.mTachyonConf.get("tachyon.zookeeper.leader.path"));
        try {
            String temp = leaderInquireClient.getMasterAddress();
            return NetworkAddressUtils.parseInetSocketAddress(temp);
        }
        catch (IOException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw Throwables.propagate((Throwable)e);
        }
    }
}

