/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.newplan;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pig.Expression;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.newplan.Operator;
import org.apache.pig.newplan.logical.expression.AddExpression;
import org.apache.pig.newplan.logical.expression.AndExpression;
import org.apache.pig.newplan.logical.expression.BinaryExpression;
import org.apache.pig.newplan.logical.expression.CastExpression;
import org.apache.pig.newplan.logical.expression.ConstantExpression;
import org.apache.pig.newplan.logical.expression.DivideExpression;
import org.apache.pig.newplan.logical.expression.EqualExpression;
import org.apache.pig.newplan.logical.expression.GreaterThanEqualExpression;
import org.apache.pig.newplan.logical.expression.GreaterThanExpression;
import org.apache.pig.newplan.logical.expression.IsNullExpression;
import org.apache.pig.newplan.logical.expression.LessThanEqualExpression;
import org.apache.pig.newplan.logical.expression.LessThanExpression;
import org.apache.pig.newplan.logical.expression.LogicalExpression;
import org.apache.pig.newplan.logical.expression.LogicalExpressionPlan;
import org.apache.pig.newplan.logical.expression.ModExpression;
import org.apache.pig.newplan.logical.expression.MultiplyExpression;
import org.apache.pig.newplan.logical.expression.NotEqualExpression;
import org.apache.pig.newplan.logical.expression.NotExpression;
import org.apache.pig.newplan.logical.expression.OrExpression;
import org.apache.pig.newplan.logical.expression.ProjectExpression;
import org.apache.pig.newplan.logical.expression.RegexExpression;
import org.apache.pig.newplan.logical.expression.SubtractExpression;
import org.apache.pig.newplan.logical.expression.UnaryExpression;

public abstract class FilterExtractor {
    protected final Log LOG = LogFactory.getLog(this.getClass());
    protected LogicalExpressionPlan originalPlan;
    protected LogicalExpressionPlan filteredPlan;
    protected LogicalExpressionPlan pushdownExprPlan;
    protected LogicalExpression filterExpr = null;
    protected Expression pushdownExpr = null;

    public FilterExtractor(LogicalExpressionPlan plan) {
        this.originalPlan = plan;
        this.filteredPlan = new LogicalExpressionPlan();
        this.pushdownExprPlan = new LogicalExpressionPlan();
    }

    public void visit() throws FrontendException {
        LogicalExpression leaf = (LogicalExpression)this.originalPlan.getSources().get(0);
        KeyState finale = null;
        if (leaf instanceof BinaryExpression) {
            finale = this.checkPushDown((BinaryExpression)leaf);
        } else if (leaf instanceof UnaryExpression) {
            finale = this.checkPushDown((UnaryExpression)leaf);
        }
        if (finale != null) {
            this.filterExpr = finale.filterExpr;
            this.pushdownExpr = this.getExpression(finale.pushdownExpr);
        }
    }

    public LogicalExpressionPlan getFilteredPlan() {
        return this.filteredPlan;
    }

    public boolean canPushDown() {
        return this.pushdownExpr != null;
    }

    public boolean isFilterRemovable() {
        return this.filterExpr == null;
    }

    public Expression getPushDownExpression() {
        return this.pushdownExpr;
    }

    protected KeyState checkPushDown(LogicalExpression op) throws FrontendException {
        if (op instanceof ProjectExpression) {
            return this.checkPushDown((ProjectExpression)op);
        }
        if (op instanceof BinaryExpression) {
            return this.checkPushDown((BinaryExpression)op);
        }
        if (op instanceof ConstantExpression) {
            KeyState state = new KeyState();
            state.pushdownExpr = op;
            state.filterExpr = null;
            return state;
        }
        if (op instanceof UnaryExpression) {
            return this.checkPushDown((UnaryExpression)op);
        }
        KeyState state = new KeyState();
        state.pushdownExpr = null;
        state.filterExpr = this.addToFilterPlan(op);
        return state;
    }

    protected LogicalExpression addToFilterPlan(LogicalExpression op) throws FrontendException {
        LogicalExpression newOp = op.deepCopy(this.filteredPlan);
        return newOp;
    }

    private LogicalExpression andLogicalExpressions(LogicalExpressionPlan plan, LogicalExpression a, LogicalExpression b) throws FrontendException {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        if (!plan.ops.contains(a)) {
            a = a.deepCopy(plan);
        }
        if (!plan.ops.contains(b)) {
            b = b.deepCopy(plan);
        }
        AndExpression andOp = new AndExpression(plan, a, b);
        return andOp;
    }

    private LogicalExpression orLogicalExpressions(LogicalExpressionPlan plan, LogicalExpression a, LogicalExpression b) throws FrontendException {
        if (a == null || b == null) {
            return null;
        }
        if (!plan.ops.contains(a)) {
            a = a.deepCopy(plan);
        }
        if (!plan.ops.contains(b)) {
            b = b.deepCopy(plan);
        }
        OrExpression orOp = new OrExpression(plan, a, b);
        return orOp;
    }

    protected KeyState checkPushDown(BinaryExpression binExpr) throws FrontendException {
        KeyState state = new KeyState();
        if (!this.isSupportedOpType(binExpr)) {
            state.filterExpr = this.addToFilterPlan(binExpr);
            state.pushdownExpr = null;
            return state;
        }
        KeyState leftState = this.checkPushDown(binExpr.getLhs());
        KeyState rightState = this.checkPushDown(binExpr.getRhs());
        if (binExpr instanceof AndExpression) {
            state.pushdownExpr = this.andLogicalExpressions(this.pushdownExprPlan, leftState.pushdownExpr, rightState.pushdownExpr);
            state.filterExpr = this.andLogicalExpressions(this.filteredPlan, leftState.filterExpr, rightState.filterExpr);
        } else if (binExpr instanceof OrExpression) {
            state.pushdownExpr = this.orLogicalExpressions(this.pushdownExprPlan, leftState.pushdownExpr, rightState.pushdownExpr);
            if (state.pushdownExpr == null) {
                this.removeFromFilteredPlan(leftState.filterExpr);
                this.removeFromFilteredPlan(rightState.filterExpr);
                state.filterExpr = this.addToFilterPlan(binExpr);
            } else {
                LogicalExpression f1 = this.orLogicalExpressions(this.filteredPlan, leftState.pushdownExpr, rightState.filterExpr);
                LogicalExpression f2 = this.orLogicalExpressions(this.filteredPlan, leftState.filterExpr, rightState.pushdownExpr);
                LogicalExpression f3 = this.orLogicalExpressions(this.filteredPlan, leftState.filterExpr, rightState.filterExpr);
                state.filterExpr = this.andLogicalExpressions(this.filteredPlan, f1, this.andLogicalExpressions(this.filteredPlan, f2, f3));
            }
        } else if (leftState.filterExpr == null && rightState.filterExpr == null) {
            state.pushdownExpr = binExpr;
            state.filterExpr = null;
        } else {
            state.pushdownExpr = null;
            this.removeFromFilteredPlan(leftState.filterExpr);
            this.removeFromFilteredPlan(rightState.filterExpr);
            state.filterExpr = this.addToFilterPlan(binExpr);
        }
        return state;
    }

    protected KeyState checkPushDown(UnaryExpression unaryExpr) throws FrontendException {
        KeyState state = new KeyState();
        if (this.isSupportedOpType(unaryExpr)) {
            if (unaryExpr instanceof CastExpression) {
                return this.checkPushDown(unaryExpr.getExpression());
            }
            if (unaryExpr instanceof IsNullExpression || unaryExpr instanceof NotExpression) {
                KeyState childState = this.checkPushDown(unaryExpr.getExpression());
                if (childState.filterExpr == null) {
                    state.pushdownExpr = unaryExpr;
                    state.filterExpr = null;
                } else {
                    this.removeFromFilteredPlan(childState.filterExpr);
                    state.filterExpr = this.addToFilterPlan(unaryExpr);
                    state.pushdownExpr = null;
                }
            } else {
                state.filterExpr = this.addToFilterPlan(unaryExpr);
                state.pushdownExpr = null;
            }
        } else {
            state.filterExpr = this.addToFilterPlan(unaryExpr);
            state.pushdownExpr = null;
        }
        return state;
    }

    protected abstract KeyState checkPushDown(ProjectExpression var1) throws FrontendException;

    protected abstract boolean isSupportedOpType(BinaryExpression var1);

    protected abstract boolean isSupportedOpType(UnaryExpression var1);

    private void removeFromFilteredPlan(Operator op) throws FrontendException {
        List<Operator> succs = this.filteredPlan.getSuccessors(op);
        if (succs == null) {
            this.filteredPlan.remove(op);
            return;
        }
        Operator[] children = new Operator[succs.size()];
        for (int i = 0; i < succs.size(); ++i) {
            children[i] = succs.get(i);
        }
        for (Operator succ : children) {
            this.filteredPlan.disconnect(op, succ);
            this.removeFromFilteredPlan(succ);
        }
        this.filteredPlan.remove(op);
    }

    public Expression getExpression(LogicalExpression op) throws FrontendException {
        if (op == null) {
            return null;
        }
        if (op instanceof ConstantExpression) {
            ConstantExpression constExpr = (ConstantExpression)op;
            return new Expression.Const(constExpr.getValue());
        }
        if (op instanceof ProjectExpression) {
            ProjectExpression projExpr = (ProjectExpression)op;
            String fieldName = projExpr.getFieldSchema().alias;
            return new Expression.Column(fieldName);
        }
        if (op instanceof BinaryExpression) {
            BinaryExpression binOp = (BinaryExpression)op;
            if (binOp instanceof AddExpression) {
                return this.getExpression(binOp, Expression.OpType.OP_PLUS);
            }
            if (binOp instanceof SubtractExpression) {
                return this.getExpression(binOp, Expression.OpType.OP_MINUS);
            }
            if (binOp instanceof MultiplyExpression) {
                return this.getExpression(binOp, Expression.OpType.OP_TIMES);
            }
            if (binOp instanceof DivideExpression) {
                return this.getExpression(binOp, Expression.OpType.OP_DIV);
            }
            if (binOp instanceof ModExpression) {
                return this.getExpression(binOp, Expression.OpType.OP_MOD);
            }
            if (binOp instanceof AndExpression) {
                return this.getExpression(binOp, Expression.OpType.OP_AND);
            }
            if (binOp instanceof OrExpression) {
                return this.getExpression(binOp, Expression.OpType.OP_OR);
            }
            if (binOp instanceof EqualExpression) {
                return this.getExpression(binOp, Expression.OpType.OP_EQ);
            }
            if (binOp instanceof NotEqualExpression) {
                return this.getExpression(binOp, Expression.OpType.OP_NE);
            }
            if (binOp instanceof GreaterThanExpression) {
                return this.getExpression(binOp, Expression.OpType.OP_GT);
            }
            if (binOp instanceof GreaterThanEqualExpression) {
                return this.getExpression(binOp, Expression.OpType.OP_GE);
            }
            if (binOp instanceof LessThanExpression) {
                return this.getExpression(binOp, Expression.OpType.OP_LT);
            }
            if (binOp instanceof LessThanEqualExpression) {
                return this.getExpression(binOp, Expression.OpType.OP_LE);
            }
            if (binOp instanceof RegexExpression) {
                return this.getExpression(binOp, Expression.OpType.OP_MATCH);
            }
            this.LOG.error((Object)("Unsupported conversion of BinaryExpression to Expression: " + op.getName()));
            throw new FrontendException("Unsupported conversion of BinaryExpression to Expression: " + op.getName());
        }
        if (op instanceof UnaryExpression) {
            UnaryExpression unaryOp = (UnaryExpression)op;
            if (unaryOp instanceof IsNullExpression) {
                return this.getExpression(unaryOp, Expression.OpType.OP_NULL);
            }
            if (unaryOp instanceof NotExpression) {
                return this.getExpression(unaryOp, Expression.OpType.OP_NOT);
            }
            if (unaryOp instanceof CastExpression) {
                return this.getExpression(unaryOp.getExpression());
            }
            this.LOG.error((Object)("Unsupported conversion of UnaryExpression to Expression: " + op.getName()));
            throw new FrontendException("Unsupported conversion of UnaryExpression to Expression: " + op.getName());
        }
        this.LOG.error((Object)("Unsupported conversion of LogicalExpression to Expression: " + op.getName()));
        throw new FrontendException("Unsupported conversion of LogicalExpression to Expression: " + op.getName());
    }

    protected Expression getExpression(BinaryExpression binOp, Expression.OpType opType) throws FrontendException {
        return new Expression.BinaryExpression(this.getExpression(binOp.getLhs()), this.getExpression(binOp.getRhs()), opType);
    }

    protected Expression getExpression(UnaryExpression unaryOp, Expression.OpType opType) throws FrontendException {
        return new Expression.UnaryExpression(this.getExpression(unaryOp.getExpression()), opType);
    }

    protected class KeyState {
        LogicalExpression pushdownExpr;
        LogicalExpression filterExpr;

        protected KeyState() {
        }
    }
}

