/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.common;

import com.google.protobuf.ByteString;
import java.nio.ByteBuffer;
import org.apache.tez.runtime.api.events.CompositeDataMovementEvent;
import org.apache.tez.runtime.api.events.DataMovementEvent;
import org.apache.tez.runtime.api.events.EventProtos;
import org.apache.tez.runtime.api.events.InputDataInformationEvent;
import org.apache.tez.runtime.api.events.InputInitializerEvent;
import org.apache.tez.runtime.api.events.VertexManagerEvent;

public class ProtoConverters {
    public static EventProtos.DataMovementEventProto convertDataMovementEventToProto(DataMovementEvent event) {
        EventProtos.DataMovementEventProto.Builder builder = EventProtos.DataMovementEventProto.newBuilder();
        builder.setSourceIndex(event.getSourceIndex()).setTargetIndex(event.getTargetIndex()).setVersion(event.getVersion());
        if (event.getUserPayload() != null) {
            builder.setUserPayload(ByteString.copyFrom((ByteBuffer)event.getUserPayload()));
        }
        return builder.build();
    }

    public static DataMovementEvent convertDataMovementEventFromProto(EventProtos.DataMovementEventProto proto) {
        return DataMovementEvent.create((int)proto.getSourceIndex(), (int)proto.getTargetIndex(), (int)proto.getVersion(), proto.getUserPayload() != null ? proto.getUserPayload().asReadOnlyByteBuffer() : null);
    }

    public static EventProtos.CompositeEventProto convertCompositeDataMovementEventToProto(CompositeDataMovementEvent event) {
        EventProtos.CompositeEventProto.Builder builder = EventProtos.CompositeEventProto.newBuilder();
        builder.setStartIndex(event.getSourceIndexStart());
        builder.setCount(event.getCount());
        if (event.getUserPayload() != null) {
            builder.setUserPayload(ByteString.copyFrom((ByteBuffer)event.getUserPayload()));
        }
        return builder.build();
    }

    public static CompositeDataMovementEvent convertCompositeDataMovementEventFromProto(EventProtos.CompositeEventProto proto) {
        return CompositeDataMovementEvent.create((int)proto.getStartIndex(), (int)proto.getCount(), proto.hasUserPayload() ? proto.getUserPayload().asReadOnlyByteBuffer() : null);
    }

    public static EventProtos.VertexManagerEventProto convertVertexManagerEventToProto(VertexManagerEvent event) {
        EventProtos.VertexManagerEventProto.Builder vmBuilder = EventProtos.VertexManagerEventProto.newBuilder();
        vmBuilder.setTargetVertexName(event.getTargetVertexName());
        if (event.getUserPayload() != null) {
            vmBuilder.setUserPayload(ByteString.copyFrom((ByteBuffer)event.getUserPayload()));
        }
        return vmBuilder.build();
    }

    public static VertexManagerEvent convertVertexManagerEventFromProto(EventProtos.VertexManagerEventProto vmProto) {
        return VertexManagerEvent.create((String)vmProto.getTargetVertexName(), vmProto.hasUserPayload() ? vmProto.getUserPayload().asReadOnlyByteBuffer() : null);
    }

    public static EventProtos.RootInputDataInformationEventProto convertRootInputDataInformationEventToProto(InputDataInformationEvent event) {
        EventProtos.RootInputDataInformationEventProto.Builder builder = EventProtos.RootInputDataInformationEventProto.newBuilder();
        builder.setSourceIndex(event.getSourceIndex());
        builder.setTargetIndex(event.getTargetIndex());
        if (event.getUserPayload() != null) {
            builder.setUserPayload(ByteString.copyFrom((ByteBuffer)event.getUserPayload()));
        }
        return builder.build();
    }

    public static InputDataInformationEvent convertRootInputDataInformationEventFromProto(EventProtos.RootInputDataInformationEventProto proto) {
        InputDataInformationEvent diEvent = InputDataInformationEvent.createWithSerializedPayload((int)proto.getSourceIndex(), proto.hasUserPayload() ? proto.getUserPayload().asReadOnlyByteBuffer() : null);
        diEvent.setTargetIndex(proto.getTargetIndex());
        return diEvent;
    }

    public static EventProtos.RootInputInitializerEventProto convertRootInputInitializerEventToProto(InputInitializerEvent event) {
        EventProtos.RootInputInitializerEventProto.Builder builder = EventProtos.RootInputInitializerEventProto.newBuilder();
        builder.setTargetVertexName(event.getTargetVertexName());
        builder.setTargetInputName(event.getTargetInputName());
        if (event.getUserPayload() != null) {
            builder.setUserPayload(ByteString.copyFrom((ByteBuffer)event.getUserPayload()));
        }
        return builder.build();
    }

    public static InputInitializerEvent convertRootInputInitializerEventFromProto(EventProtos.RootInputInitializerEventProto proto) {
        InputInitializerEvent event = InputInitializerEvent.create((String)proto.getTargetVertexName(), (String)proto.getTargetInputName(), proto.hasUserPayload() ? proto.getUserPayload().asReadOnlyByteBuffer() : null);
        return event;
    }
}

