/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.util.shell.commands;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.util.shell.Shell;
import org.apache.accumulo.core.util.shell.commands.OptUtil;
import org.apache.accumulo.core.util.shell.commands.TableOperation;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.hadoop.io.Text;

public class CompactCommand
extends TableOperation {
    private Option noFlushOption;
    private Option waitOpt;
    private Option profileOpt;
    private Option cancelOpt;
    private boolean flush;
    private Text startRow;
    private Text endRow;
    private List<IteratorSetting> iterators;
    boolean override = false;
    private boolean wait;
    private boolean cancel = false;

    @Override
    public String description() {
        return "sets all tablets for a table to major compact as soon as possible (based on current time)";
    }

    @Override
    protected void doTableOp(Shell shellState, String tableName) throws AccumuloException, AccumuloSecurityException {
        if (this.cancel) {
            try {
                shellState.getConnector().tableOperations().cancelCompaction(tableName);
                Shell.log.info((Object)("Compaction canceled for table " + tableName));
            }
            catch (TableNotFoundException e) {
                throw new AccumuloException(e);
            }
        }
        try {
            if (this.wait) {
                Shell.log.info((Object)"Compacting table ...");
            }
            shellState.getConnector().tableOperations().compact(tableName, this.startRow, this.endRow, this.iterators, this.flush, this.wait);
            Shell.log.info((Object)("Compaction of table " + tableName + " " + (this.wait ? "completed" : "started") + " for given range"));
        }
        catch (Exception ex) {
            throw new AccumuloException(ex);
        }
    }

    @Override
    public int execute(String fullCommand, CommandLine cl, Shell shellState) throws Exception {
        if (cl.hasOption(this.cancelOpt.getLongOpt())) {
            this.cancel = true;
            if (cl.getOptions().length > 2) {
                throw new IllegalArgumentException("Can not specify other options with cancel");
            }
        } else {
            this.cancel = false;
        }
        this.flush = !cl.hasOption(this.noFlushOption.getOpt());
        this.startRow = OptUtil.getStartRow(cl);
        this.endRow = OptUtil.getEndRow(cl);
        this.wait = cl.hasOption(this.waitOpt.getOpt());
        if (cl.hasOption(this.profileOpt.getOpt())) {
            List<IteratorSetting> iterators = shellState.iteratorProfiles.get(cl.getOptionValue(this.profileOpt.getOpt()));
            if (iterators == null) {
                Shell.log.error((Object)("Profile " + cl.getOptionValue(this.profileOpt.getOpt()) + " does not exist"));
                return -1;
            }
            this.iterators = new ArrayList<IteratorSetting>(iterators);
        } else {
            this.iterators = Collections.emptyList();
        }
        return super.execute(fullCommand, cl, shellState);
    }

    @Override
    public Options getOptions() {
        Options opts = super.getOptions();
        opts.addOption(OptUtil.startRowOpt());
        opts.addOption(OptUtil.endRowOpt());
        this.noFlushOption = new Option("nf", "noFlush", false, "do not flush table data in memory before compacting.");
        opts.addOption(this.noFlushOption);
        this.waitOpt = new Option("w", "wait", false, "wait for compact to finish");
        opts.addOption(this.waitOpt);
        this.profileOpt = new Option("pn", "profile", true, "iterator profile name");
        this.profileOpt.setArgName("profile");
        opts.addOption(this.profileOpt);
        this.cancelOpt = new Option(null, "cancel", false, "cancel user initiated compactions");
        opts.addOption(this.cancelOpt);
        return opts;
    }
}

