/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.file;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.KeyExtent;
import org.apache.accumulo.core.data.PartialKey;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.file.FileOperations;
import org.apache.accumulo.core.file.FileSKVIterator;
import org.apache.accumulo.core.file.FileSKVWriter;
import org.apache.accumulo.core.file.rfile.RFileOperations;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;
import org.apache.accumulo.core.iterators.system.MultiIterator;
import org.apache.accumulo.core.util.CachedConfiguration;
import org.apache.accumulo.core.util.LocalityGroupUtil;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.BinaryComparable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.WritableComparable;
import org.apache.log4j.Logger;

public class FileUtil {
    private static final Logger log = Logger.getLogger(FileUtil.class);

    private static String createTmpDir(AccumuloConfiguration acuConf, FileSystem fs) throws IOException {
        String accumuloDir = acuConf.get(Property.INSTANCE_DFS_DIR);
        String tmpDir = null;
        while (tmpDir == null) {
            tmpDir = accumuloDir + "/tmp/idxReduce_" + String.format("%09d", (int)(Math.random() * 2.147483647E9));
            try {
                fs.getFileStatus(new Path(tmpDir));
                tmpDir = null;
            }
            catch (FileNotFoundException fne) {
                fs.mkdirs(new Path(tmpDir));
                if (fs.createNewFile(new Path(tmpDir + "/__reserve"))) continue;
                tmpDir = null;
            }
        }
        return tmpDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<String> reduceFiles(AccumuloConfiguration acuConf, Configuration conf, FileSystem fs, Text prevEndRow, Text endRow, Collection<String> mapFiles, int maxFiles, String tmpDir, int pass) throws IOException {
        ArrayList<String> paths = new ArrayList<String>(mapFiles);
        if (paths.size() <= maxFiles) {
            return paths;
        }
        String newDir = String.format("%s/pass_%04d", tmpDir, pass);
        int start = 0;
        ArrayList<String> outFiles = new ArrayList<String>();
        int count = 0;
        block15: while (start < paths.size()) {
            int end = Math.min(maxFiles + start, paths.size());
            List<String> inFiles = paths.subList(start, end);
            start = end;
            String newMapFile = String.format("%s/%04d.rf", newDir, count++);
            outFiles.add(newMapFile);
            FileSKVWriter writer = new RFileOperations().openWriter(newMapFile, fs, conf, acuConf);
            writer.startDefaultLocalityGroup();
            ArrayList<SortedKeyValueIterator<Key, Value>> iters = new ArrayList<SortedKeyValueIterator<Key, Value>>(inFiles.size());
            FileSKVIterator reader = null;
            try {
                for (String string : inFiles) {
                    reader = FileOperations.getInstance().openIndex(string, fs, conf, acuConf);
                    iters.add(reader);
                }
                MultiIterator mmfi = new MultiIterator(iters, true);
                while (mmfi.hasTop()) {
                    boolean lteEndRow;
                    Key key = mmfi.getTopKey();
                    boolean gtPrevEndRow = prevEndRow == null || key.compareRow(prevEndRow) > 0;
                    boolean bl = lteEndRow = endRow == null || key.compareRow(endRow) <= 0;
                    if (gtPrevEndRow && lteEndRow) {
                        writer.append(key, new Value(new byte[0]));
                    }
                    if (!lteEndRow) continue block15;
                    mmfi.next();
                }
            }
            finally {
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (IOException e) {
                    log.error((Object)e, (Throwable)e);
                }
                for (SortedKeyValueIterator sortedKeyValueIterator : iters) {
                    try {
                        if (sortedKeyValueIterator == null) continue;
                        ((FileSKVIterator)sortedKeyValueIterator).close();
                    }
                    catch (IOException e) {
                        log.error((Object)e, (Throwable)e);
                    }
                }
                try {
                    if (writer == null) continue;
                    writer.close();
                }
                catch (IOException e) {
                    log.error((Object)e, (Throwable)e);
                    throw e;
                }
            }
        }
        return FileUtil.reduceFiles(acuConf, conf, fs, prevEndRow, endRow, outFiles, maxFiles, tmpDir, pass + 1);
    }

    public static SortedMap<Double, Key> findMidPoint(FileSystem fs, AccumuloConfiguration acuConf, Text prevEndRow, Text endRow, Collection<String> mapFiles, double minSplit) throws IOException {
        return FileUtil.findMidPoint(fs, acuConf, prevEndRow, endRow, mapFiles, minSplit, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static double estimatePercentageLTE(FileSystem fs, AccumuloConfiguration acuconf, Text prevEndRow, Text endRow, Collection<String> mapFiles, Text splitRow) throws IOException {
        double d;
        long numKeys;
        ArrayList<FileSKVIterator> readers;
        String tmpDir;
        block8: {
            Configuration conf = CachedConfiguration.getInstance();
            tmpDir = null;
            int maxToOpen = acuconf.getCount(Property.TSERV_TABLET_SPLIT_FINDMIDPOINT_MAXOPEN);
            readers = new ArrayList<FileSKVIterator>(mapFiles.size());
            if (mapFiles.size() > maxToOpen) {
                tmpDir = FileUtil.createTmpDir(acuconf, fs);
                log.debug((Object)("Too many indexes (" + mapFiles.size() + ") to open at once for " + endRow + " " + prevEndRow + ", reducing in tmpDir = " + tmpDir));
                long t1 = System.currentTimeMillis();
                mapFiles = FileUtil.reduceFiles(acuconf, conf, fs, prevEndRow, endRow, mapFiles, maxToOpen, tmpDir, 0);
                long t2 = System.currentTimeMillis();
                log.debug((Object)("Finished reducing indexes for " + endRow + " " + prevEndRow + " in " + String.format("%6.2f secs", (double)(t2 - t1) / 1000.0)));
            }
            if (prevEndRow == null) {
                prevEndRow = new Text();
            }
            numKeys = 0L;
            numKeys = FileUtil.countIndexEntries(acuconf, prevEndRow, endRow, mapFiles, true, conf, fs, readers);
            if (numKeys != 0L) break block8;
            double t2 = 0.5;
            FileUtil.cleanupIndexOp(acuconf, tmpDir, fs, readers);
            return t2;
        }
        try {
            ArrayList<SortedKeyValueIterator<Key, Value>> iters = new ArrayList<SortedKeyValueIterator<Key, Value>>(readers);
            MultiIterator mmfi = new MultiIterator(iters, true);
            while (mmfi.hasTop() && mmfi.getTopKey().compareRow(prevEndRow) <= 0) {
                mmfi.next();
            }
            int numLte = 0;
            while (mmfi.hasTop() && mmfi.getTopKey().compareRow(splitRow) <= 0) {
                ++numLte;
                mmfi.next();
            }
            if ((long)numLte > numKeys) {
                throw new RuntimeException("numLte > numKeys " + numLte + " " + numKeys + " " + prevEndRow + " " + endRow + " " + splitRow + " " + mapFiles);
            }
            d = (double)(numLte + 1) / (double)(numKeys + 2L);
        }
        catch (Throwable throwable) {
            FileUtil.cleanupIndexOp(acuconf, tmpDir, fs, readers);
            throw throwable;
        }
        FileUtil.cleanupIndexOp(acuconf, tmpDir, fs, readers);
        return d;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public static SortedMap<Double, Key> findMidPoint(FileSystem fs, AccumuloConfiguration acuConf, Text prevEndRow, Text endRow, Collection<String> mapFiles, double minSplit, boolean useIndex) throws IOException {
        block12: {
            conf = CachedConfiguration.getInstance();
            origMapFiles = mapFiles;
            tmpDir = null;
            maxToOpen = acuConf.getCount(Property.TSERV_TABLET_SPLIT_FINDMIDPOINT_MAXOPEN);
            readers = new ArrayList<FileSKVIterator>(mapFiles.size());
            if (mapFiles.size() > maxToOpen) {
                if (!useIndex) {
                    throw new IOException("Cannot find mid point using data files, too many " + mapFiles.size());
                }
                tmpDir = FileUtil.createTmpDir(acuConf, fs);
                FileUtil.log.debug((Object)("Too many indexes (" + mapFiles.size() + ") to open at once for " + endRow + " " + prevEndRow + ", reducing in tmpDir = " + tmpDir));
                t1 = System.currentTimeMillis();
                mapFiles = FileUtil.reduceFiles(acuConf, conf, fs, prevEndRow, endRow, mapFiles, maxToOpen, tmpDir, 0);
                t2 = System.currentTimeMillis();
                FileUtil.log.debug((Object)("Finished reducing indexes for " + endRow + " " + prevEndRow + " in " + String.format("%6.2f secs", new Object[]{(double)(t2 - t1) / 1000.0})));
            }
            if (prevEndRow == null) {
                prevEndRow = new Text();
            }
            t1 = System.currentTimeMillis();
            numKeys = 0L;
            numKeys = FileUtil.countIndexEntries(acuConf, prevEndRow, endRow, mapFiles, tmpDir == null ? useIndex : false, conf, fs, readers);
            if (numKeys != 0L) ** GOTO lbl30
            if (!useIndex) break block12;
            FileUtil.log.warn((Object)("Failed to find mid point using indexes, falling back to data files which is slower. No entries between " + prevEndRow + " and " + endRow + " for " + mapFiles));
            var17_14 = FileUtil.findMidPoint(fs, acuConf, prevEndRow, endRow, origMapFiles, minSplit, false);
            FileUtil.cleanupIndexOp(acuConf, tmpDir, fs, readers);
            return var17_14;
        }
        try {
            throw new IOException("Failed to find mid point, no entries between " + prevEndRow + " and " + endRow + " for " + mapFiles);
lbl30:
            // 1 sources

            iters = new ArrayList<SortedKeyValueIterator<Key, Value>>(readers);
            mmfi = new MultiIterator(iters, true);
            while (mmfi.hasTop() && mmfi.getTopKey().compareRow(prevEndRow) <= 0) {
                mmfi.next();
            }
            ret = new TreeMap<Double, Key>();
            lastKey = null;
            keyBeforeMidPoint = null;
            keyBeforeMidPointPosition = 0L;
            for (keysRead = 0L; keysRead < numKeys / 2L; ++keysRead) {
                if (lastKey != null && !lastKey.equals(mmfi.getTopKey(), PartialKey.ROW) && (double)(keysRead - 1L) / (double)numKeys >= minSplit) {
                    keyBeforeMidPoint = new Key(lastKey);
                    keyBeforeMidPointPosition = keysRead - 1L;
                }
                if (lastKey == null) {
                    lastKey = new Key();
                }
                lastKey.set(mmfi.getTopKey());
                mmfi.next();
            }
            if (keyBeforeMidPoint != null) {
                ret.put((double)keyBeforeMidPointPosition / (double)numKeys, keyBeforeMidPoint);
            }
            t2 = System.currentTimeMillis();
            FileUtil.log.debug((Object)String.format("Found midPoint from indexes in %6.2f secs.%n", new Object[]{(double)(t2 - t1) / 1000.0}));
            ret.put(0.5, mmfi.getTopKey());
            for (Key key : ret.values()) {
                inRange = key.compareRow(prevEndRow) > 0 && (endRow == null || key.compareRow(endRow) < 1);
                if (inRange) continue;
                throw new IOException("Found mid point is not in range " + key + " " + prevEndRow + " " + endRow + " " + mapFiles);
            }
            var28_23 = ret;
        }
        catch (Throwable var31_26) {
            FileUtil.cleanupIndexOp(acuConf, tmpDir, fs, readers);
            throw var31_26;
        }
        FileUtil.cleanupIndexOp(acuConf, tmpDir, fs, readers);
        return var28_23;
    }

    private static void cleanupIndexOp(AccumuloConfiguration acuConf, String tmpDir, FileSystem fs, ArrayList<FileSKVIterator> readers) throws IOException {
        for (FileSKVIterator r : readers) {
            try {
                if (r == null) continue;
                r.close();
            }
            catch (IOException e) {
                log.error((Object)e, (Throwable)e);
            }
        }
        if (tmpDir != null) {
            String tmpPrefix = acuConf.get(Property.INSTANCE_DFS_DIR) + "/tmp";
            if (tmpDir.startsWith(tmpPrefix)) {
                fs.delete(new Path(tmpDir), true);
            } else {
                log.error((Object)("Did not delete tmp dir because it wasn't a tmp dir " + tmpDir));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long countIndexEntries(AccumuloConfiguration acuConf, Text prevEndRow, Text endRow, Collection<String> mapFiles, boolean useIndex, Configuration conf, FileSystem fs, ArrayList<FileSKVIterator> readers) throws IOException {
        long numKeys = 0L;
        for (String path : mapFiles) {
            FileSKVIterator reader = null;
            try {
                reader = useIndex ? FileOperations.getInstance().openIndex(path, fs, conf, acuConf) : FileOperations.getInstance().openReader(path, new Range(prevEndRow, false, null, true), LocalityGroupUtil.EMPTY_CF_SET, false, fs, conf, acuConf);
                while (reader.hasTop()) {
                    Key key = (Key)reader.getTopKey();
                    if (endRow != null && key.compareRow(endRow) > 0) {
                        break;
                    }
                    if (prevEndRow == null || key.compareRow(prevEndRow) > 0) {
                        ++numKeys;
                    }
                    reader.next();
                }
            }
            finally {
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (IOException e) {
                    log.error((Object)e, (Throwable)e);
                }
            }
            if (useIndex) {
                readers.add(FileOperations.getInstance().openIndex(path, fs, conf, acuConf));
                continue;
            }
            readers.add(FileOperations.getInstance().openReader(path, new Range(prevEndRow, false, null, true), LocalityGroupUtil.EMPTY_CF_SET, false, fs, conf, acuConf));
        }
        return numKeys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, FileInfo> tryToGetFirstAndLastRows(FileSystem fs, AccumuloConfiguration acuConf, Set<String> mapfiles) {
        HashMap<String, FileInfo> mapFilesInfo = new HashMap<String, FileInfo>();
        Configuration conf = CachedConfiguration.getInstance();
        long t1 = System.currentTimeMillis();
        for (String mapfile : mapfiles) {
            FileSKVIterator reader = null;
            try {
                reader = FileOperations.getInstance().openReader(mapfile, false, fs, conf, acuConf);
                Key firstKey = reader.getFirstKey();
                if (firstKey == null) continue;
                mapFilesInfo.put(mapfile, new FileInfo(firstKey, reader.getLastKey()));
            }
            catch (IOException ioe) {
                log.warn((Object)("Failed to read map file to determine first and last key : " + mapfile), (Throwable)ioe);
            }
            finally {
                if (reader == null) continue;
                try {
                    reader.close();
                }
                catch (IOException ioe) {
                    log.warn((Object)("failed to close " + mapfile), (Throwable)ioe);
                }
            }
        }
        long t2 = System.currentTimeMillis();
        log.debug((Object)String.format("Found first and last keys for %d map files in %6.2f secs", mapfiles.size(), (double)(t2 - t1) / 1000.0));
        return mapFilesInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WritableComparable<Key> findLastKey(FileSystem fs, AccumuloConfiguration acuConf, Collection<String> mapFiles) throws IOException {
        Key lastKey = null;
        Configuration conf = CachedConfiguration.getInstance();
        for (String path : mapFiles) {
            FileSKVIterator reader = FileOperations.getInstance().openReader(path, true, fs, conf, acuConf);
            try {
                if (!reader.hasTop()) continue;
                Key key = reader.getLastKey();
                if (lastKey != null && key.compareTo(lastKey) <= 0) continue;
                lastKey = key;
            }
            finally {
                try {
                    if (reader == null) continue;
                    reader.close();
                }
                catch (IOException e) {
                    log.error((Object)e, (Throwable)e);
                }
            }
        }
        return lastKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<KeyExtent, Long> estimateSizes(AccumuloConfiguration acuConf, Path mapFile, long fileSize, List<KeyExtent> extents, Configuration conf, FileSystem fs) throws IOException {
        long totalIndexEntries = 0L;
        TreeMap<KeyExtent, MLong> counts = new TreeMap<KeyExtent, MLong>();
        for (KeyExtent keyExtent : extents) {
            counts.put(keyExtent, new MLong(0L));
        }
        Text row = new Text();
        FileSKVIterator index = FileOperations.getInstance().openIndex(mapFile.toString(), fs, conf, acuConf);
        try {
            while (index.hasTop()) {
                Key key = (Key)index.getTopKey();
                ++totalIndexEntries;
                key.getRow(row);
                for (Map.Entry entry : counts.entrySet()) {
                    if (!((KeyExtent)entry.getKey()).contains((BinaryComparable)row)) continue;
                    ++((MLong)entry.getValue()).l;
                }
                index.next();
            }
        }
        finally {
            try {
                if (index != null) {
                    index.close();
                }
            }
            catch (IOException e) {
                log.error((Object)e, (Throwable)e);
            }
        }
        TreeMap<KeyExtent, Long> results = new TreeMap<KeyExtent, Long>();
        for (KeyExtent keyExtent : extents) {
            double numEntries = ((MLong)counts.get((Object)keyExtent)).l;
            if (numEntries == 0.0) {
                numEntries = 1.0;
            }
            long estSize = (long)(numEntries / (double)totalIndexEntries * (double)fileSize);
            results.put(keyExtent, estSize);
        }
        return results;
    }

    public static FileSystem getFileSystem(Configuration conf, AccumuloConfiguration acuconf) throws IOException {
        String uri = acuconf.get(Property.INSTANCE_DFS_URI);
        if ("".equals(uri)) {
            return FileSystem.get((Configuration)conf);
        }
        try {
            return FileSystem.get((URI)new URI(uri), (Configuration)conf);
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
    }

    private static class MLong {
        long l;

        public MLong(long i) {
            this.l = i;
        }
    }

    public static class FileInfo {
        Key firstKey = new Key();
        Key lastKey = new Key();

        public FileInfo(Key firstKey, Key lastKey) {
            this.firstKey = firstKey;
            this.lastKey = lastKey;
        }

        public Text getFirstRow() {
            return this.firstKey.getRow();
        }

        public Text getLastRow() {
            return this.lastKey.getRow();
        }
    }
}

