/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.api.events;

import com.google.common.base.Preconditions;
import java.nio.ByteBuffer;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.tez.runtime.api.Event;

@InterfaceStability.Unstable
@InterfaceAudience.Public
public class VertexManagerEvent
extends Event {
    private final String targetVertexName;
    private final ByteBuffer userPayload;

    private VertexManagerEvent(String vertexName, ByteBuffer userPayload) {
        Preconditions.checkArgument((vertexName != null ? 1 : 0) != 0);
        Preconditions.checkArgument((userPayload != null ? 1 : 0) != 0);
        this.targetVertexName = vertexName;
        this.userPayload = userPayload;
    }

    public static VertexManagerEvent create(String vertexName, ByteBuffer userPayload) {
        return new VertexManagerEvent(vertexName, userPayload);
    }

    public String getTargetVertexName() {
        return this.targetVertexName;
    }

    public ByteBuffer getUserPayload() {
        return this.userPayload == null ? null : this.userPayload.asReadOnlyBuffer();
    }
}

