/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.FileNotFoundException;
import java.io.OutputStream;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.AppendTestUtil;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.BlockStoragePolicy;
import org.apache.hadoop.hdfs.protocol.DatanodeID;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocolPB.DatanodeProtocolClientSideTranslatorPB;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockPlacementPolicy;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockPlacementPolicyDefault;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeStorageInfo;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.DataNodeTestUtils;
import org.apache.hadoop.hdfs.server.namenode.FSDirectory;
import org.apache.hadoop.hdfs.server.namenode.INode;
import org.apache.hadoop.hdfs.server.namenode.INodeMap;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.snapshot.SnapshotTestHelper;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.net.Node;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.internal.util.reflection.Whitebox;
import org.mockito.stubbing.Answer;

public class TestDeleteRace {
    private static final int BLOCK_SIZE = 4096;
    private static final Log LOG = LogFactory.getLog(TestDeleteRace.class);
    private static final Configuration conf = new HdfsConfiguration();
    private MiniDFSCluster cluster;

    @Test
    public void testDeleteAddBlockRace() throws Exception {
        this.testDeleteAddBlockRace(false);
    }

    @Test
    public void testDeleteAddBlockRaceWithSnapshot() throws Exception {
        this.testDeleteAddBlockRace(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testDeleteAddBlockRace(boolean hasSnapshot) throws Exception {
        try {
            conf.setClass("dfs.block.replicator.classname", SlowBlockPlacementPolicy.class, BlockPlacementPolicy.class);
            this.cluster = new MiniDFSCluster.Builder(conf).build();
            DistributedFileSystem fs = this.cluster.getFileSystem();
            String fileName = "/testDeleteAddBlockRace";
            Path filePath = new Path("/testDeleteAddBlockRace");
            FSDataOutputStream out = null;
            out = fs.create(filePath);
            if (hasSnapshot) {
                SnapshotTestHelper.createSnapshot(fs, new Path("/"), "s1");
            }
            DeleteThread deleteThread = new DeleteThread((FileSystem)fs, filePath);
            deleteThread.start();
            try {
                out.write(new byte[32], 0, 32);
                out.hsync();
                Assert.fail((String)"Should have failed.");
            }
            catch (FileNotFoundException e) {
                GenericTestUtils.assertExceptionContains((String)filePath.getName(), (Throwable)e);
            }
        }
        finally {
            if (this.cluster != null) {
                this.cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRenameRace() throws Exception {
        try {
            conf.setClass("dfs.block.replicator.classname", SlowBlockPlacementPolicy.class, BlockPlacementPolicy.class);
            this.cluster = new MiniDFSCluster.Builder(conf).build();
            DistributedFileSystem fs = this.cluster.getFileSystem();
            Path dirPath1 = new Path("/testRenameRace1");
            Path dirPath2 = new Path("/testRenameRace2");
            Path filePath = new Path("/testRenameRace1/file1");
            fs.mkdirs(dirPath1);
            FSDataOutputStream out = fs.create(filePath);
            RenameThread renameThread = new RenameThread((FileSystem)fs, dirPath1, dirPath2);
            renameThread.start();
            out.write(new byte[32], 0, 32);
            out.close();
            this.cluster.restartNameNode(0);
        }
        finally {
            if (this.cluster != null) {
                this.cluster.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testDeleteAndCommitBlockSynchronizationRace(boolean hasSnapshot) throws Exception {
        LOG.info((Object)("Start testing, hasSnapshot: " + hasSnapshot));
        ArrayList<AbstractMap.SimpleImmutableEntry<String, Boolean>> testList = new ArrayList<AbstractMap.SimpleImmutableEntry<String, Boolean>>();
        testList.add(new AbstractMap.SimpleImmutableEntry<String, Boolean>("/test-file", false));
        testList.add(new AbstractMap.SimpleImmutableEntry<String, Boolean>("/test-file1", true));
        testList.add(new AbstractMap.SimpleImmutableEntry<String, Boolean>("/testdir/testdir1/test-file", false));
        testList.add(new AbstractMap.SimpleImmutableEntry<String, Boolean>("/testdir/testdir1/test-file1", true));
        Path rootPath = new Path("/");
        Configuration conf = new Configuration();
        conf.setBoolean("dfs.permissions.enabled", false);
        conf.setInt("dfs.blocksize", 4096);
        FSDataOutputStream stm = null;
        HashMap<DataNode, DatanodeProtocolClientSideTranslatorPB> dnMap = new HashMap<DataNode, DatanodeProtocolClientSideTranslatorPB>();
        try {
            this.cluster = new MiniDFSCluster.Builder(conf).numDataNodes(3).build();
            this.cluster.waitActive();
            DistributedFileSystem fs = this.cluster.getFileSystem();
            int stId = 0;
            for (AbstractMap.SimpleImmutableEntry simpleImmutableEntry : testList) {
                Path fPath;
                String testPath = (String)simpleImmutableEntry.getKey();
                Boolean mkSameDir = (Boolean)simpleImmutableEntry.getValue();
                LOG.info((Object)("test on " + testPath + " mkSameDir: " + mkSameDir + " snapshot: " + hasSnapshot));
                Path grandestNonRootParent = fPath = new Path(testPath);
                while (!grandestNonRootParent.getParent().equals((Object)rootPath)) {
                    grandestNonRootParent = grandestNonRootParent.getParent();
                }
                stm = fs.create(fPath);
                LOG.info((Object)("test on " + testPath + " created " + fPath));
                AppendTestUtil.write((OutputStream)stm, 0, 2048);
                stm.hflush();
                if (hasSnapshot) {
                    SnapshotTestHelper.createSnapshot(fs, rootPath, "st" + String.valueOf(stId));
                    ++stId;
                }
                NameNode nn = this.cluster.getNameNode();
                ExtendedBlock blk = DFSTestUtil.getFirstBlock((FileSystem)fs, fPath);
                DatanodeDescriptor expectedPrimary = DFSTestUtil.getExpectedPrimaryNode(nn, blk);
                LOG.info((Object)("Expecting block recovery to be triggered on DN " + expectedPrimary));
                DataNode primaryDN = this.cluster.getDataNode(expectedPrimary.getIpcPort());
                DatanodeProtocolClientSideTranslatorPB nnSpy = (DatanodeProtocolClientSideTranslatorPB)dnMap.get(primaryDN);
                if (nnSpy == null) {
                    nnSpy = DataNodeTestUtils.spyOnBposToNN(primaryDN, nn);
                    dnMap.put(primaryDN, nnSpy);
                }
                GenericTestUtils.DelayAnswer delayer = new GenericTestUtils.DelayAnswer(LOG);
                ((DatanodeProtocolClientSideTranslatorPB)Mockito.doAnswer((Answer)delayer).when((Object)nnSpy)).commitBlockSynchronization((ExtendedBlock)Mockito.eq((Object)blk), (long)Mockito.anyInt(), Mockito.anyLong(), Mockito.eq((boolean)true), Mockito.eq((boolean)false), (DatanodeID[])Mockito.anyObject(), (String[])Mockito.anyObject());
                fs.recoverLease(fPath);
                LOG.info((Object)"Waiting for commitBlockSynchronization call from primary");
                delayer.waitForCall();
                LOG.info((Object)("Deleting recursively " + grandestNonRootParent));
                fs.delete(grandestNonRootParent, true);
                if (mkSameDir.booleanValue() && !grandestNonRootParent.toString().equals(testPath)) {
                    LOG.info((Object)("Recreate dir " + grandestNonRootParent + " testpath: " + testPath));
                    fs.mkdirs(grandestNonRootParent);
                }
                delayer.proceed();
                LOG.info((Object)"Now wait for result");
                delayer.waitForResult();
                Throwable t = delayer.getThrown();
                if (t == null) continue;
                LOG.info((Object)("Result exception (snapshot: " + hasSnapshot + "): " + t));
            }
            LOG.info((Object)"Now check we can restart");
            this.cluster.restartNameNodes();
            LOG.info((Object)"Restart finished");
        }
        finally {
            if (stm != null) {
                IOUtils.closeStream(stm);
            }
            if (this.cluster != null) {
                this.cluster.shutdown();
            }
        }
    }

    @Test(timeout=600000L)
    public void testDeleteAndCommitBlockSynchonizationRaceNoSnapshot() throws Exception {
        this.testDeleteAndCommitBlockSynchronizationRace(false);
    }

    @Test(timeout=600000L)
    public void testDeleteAndCommitBlockSynchronizationRaceHasSnapshot() throws Exception {
        this.testDeleteAndCommitBlockSynchronizationRace(true);
    }

    private class RenameThread
    extends Thread {
        private FileSystem fs;
        private Path from;
        private Path to;

        RenameThread(FileSystem fs, Path from, Path to) {
            this.fs = fs;
            this.from = from;
            this.to = to;
        }

        @Override
        public void run() {
            try {
                Thread.sleep(1000L);
                LOG.info((Object)("Renaming " + this.from + " to " + this.to));
                this.fs.rename(this.from, this.to);
                LOG.info((Object)("Renamed " + this.from + " to " + this.to));
            }
            catch (Exception e) {
                LOG.info((Object)e);
            }
        }
    }

    private class DeleteThread
    extends Thread {
        private FileSystem fs;
        private Path path;

        DeleteThread(FileSystem fs, Path path) {
            this.fs = fs;
            this.path = path;
        }

        @Override
        public void run() {
            try {
                Thread.sleep(1000L);
                LOG.info((Object)("Deleting" + this.path));
                FSDirectory fsdir = ((TestDeleteRace)TestDeleteRace.this).cluster.getNamesystem().dir;
                INode fileINode = fsdir.getINode4Write(this.path.toString());
                INodeMap inodeMap = (INodeMap)Whitebox.getInternalState((Object)fsdir, (String)"inodeMap");
                this.fs.delete(this.path, false);
                inodeMap.put(fileINode);
                LOG.info((Object)("Deleted" + this.path));
            }
            catch (Exception e) {
                LOG.info((Object)e);
            }
        }
    }

    private static class SlowBlockPlacementPolicy
    extends BlockPlacementPolicyDefault {
        private SlowBlockPlacementPolicy() {
        }

        public DatanodeStorageInfo[] chooseTarget(String srcPath, int numOfReplicas, Node writer, List<DatanodeStorageInfo> chosenNodes, boolean returnChosenNodes, Set<Node> excludedNodes, long blocksize, BlockStoragePolicy storagePolicy) {
            DatanodeStorageInfo[] results = super.chooseTarget(srcPath, numOfReplicas, writer, chosenNodes, returnChosenNodes, excludedNodes, blocksize, storagePolicy);
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return results;
        }
    }
}

