/*
 * Decompiled with CFR 0.152.
 */
package org.spark-project.jetty.util.statistic;

import java.util.concurrent.atomic.AtomicLong;
import org.spark-project.jetty.util.Atomics;

public class SampleStatistic {
    protected final AtomicLong _max = new AtomicLong();
    protected final AtomicLong _total = new AtomicLong();
    protected final AtomicLong _count = new AtomicLong();
    protected final AtomicLong _totalVariance100 = new AtomicLong();

    public void reset() {
        this._max.set(0L);
        this._total.set(0L);
        this._count.set(0L);
        this._totalVariance100.set(0L);
    }

    public void set(long sample2) {
        long total = this._total.addAndGet(sample2);
        long count2 = this._count.incrementAndGet();
        if (count2 > 1L) {
            long mean10 = total * 10L / count2;
            long delta10 = sample2 * 10L - mean10;
            this._totalVariance100.addAndGet(delta10 * delta10);
        }
        Atomics.updateMax(this._max, sample2);
    }

    public long getMax() {
        return this._max.get();
    }

    public long getTotal() {
        return this._total.get();
    }

    public long getCount() {
        return this._count.get();
    }

    public double getMean() {
        return (double)this._total.get() / (double)this._count.get();
    }

    public double getVariance() {
        long variance100 = this._totalVariance100.get();
        long count2 = this._count.get();
        return count2 > 1L ? (double)variance100 / 100.0 / (double)(count2 - 1L) : 0.0;
    }

    public double getStdDev() {
        return Math.sqrt(this.getVariance());
    }
}

