/*
 * Decompiled with CFR 0.152.
 */
package org.spark-project.jetty.server.handler;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Locale;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.spark-project.jetty.server.Request;
import org.spark-project.jetty.server.Response;
import org.spark-project.jetty.server.handler.HandlerWrapper;
import org.spark-project.jetty.util.DateCache;
import org.spark-project.jetty.util.RolloverFileOutputStream;

public class DebugHandler
extends HandlerWrapper {
    private DateCache _date = new DateCache("HH:mm:ss", Locale.US);
    private OutputStream _out;
    private PrintStream _print;

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        int ms;
        String d;
        Response base_response = baseRequest.getResponse();
        Thread thread = Thread.currentThread();
        String old_name = thread.getName();
        boolean suspend = false;
        boolean retry = false;
        String name = (String)request.getAttribute("org.spark-project.jetty.thread.name");
        if (name == null) {
            name = old_name + ":" + baseRequest.getScheme() + "://" + baseRequest.getLocalAddr() + ":" + baseRequest.getLocalPort() + baseRequest.getUri();
        } else {
            retry = true;
        }
        String ex = null;
        try {
            d = this._date.now();
            ms = this._date.lastMs();
            if (retry) {
                this._print.println(d + (ms > 99 ? "." : (ms > 9 ? ".0" : ".00")) + ms + ":" + name + " RETRY");
            } else {
                this._print.println(d + (ms > 99 ? "." : (ms > 9 ? ".0" : ".00")) + ms + ":" + name + " " + baseRequest.getRemoteAddr() + " " + request.getMethod() + " " + baseRequest.getHeader("Cookie") + "; " + baseRequest.getHeader("User-Agent"));
            }
            thread.setName(name);
            this.getHandler().handle(target, baseRequest, request, response);
        }
        catch (IOException ioe) {
            try {
                ex = ioe.toString();
                throw ioe;
                catch (ServletException se) {
                    ex = se.toString() + ":" + se.getCause();
                    throw se;
                }
                catch (RuntimeException rte) {
                    ex = rte.toString();
                    throw rte;
                }
                catch (Error e) {
                    ex = e.toString();
                    throw e;
                }
            }
            catch (Throwable throwable) {
                thread.setName(old_name);
                String d2 = this._date.now();
                int ms2 = this._date.lastMs();
                suspend = baseRequest.getAsyncContinuation().isSuspended();
                if (suspend) {
                    request.setAttribute("org.spark-project.jetty.thread.name", (Object)name);
                    this._print.println(d2 + (ms2 > 99 ? "." : (ms2 > 9 ? ".0" : ".00")) + ms2 + ":" + name + " SUSPEND");
                    throw throwable;
                }
                this._print.println(d2 + (ms2 > 99 ? "." : (ms2 > 9 ? ".0" : ".00")) + ms2 + ":" + name + " " + base_response.getStatus() + (ex == null ? "" : "/" + ex) + " " + base_response.getContentType() + " " + base_response.getContentCount());
                throw throwable;
            }
        }
        thread.setName(old_name);
        d = this._date.now();
        ms = this._date.lastMs();
        suspend = baseRequest.getAsyncContinuation().isSuspended();
        if (suspend) {
            request.setAttribute("org.spark-project.jetty.thread.name", (Object)name);
            this._print.println(d + (ms > 99 ? "." : (ms > 9 ? ".0" : ".00")) + ms + ":" + name + " SUSPEND");
            return;
        }
        this._print.println(d + (ms > 99 ? "." : (ms > 9 ? ".0" : ".00")) + ms + ":" + name + " " + base_response.getStatus() + (ex == null ? "" : "/" + ex) + " " + base_response.getContentType() + " " + base_response.getContentCount());
    }

    @Override
    protected void doStart() throws Exception {
        if (this._out == null) {
            this._out = new RolloverFileOutputStream("./logs/yyyy_mm_dd.debug.log", true);
        }
        this._print = new PrintStream(this._out);
        super.doStart();
    }

    @Override
    protected void doStop() throws Exception {
        super.doStop();
        this._print.close();
    }

    public OutputStream getOutputStream() {
        return this._out;
    }

    public void setOutputStream(OutputStream out) {
        this._out = out;
    }
}

