/*
 * Decompiled with CFR 0.152.
 */
package org.spark-project.jetty.plus.webapp;

import java.util.Random;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import org.spark-project.jetty.plus.jndi.Transaction;
import org.spark-project.jetty.plus.webapp.PlusDecorator;
import org.spark-project.jetty.plus.webapp.PlusDescriptorProcessor;
import org.spark-project.jetty.servlet.ServletContextHandler;
import org.spark-project.jetty.util.log.Log;
import org.spark-project.jetty.util.log.Logger;
import org.spark-project.jetty.webapp.AbstractConfiguration;
import org.spark-project.jetty.webapp.DescriptorProcessor;
import org.spark-project.jetty.webapp.WebAppContext;

public class PlusConfiguration
extends AbstractConfiguration {
    private static final Logger LOG = Log.getLogger(PlusConfiguration.class);
    private Integer _key;

    public void preConfigure(WebAppContext context) throws Exception {
        context.addDecorator((ServletContextHandler.Decorator)new PlusDecorator(context));
    }

    public void cloneConfigure(WebAppContext template, WebAppContext context) throws Exception {
        context.addDecorator((ServletContextHandler.Decorator)new PlusDecorator(context));
    }

    public void configure(WebAppContext context) throws Exception {
        this.bindUserTransaction(context);
        context.getMetaData().addDescriptorProcessor((DescriptorProcessor)new PlusDescriptorProcessor());
    }

    public void postConfigure(WebAppContext context) throws Exception {
        this.lockCompEnv(context);
    }

    public void deconfigure(WebAppContext context) throws Exception {
        this.unlockCompEnv(context);
        this._key = null;
        context.setAttribute("org.spark-project.jetty.injectionCollection", null);
        context.setAttribute("org.spark-project.jetty.lifecyleCallbackCollection", null);
    }

    public void bindUserTransaction(WebAppContext context) throws Exception {
        try {
            Transaction.bindToENC();
        }
        catch (NameNotFoundException e) {
            LOG.info("No Transaction manager found - if your webapp requires one, please configure one.", new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void lockCompEnv(WebAppContext wac) throws Exception {
        ClassLoader old_loader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(wac.getClassLoader());
        try {
            Random random2 = new Random();
            this._key = new Integer(random2.nextInt());
            InitialContext context = new InitialContext();
            Context compCtx = (Context)context.lookup("java:comp");
            compCtx.addToEnvironment("org.eclipse.jndi.lock", this._key);
        }
        finally {
            Thread.currentThread().setContextClassLoader(old_loader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unlockCompEnv(WebAppContext wac) throws Exception {
        if (this._key != null) {
            ClassLoader old_loader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(wac.getClassLoader());
            try {
                InitialContext context = new InitialContext();
                Context compCtx = (Context)context.lookup("java:comp");
                compCtx.addToEnvironment("org.eclipse.jndi.unlock", this._key);
            }
            finally {
                Thread.currentThread().setContextClassLoader(old_loader);
            }
        }
    }
}

