/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.broadcast;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.spark.HttpServer;
import org.apache.spark.Logging;
import org.apache.spark.Logging$class;
import org.apache.spark.SecurityManager;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkEnv$;
import org.apache.spark.broadcast.HttpBroadcast$$anonfun$org$apache$spark$broadcast$HttpBroadcast$;
import org.apache.spark.io.CompressionCodec;
import org.apache.spark.io.CompressionCodec$;
import org.apache.spark.serializer.DeserializationStream;
import org.apache.spark.serializer.SerializationStream;
import org.apache.spark.serializer.SerializerInstance;
import org.apache.spark.storage.BroadcastBlockId;
import org.apache.spark.storage.BroadcastBlockId$;
import org.apache.spark.util.MetadataCleaner;
import org.apache.spark.util.MetadataCleanerType$;
import org.apache.spark.util.TimeStampedHashSet;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.TraitSetter;

public final class HttpBroadcast$
implements Logging,
Serializable {
    public static final HttpBroadcast$ MODULE$;
    private boolean initialized;
    private File broadcastDir;
    private boolean org$apache$spark$broadcast$HttpBroadcast$$compress;
    private int org$apache$spark$broadcast$HttpBroadcast$$bufferSize;
    private String org$apache$spark$broadcast$HttpBroadcast$$serverUri;
    private HttpServer server;
    private SecurityManager securityManager;
    private final TimeStampedHashSet<File> org$apache$spark$broadcast$HttpBroadcast$$files;
    private final int httpReadTimeout;
    private CompressionCodec org$apache$spark$broadcast$HttpBroadcast$$compressionCodec;
    private MetadataCleaner cleaner;
    private transient Logger org$apache$spark$Logging$$log_;

    static {
        new HttpBroadcast$();
    }

    @Override
    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    @Override
    @TraitSetter
    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    @Override
    public String logName() {
        return Logging$class.logName(this);
    }

    @Override
    public Logger log() {
        return Logging$class.log(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging$class.logInfo(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging$class.logDebug(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging$class.logTrace(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging$class.logWarning(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging$class.logError(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging$class.logInfo(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging$class.logDebug(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging$class.logTrace(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging$class.logWarning(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging$class.logError(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    private boolean initialized() {
        return this.initialized;
    }

    private void initialized_$eq(boolean x$1) {
        this.initialized = x$1;
    }

    private File broadcastDir() {
        return this.broadcastDir;
    }

    private void broadcastDir_$eq(File x$1) {
        this.broadcastDir = x$1;
    }

    public boolean org$apache$spark$broadcast$HttpBroadcast$$compress() {
        return this.org$apache$spark$broadcast$HttpBroadcast$$compress;
    }

    private void org$apache$spark$broadcast$HttpBroadcast$$compress_$eq(boolean x$1) {
        this.org$apache$spark$broadcast$HttpBroadcast$$compress = x$1;
    }

    public int org$apache$spark$broadcast$HttpBroadcast$$bufferSize() {
        return this.org$apache$spark$broadcast$HttpBroadcast$$bufferSize;
    }

    private void org$apache$spark$broadcast$HttpBroadcast$$bufferSize_$eq(int x$1) {
        this.org$apache$spark$broadcast$HttpBroadcast$$bufferSize = x$1;
    }

    public String org$apache$spark$broadcast$HttpBroadcast$$serverUri() {
        return this.org$apache$spark$broadcast$HttpBroadcast$$serverUri;
    }

    private void org$apache$spark$broadcast$HttpBroadcast$$serverUri_$eq(String x$1) {
        this.org$apache$spark$broadcast$HttpBroadcast$$serverUri = x$1;
    }

    private HttpServer server() {
        return this.server;
    }

    private void server_$eq(HttpServer x$1) {
        this.server = x$1;
    }

    private SecurityManager securityManager() {
        return this.securityManager;
    }

    private void securityManager_$eq(SecurityManager x$1) {
        this.securityManager = x$1;
    }

    public TimeStampedHashSet<File> org$apache$spark$broadcast$HttpBroadcast$$files() {
        return this.org$apache$spark$broadcast$HttpBroadcast$$files;
    }

    private int httpReadTimeout() {
        return this.httpReadTimeout;
    }

    public CompressionCodec org$apache$spark$broadcast$HttpBroadcast$$compressionCodec() {
        return this.org$apache$spark$broadcast$HttpBroadcast$$compressionCodec;
    }

    private void org$apache$spark$broadcast$HttpBroadcast$$compressionCodec_$eq(CompressionCodec x$1) {
        this.org$apache$spark$broadcast$HttpBroadcast$$compressionCodec = x$1;
    }

    private MetadataCleaner cleaner() {
        return this.cleaner;
    }

    private void cleaner_$eq(MetadataCleaner x$1) {
        this.cleaner = x$1;
    }

    public synchronized void initialize(boolean isDriver, SparkConf conf, SecurityManager securityMgr) {
        if (!this.initialized()) {
            Object object;
            this.org$apache$spark$broadcast$HttpBroadcast$$bufferSize_$eq(conf.getInt("spark.buffer.size", 65536));
            this.org$apache$spark$broadcast$HttpBroadcast$$compress_$eq(conf.getBoolean("spark.broadcast.compress", true));
            this.securityManager_$eq(securityMgr);
            if (isDriver) {
                this.createServer(conf);
                object = conf.set("spark.httpBroadcast.uri", this.org$apache$spark$broadcast$HttpBroadcast$$serverUri());
            } else {
                object = BoxedUnit.UNIT;
            }
            this.org$apache$spark$broadcast$HttpBroadcast$$serverUri_$eq(conf.get("spark.httpBroadcast.uri"));
            this.cleaner_$eq(new MetadataCleaner(MetadataCleanerType$.MODULE$.HTTP_BROADCAST(), (Function1<Object, BoxedUnit>)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final void apply(long cleanupTime) {
                    this.apply$mcVJ$sp(cleanupTime);
                }

                public void apply$mcVJ$sp(long cleanupTime) {
                    HttpBroadcast$.MODULE$.org$apache$spark$broadcast$HttpBroadcast$$cleanup(cleanupTime);
                }
            }, conf));
            this.org$apache$spark$broadcast$HttpBroadcast$$compressionCodec_$eq(CompressionCodec$.MODULE$.createCodec(conf));
            this.initialized_$eq(true);
        }
    }

    public synchronized void stop() {
        if (this.server() != null) {
            this.server().stop();
            this.server_$eq(null);
        }
        if (this.cleaner() != null) {
            this.cleaner().cancel();
            this.cleaner_$eq(null);
        }
        this.org$apache$spark$broadcast$HttpBroadcast$$compressionCodec_$eq(null);
        this.initialized_$eq(false);
    }

    private void createServer(SparkConf conf) {
        this.broadcastDir_$eq(Utils$.MODULE$.createTempDir(Utils$.MODULE$.getLocalDir(conf), "broadcast"));
        int broadcastPort = conf.getInt("spark.broadcast.port", 0);
        this.server_$eq(new HttpServer(conf, this.broadcastDir(), this.securityManager(), broadcastPort, "HTTP broadcast server"));
        this.server().start();
        this.org$apache$spark$broadcast$HttpBroadcast$$serverUri_$eq(this.server().uri());
        this.logInfo((Function0<String>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return new StringBuilder().append((Object)"Broadcast server started at ").append((Object)HttpBroadcast$.MODULE$.org$apache$spark$broadcast$HttpBroadcast$$serverUri()).toString();
            }
        });
    }

    public File getFile(long id) {
        return new File(this.broadcastDir(), new BroadcastBlockId(id, BroadcastBlockId$.MODULE$.apply$default$2()).name());
    }

    public void org$apache$spark$broadcast$HttpBroadcast$$write(long id, Object value) {
        File file = this.getFile(id);
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        Utils$.MODULE$.tryWithSafeFinally(new Serializable(value, file, fileOutputStream){
            public static final long serialVersionUID = 0L;
            public final Object value$1;
            private final File file$1;
            private final FileOutputStream fileOutputStream$1;

            public final TimeStampedHashSet<File> apply() {
                OutputStream out = HttpBroadcast$.MODULE$.org$apache$spark$broadcast$HttpBroadcast$$compress() ? HttpBroadcast$.MODULE$.org$apache$spark$broadcast$HttpBroadcast$$compressionCodec().compressedOutputStream(this.fileOutputStream$1) : new BufferedOutputStream(this.fileOutputStream$1, HttpBroadcast$.MODULE$.org$apache$spark$broadcast$HttpBroadcast$$bufferSize());
                SerializerInstance ser = SparkEnv$.MODULE$.get().serializer().newInstance();
                SerializationStream serOut = ser.serializeStream(out);
                Utils$.MODULE$.tryWithSafeFinally(new Serializable(this, serOut){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun$org$apache$spark$broadcast$HttpBroadcast$$write$2 $outer;
                    private final SerializationStream serOut$1;

                    public final SerializationStream apply() {
                        return this.serOut$1.writeObject(this.$outer.value$1, ClassTag$.MODULE$.Any());
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.serOut$1 = serOut$1;
                    }
                }, (Function0<BoxedUnit>)new Serializable(this, serOut){
                    public static final long serialVersionUID = 0L;
                    private final SerializationStream serOut$1;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.serOut$1.close();
                    }
                    {
                        this.serOut$1 = serOut$1;
                    }
                });
                return HttpBroadcast$.MODULE$.org$apache$spark$broadcast$HttpBroadcast$$files().$plus$eq(this.file$1);
            }
            {
                this.value$1 = value$1;
                this.file$1 = file$1;
                this.fileOutputStream$1 = fileOutputStream$1;
            }
        }, (Function0<BoxedUnit>)new Serializable(fileOutputStream){
            public static final long serialVersionUID = 0L;
            private final FileOutputStream fileOutputStream$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.fileOutputStream$1.close();
            }
            {
                this.fileOutputStream$1 = fileOutputStream$1;
            }
        });
    }

    public <T> T org$apache$spark$broadcast$HttpBroadcast$$read(long id, ClassTag<T> evidence$2) {
        this.logDebug((Function0<String>)new Serializable(id){
            public static final long serialVersionUID = 0L;
            private final long id$1;

            public final String apply() {
                return new StringBuilder().append((Object)"broadcast read server: ").append((Object)HttpBroadcast$.MODULE$.org$apache$spark$broadcast$HttpBroadcast$$serverUri()).append((Object)" id: broadcast-").append((Object)BoxesRunTime.boxToLong((long)this.id$1)).toString();
            }
            {
                this.id$1 = id$1;
            }
        });
        String url = new StringBuilder().append((Object)this.org$apache$spark$broadcast$HttpBroadcast$$serverUri()).append((Object)"/").append((Object)new BroadcastBlockId(id, BroadcastBlockId$.MODULE$.apply$default$2()).name()).toString();
        URLConnection uc = null;
        if (this.securityManager().isAuthenticationEnabled()) {
            this.logDebug((Function0<String>)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "broadcast security enabled";
                }
            });
            URI newuri = Utils$.MODULE$.constructURIForAuthentication(new URI(url), this.securityManager());
            uc = newuri.toURL().openConnection();
            uc.setConnectTimeout(this.httpReadTimeout());
            uc.setAllowUserInteraction(false);
        } else {
            this.logDebug((Function0<String>)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "broadcast not using security";
                }
            });
            uc = new URL(url).openConnection();
            uc.setConnectTimeout(this.httpReadTimeout());
        }
        Utils$.MODULE$.setupSecureURLConnection(uc, this.securityManager());
        uc.setReadTimeout(this.httpReadTimeout());
        InputStream inputStream = uc.getInputStream();
        InputStream in = this.org$apache$spark$broadcast$HttpBroadcast$$compress() ? this.org$apache$spark$broadcast$HttpBroadcast$$compressionCodec().compressedInputStream(inputStream) : new BufferedInputStream(inputStream, this.org$apache$spark$broadcast$HttpBroadcast$$bufferSize());
        SerializerInstance ser = SparkEnv$.MODULE$.get().serializer().newInstance();
        DeserializationStream serIn = ser.deserializeStream(in);
        return Utils$.MODULE$.tryWithSafeFinally(new Serializable(evidence$2, serIn){
            public static final long serialVersionUID = 0L;
            private final ClassTag evidence$2$1;
            private final DeserializationStream serIn$1;

            public final T apply() {
                return this.serIn$1.readObject(this.evidence$2$1);
            }
            {
                this.evidence$2$1 = evidence$2$1;
                this.serIn$1 = serIn$1;
            }
        }, (Function0<BoxedUnit>)new Serializable(serIn){
            public static final long serialVersionUID = 0L;
            private final DeserializationStream serIn$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.serIn$1.close();
            }
            {
                this.serIn$1 = serIn$1;
            }
        });
    }

    public synchronized void unpersist(long id, boolean removeFromDriver, boolean blocking) {
        SparkEnv$.MODULE$.get().blockManager().master().removeBroadcast(id, removeFromDriver, blocking);
        if (removeFromDriver) {
            File file = this.getFile(id);
            this.org$apache$spark$broadcast$HttpBroadcast$$files().remove(file);
            this.deleteBroadcastFile(file);
        }
    }

    public void org$apache$spark$broadcast$HttpBroadcast$$cleanup(long cleanupTime) {
        Iterator<Map.Entry<File, Object>> iterator2 = this.org$apache$spark$broadcast$HttpBroadcast$$files().internalMap().entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<File, Object> entry = iterator2.next();
            Tuple2 tuple2 = new Tuple2((Object)entry.getKey(), entry.getValue());
            if (tuple2 != null) {
                Tuple2 tuple22;
                File file = (File)tuple2._1();
                long time = tuple2._2$mcJ$sp();
                Tuple2 tuple23 = tuple22 = new Tuple2((Object)file, (Object)BoxesRunTime.boxToLong((long)time));
                File file2 = (File)tuple23._1();
                long time2 = tuple23._2$mcJ$sp();
                if (time2 >= cleanupTime) continue;
                iterator2.remove();
                this.deleteBroadcastFile(file2);
                continue;
            }
            throw new MatchError((Object)tuple2);
        }
    }

    private void deleteBroadcastFile(File file) {
        try {
            if (file.exists()) {
                if (file.delete()) {
                    this.logInfo((Function0<String>)new Serializable(file){
                        public static final long serialVersionUID = 0L;
                        private final File file$2;

                        public final String apply() {
                            return new StringOps(Predef$.MODULE$.augmentString("Deleted broadcast file: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.file$2}));
                        }
                        {
                            this.file$2 = file$2;
                        }
                    });
                } else {
                    this.logWarning((Function0<String>)new Serializable(file){
                        public static final long serialVersionUID = 0L;
                        private final File file$2;

                        public final String apply() {
                            return new StringOps(Predef$.MODULE$.augmentString("Could not delete broadcast file: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.file$2}));
                        }
                        {
                            this.file$2 = file$2;
                        }
                    });
                }
            }
        }
        catch (Exception exception2) {
            this.logError((Function0<String>)new Serializable(file){
                public static final long serialVersionUID = 0L;
                private final File file$2;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("Exception while deleting broadcast file: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.file$2}));
                }
                {
                    this.file$2 = file$2;
                }
            }, exception2);
        }
    }

    private Object readResolve() {
        return MODULE$;
    }

    private HttpBroadcast$() {
        MODULE$ = this;
        Logging$class.$init$(this);
        this.initialized = false;
        this.broadcastDir = null;
        this.org$apache$spark$broadcast$HttpBroadcast$$compress = false;
        this.org$apache$spark$broadcast$HttpBroadcast$$bufferSize = 65536;
        this.org$apache$spark$broadcast$HttpBroadcast$$serverUri = null;
        this.server = null;
        this.securityManager = null;
        this.org$apache$spark$broadcast$HttpBroadcast$$files = new TimeStampedHashSet();
        this.httpReadTimeout = (int)TimeUnit.MILLISECONDS.convert(5L, TimeUnit.MINUTES);
        this.org$apache$spark$broadcast$HttpBroadcast$$compressionCodec = null;
        this.cleaner = null;
    }
}

