/*
 * Decompiled with CFR 0.152.
 */
package org.spark-project.guava.cache;

import java.util.concurrent.ExecutionException;
import org.spark-project.guava.annotations.Beta;
import org.spark-project.guava.base.Preconditions;
import org.spark-project.guava.cache.ForwardingCache;
import org.spark-project.guava.cache.LoadingCache;
import org.spark-project.guava.collect.ImmutableMap;

@Beta
public abstract class ForwardingLoadingCache<K, V>
extends ForwardingCache<K, V>
implements LoadingCache<K, V> {
    protected ForwardingLoadingCache() {
    }

    @Override
    protected abstract LoadingCache<K, V> delegate();

    @Override
    public V get(K key) throws ExecutionException {
        return this.delegate().get(key);
    }

    @Override
    public V getUnchecked(K key) {
        return this.delegate().getUnchecked(key);
    }

    @Override
    public ImmutableMap<K, V> getAll(Iterable<? extends K> keys) throws ExecutionException {
        return this.delegate().getAll(keys);
    }

    @Override
    public V apply(K key) {
        return this.delegate().apply(key);
    }

    @Override
    public void refresh(K key) {
        this.delegate().refresh(key);
    }

    @Beta
    public static abstract class SimpleForwardingLoadingCache<K, V>
    extends ForwardingLoadingCache<K, V> {
        private final LoadingCache<K, V> delegate;

        protected SimpleForwardingLoadingCache(LoadingCache<K, V> delegate) {
            this.delegate = Preconditions.checkNotNull(delegate);
        }

        @Override
        protected final LoadingCache<K, V> delegate() {
            return this.delegate;
        }
    }
}

