/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network.server;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.timeout.IdleState;
import io.netty.handler.timeout.IdleStateEvent;
import org.apache.spark.network.client.TransportClient;
import org.apache.spark.network.client.TransportResponseHandler;
import org.apache.spark.network.protocol.Message;
import org.apache.spark.network.protocol.RequestMessage;
import org.apache.spark.network.protocol.ResponseMessage;
import org.apache.spark.network.server.TransportRequestHandler;
import org.apache.spark.network.util.NettyUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransportChannelHandler
extends SimpleChannelInboundHandler<Message> {
    private final Logger logger = LoggerFactory.getLogger(TransportChannelHandler.class);
    private final TransportClient client;
    private final TransportResponseHandler responseHandler;
    private final TransportRequestHandler requestHandler;
    private final long requestTimeoutNs;
    private final boolean closeIdleConnections;

    public TransportChannelHandler(TransportClient client, TransportResponseHandler responseHandler, TransportRequestHandler requestHandler, long requestTimeoutMs, boolean closeIdleConnections) {
        this.client = client;
        this.responseHandler = responseHandler;
        this.requestHandler = requestHandler;
        this.requestTimeoutNs = requestTimeoutMs * 1000L * 1000L;
        this.closeIdleConnections = closeIdleConnections;
    }

    public TransportClient getClient() {
        return this.client;
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        this.logger.warn("Exception in connection from " + NettyUtils.getRemoteAddress(ctx.channel()), cause);
        this.requestHandler.exceptionCaught(cause);
        this.responseHandler.exceptionCaught(cause);
        ctx.close();
    }

    public void channelUnregistered(ChannelHandlerContext ctx) throws Exception {
        try {
            this.requestHandler.channelUnregistered();
        }
        catch (RuntimeException e) {
            this.logger.error("Exception from request handler while unregistering channel", (Throwable)e);
        }
        try {
            this.responseHandler.channelUnregistered();
        }
        catch (RuntimeException e) {
            this.logger.error("Exception from response handler while unregistering channel", (Throwable)e);
        }
        super.channelUnregistered(ctx);
    }

    public void channelRead0(ChannelHandlerContext ctx, Message request) throws Exception {
        if (request instanceof RequestMessage) {
            this.requestHandler.handle((RequestMessage)request);
        } else {
            this.responseHandler.handle((ResponseMessage)request);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof IdleStateEvent) {
            IdleStateEvent e = (IdleStateEvent)evt;
            TransportChannelHandler transportChannelHandler = this;
            synchronized (transportChannelHandler) {
                boolean isActuallyOverdue;
                boolean bl = isActuallyOverdue = System.nanoTime() - this.responseHandler.getTimeOfLastRequestNs() > this.requestTimeoutNs;
                if (e.state() == IdleState.ALL_IDLE && isActuallyOverdue) {
                    if (this.responseHandler.numOutstandingRequests() > 0) {
                        String address = NettyUtils.getRemoteAddress(ctx.channel());
                        this.logger.error("Connection to {} has been quiet for {} ms while there are outstanding requests. Assuming connection is dead; please adjust spark.network.timeout if this is wrong.", (Object)address, (Object)(this.requestTimeoutNs / 1000L / 1000L));
                        this.client.timeOut();
                        ctx.close();
                    } else if (this.closeIdleConnections) {
                        this.client.timeOut();
                        ctx.close();
                    }
                }
            }
        }
        ctx.fireUserEventTriggered(evt);
    }

    public TransportResponseHandler getResponseHandler() {
        return this.responseHandler;
    }
}

