/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.util.shell;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import jline.Completor;
import jline.ConsoleReader;
import jline.History;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.ZooKeeperInstance;
import org.apache.accumulo.core.client.mock.MockInstance;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.client.security.tokens.PasswordToken;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.data.thrift.TConstraintViolationSummary;
import org.apache.accumulo.core.security.AuditLevel;
import org.apache.accumulo.core.tabletserver.thrift.ConstraintViolationException;
import org.apache.accumulo.core.trace.DistributedTrace;
import org.apache.accumulo.core.util.BadArgumentException;
import org.apache.accumulo.core.util.format.BinaryFormatter;
import org.apache.accumulo.core.util.format.DefaultFormatter;
import org.apache.accumulo.core.util.format.Formatter;
import org.apache.accumulo.core.util.format.FormatterFactory;
import org.apache.accumulo.core.util.shell.ShellCompletor;
import org.apache.accumulo.core.util.shell.ShellOptions;
import org.apache.accumulo.core.util.shell.Token;
import org.apache.accumulo.core.util.shell.commands.AboutCommand;
import org.apache.accumulo.core.util.shell.commands.AddAuthsCommand;
import org.apache.accumulo.core.util.shell.commands.AddSplitsCommand;
import org.apache.accumulo.core.util.shell.commands.AuthenticateCommand;
import org.apache.accumulo.core.util.shell.commands.ByeCommand;
import org.apache.accumulo.core.util.shell.commands.ClasspathCommand;
import org.apache.accumulo.core.util.shell.commands.ClearCommand;
import org.apache.accumulo.core.util.shell.commands.CloneTableCommand;
import org.apache.accumulo.core.util.shell.commands.ClsCommand;
import org.apache.accumulo.core.util.shell.commands.CompactCommand;
import org.apache.accumulo.core.util.shell.commands.ConfigCommand;
import org.apache.accumulo.core.util.shell.commands.ConstraintCommand;
import org.apache.accumulo.core.util.shell.commands.CreateTableCommand;
import org.apache.accumulo.core.util.shell.commands.CreateUserCommand;
import org.apache.accumulo.core.util.shell.commands.DUCommand;
import org.apache.accumulo.core.util.shell.commands.DebugCommand;
import org.apache.accumulo.core.util.shell.commands.DeleteCommand;
import org.apache.accumulo.core.util.shell.commands.DeleteIterCommand;
import org.apache.accumulo.core.util.shell.commands.DeleteManyCommand;
import org.apache.accumulo.core.util.shell.commands.DeleteRowsCommand;
import org.apache.accumulo.core.util.shell.commands.DeleteScanIterCommand;
import org.apache.accumulo.core.util.shell.commands.DeleteShellIterCommand;
import org.apache.accumulo.core.util.shell.commands.DeleteTableCommand;
import org.apache.accumulo.core.util.shell.commands.DeleteUserCommand;
import org.apache.accumulo.core.util.shell.commands.DropTableCommand;
import org.apache.accumulo.core.util.shell.commands.DropUserCommand;
import org.apache.accumulo.core.util.shell.commands.EGrepCommand;
import org.apache.accumulo.core.util.shell.commands.ExecfileCommand;
import org.apache.accumulo.core.util.shell.commands.ExitCommand;
import org.apache.accumulo.core.util.shell.commands.ExportTableCommand;
import org.apache.accumulo.core.util.shell.commands.FlushCommand;
import org.apache.accumulo.core.util.shell.commands.FormatterCommand;
import org.apache.accumulo.core.util.shell.commands.GetAuthsCommand;
import org.apache.accumulo.core.util.shell.commands.GetGroupsCommand;
import org.apache.accumulo.core.util.shell.commands.GetSplitsCommand;
import org.apache.accumulo.core.util.shell.commands.GrantCommand;
import org.apache.accumulo.core.util.shell.commands.GrepCommand;
import org.apache.accumulo.core.util.shell.commands.HelpCommand;
import org.apache.accumulo.core.util.shell.commands.HiddenCommand;
import org.apache.accumulo.core.util.shell.commands.HistoryCommand;
import org.apache.accumulo.core.util.shell.commands.ImportDirectoryCommand;
import org.apache.accumulo.core.util.shell.commands.ImportTableCommand;
import org.apache.accumulo.core.util.shell.commands.InfoCommand;
import org.apache.accumulo.core.util.shell.commands.InsertCommand;
import org.apache.accumulo.core.util.shell.commands.InterpreterCommand;
import org.apache.accumulo.core.util.shell.commands.ListCompactionsCommand;
import org.apache.accumulo.core.util.shell.commands.ListIterCommand;
import org.apache.accumulo.core.util.shell.commands.ListScansCommand;
import org.apache.accumulo.core.util.shell.commands.ListShellIterCommand;
import org.apache.accumulo.core.util.shell.commands.MaxRowCommand;
import org.apache.accumulo.core.util.shell.commands.MergeCommand;
import org.apache.accumulo.core.util.shell.commands.NoTableCommand;
import org.apache.accumulo.core.util.shell.commands.OfflineCommand;
import org.apache.accumulo.core.util.shell.commands.OnlineCommand;
import org.apache.accumulo.core.util.shell.commands.PasswdCommand;
import org.apache.accumulo.core.util.shell.commands.PingCommand;
import org.apache.accumulo.core.util.shell.commands.QuestionCommand;
import org.apache.accumulo.core.util.shell.commands.QuitCommand;
import org.apache.accumulo.core.util.shell.commands.QuotedStringTokenizer;
import org.apache.accumulo.core.util.shell.commands.RenameTableCommand;
import org.apache.accumulo.core.util.shell.commands.RevokeCommand;
import org.apache.accumulo.core.util.shell.commands.ScanCommand;
import org.apache.accumulo.core.util.shell.commands.SetAuthsCommand;
import org.apache.accumulo.core.util.shell.commands.SetGroupsCommand;
import org.apache.accumulo.core.util.shell.commands.SetIterCommand;
import org.apache.accumulo.core.util.shell.commands.SetScanIterCommand;
import org.apache.accumulo.core.util.shell.commands.SetShellIterCommand;
import org.apache.accumulo.core.util.shell.commands.SleepCommand;
import org.apache.accumulo.core.util.shell.commands.SystemPermissionsCommand;
import org.apache.accumulo.core.util.shell.commands.TableCommand;
import org.apache.accumulo.core.util.shell.commands.TablePermissionsCommand;
import org.apache.accumulo.core.util.shell.commands.TablesCommand;
import org.apache.accumulo.core.util.shell.commands.TraceCommand;
import org.apache.accumulo.core.util.shell.commands.UserCommand;
import org.apache.accumulo.core.util.shell.commands.UserPermissionsCommand;
import org.apache.accumulo.core.util.shell.commands.UsersCommand;
import org.apache.accumulo.core.util.shell.commands.WhoAmICommand;
import org.apache.accumulo.fate.zookeeper.ZooReader;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.MissingArgumentException;
import org.apache.commons.cli.MissingOptionException;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.hadoop.fs.Path;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class Shell
extends ShellOptions {
    public static final Logger log = Logger.getLogger(Shell.class);
    private static final Logger audit = Logger.getLogger((String)(Shell.class.getName() + ".audit"));
    public static final String CHARSET = "ISO-8859-1";
    public static final int NO_FIXED_ARG_LENGTH_CHECK = -1;
    private static final String SHELL_DESCRIPTION = "Shell - Apache Accumulo Interactive Shell";
    private static final String DEFAULT_AUTH_TIMEOUT = "60";
    protected int exitCode = 0;
    private String tableName;
    protected Instance instance;
    private Connector connector;
    protected ConsoleReader reader;
    private String principal;
    private AuthenticationToken token;
    private final Class<? extends Formatter> defaultFormatterClass = DefaultFormatter.class;
    private final Class<? extends Formatter> binaryFormatterClass = BinaryFormatter.class;
    public Map<String, List<IteratorSetting>> scanIteratorOptions = new HashMap<String, List<IteratorSetting>>();
    public Map<String, List<IteratorSetting>> iteratorProfiles = new HashMap<String, List<IteratorSetting>>();
    private Token rootToken;
    public final Map<String, Command> commandFactory = new TreeMap<String, Command>();
    public final Map<String, Command[]> commandGrouping = new TreeMap<String, Command[]>();
    protected boolean configError = false;
    private boolean exit = false;
    protected String execFile = null;
    protected String execCommand = null;
    protected boolean verbose = true;
    private boolean tabCompletion;
    private boolean disableAuthTimeout;
    private long authTimeout;
    private long lastUserActivity = System.currentTimeMillis();
    private boolean logErrorsToConsole = false;
    private PrintWriter writer = null;
    private boolean masking = false;

    public Shell() throws IOException {
        this(new ConsoleReader());
    }

    public Shell(ConsoleReader reader) {
        this.reader = reader;
    }

    public Shell(ConsoleReader reader, PrintWriter writer) {
        this(reader);
        this.writer = writer;
    }

    public boolean config(String ... args) {
        CommandLine cl;
        try {
            cl = new BasicParser().parse(this.opts, args);
            if (cl.getArgs().length > 0) {
                throw new ParseException("Unrecognized arguments: " + cl.getArgList());
            }
            if (cl.hasOption(this.helpOpt.getOpt())) {
                this.configError = true;
                this.printHelp("shell", SHELL_DESCRIPTION, this.opts);
                return true;
            }
            Shell.setDebugging(cl.hasOption(this.debugOption.getLongOpt()));
            this.authTimeout = Integer.parseInt(cl.getOptionValue(this.authTimeoutOpt.getLongOpt(), DEFAULT_AUTH_TIMEOUT)) * 60 * 1000;
            this.disableAuthTimeout = cl.hasOption(this.disableAuthTimeoutOpt.getLongOpt());
            if (cl.hasOption(this.zooKeeperInstance.getOpt()) && cl.getOptionValues(this.zooKeeperInstance.getOpt()).length != 2) {
                throw new MissingArgumentException(this.zooKeeperInstance);
            }
        }
        catch (Exception e) {
            this.configError = true;
            this.printException(e);
            this.printHelp("shell", SHELL_DESCRIPTION, this.opts);
            return true;
        }
        String sysUser = System.getProperty("user.name");
        if (sysUser == null) {
            sysUser = "root";
        }
        String user = cl.getOptionValue(this.usernameOption.getOpt(), sysUser);
        String passw = cl.getOptionValue(this.passwOption.getOpt(), null);
        this.tabCompletion = !cl.hasOption(this.tabCompleteOption.getLongOpt());
        String[] loginOptions = cl.getOptionValues(this.loginOption.getOpt());
        this.setInstance(cl);
        try {
            if (loginOptions != null && !cl.hasOption(this.tokenOption.getOpt())) {
                throw new IllegalArgumentException("Must supply '-" + this.tokenOption.getOpt() + "' option with '-" + this.loginOption.getOpt() + "' option");
            }
            if (loginOptions == null && cl.hasOption(this.tokenOption.getOpt())) {
                throw new IllegalArgumentException("Must supply '-" + this.loginOption.getOpt() + "' option with '-" + this.tokenOption.getOpt() + "' option");
            }
            if (passw != null && cl.hasOption(this.tokenOption.getOpt())) {
                throw new IllegalArgumentException("Can not supply '-" + this.passwOption.getOpt() + "' option with '-" + this.tokenOption.getOpt() + "' option");
            }
            if (user == null) {
                throw new MissingArgumentException(this.usernameOption);
            }
            if (loginOptions != null && cl.hasOption(this.tokenOption.getOpt())) {
                AuthenticationToken.Properties props = new AuthenticationToken.Properties();
                for (String loginOption : loginOptions) {
                    for (String lo : loginOption.split(",")) {
                        String[] split = lo.split("=");
                        props.put(split[0], split[1]);
                    }
                }
                this.token = Class.forName(cl.getOptionValue(this.tokenOption.getOpt())).asSubclass(AuthenticationToken.class).newInstance();
                this.token.init(props);
            }
            if (!cl.hasOption(this.fakeOption.getLongOpt())) {
                DistributedTrace.enable(this.instance, new ZooReader(this.instance.getZooKeepers(), this.instance.getZooKeepersSessionTimeOut()), "shell", InetAddress.getLocalHost().getHostName());
            }
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void start() {
                    Shell.this.reader.getTerminal().enableEcho();
                }
            });
            if (passw != null) {
                this.token = new PasswordToken(passw);
            }
            if (this.token == null && (passw = this.readMaskedLine("Password: ", Character.valueOf('*'))) != null) {
                this.token = new PasswordToken(passw);
            }
            if (this.token == null) {
                this.reader.printNewline();
                throw new MissingArgumentException("No password or token option supplied");
            }
            this.setTableName("");
            this.principal = user;
            this.connector = this.instance.getConnector(this.principal, this.token);
        }
        catch (Exception e) {
            this.printException(e);
            this.configError = true;
        }
        if (cl.hasOption(this.execfileOption.getOpt())) {
            this.execFile = cl.getOptionValue(this.execfileOption.getOpt());
            this.verbose = false;
        } else if (cl.hasOption(this.execfileVerboseOption.getOpt())) {
            this.execFile = cl.getOptionValue(this.execfileVerboseOption.getOpt());
        }
        if (cl.hasOption(this.execCommandOpt.getOpt())) {
            this.execCommand = cl.getOptionValue(this.execCommandOpt.getOpt());
            this.verbose = false;
        }
        this.rootToken = new Token();
        Command[] dataCommands = new Command[]{new DeleteCommand(), new DeleteManyCommand(), new DeleteRowsCommand(), new EGrepCommand(), new FormatterCommand(), new InterpreterCommand(), new GrepCommand(), new ImportDirectoryCommand(), new InsertCommand(), new MaxRowCommand(), new ScanCommand()};
        Command[] debuggingCommands = new Command[]{new ClasspathCommand(), new DebugCommand(), new ListScansCommand(), new ListCompactionsCommand(), new TraceCommand(), new PingCommand()};
        Command[] execCommands = new Command[]{new ExecfileCommand(), new HistoryCommand()};
        Command[] exitCommands = new Command[]{new ByeCommand(), new ExitCommand(), new QuitCommand()};
        Command[] helpCommands = new Command[]{new AboutCommand(), new HelpCommand(), new InfoCommand(), new QuestionCommand()};
        Command[] iteratorCommands = new Command[]{new DeleteIterCommand(), new DeleteScanIterCommand(), new ListIterCommand(), new SetIterCommand(), new SetScanIterCommand(), new SetShellIterCommand(), new ListShellIterCommand(), new DeleteShellIterCommand()};
        Command[] otherCommands = new Command[]{new HiddenCommand()};
        Command[] permissionsCommands = new Command[]{new GrantCommand(), new RevokeCommand(), new SystemPermissionsCommand(), new TablePermissionsCommand(), new UserPermissionsCommand()};
        Command[] stateCommands = new Command[]{new AuthenticateCommand(), new ClsCommand(), new ClearCommand(), new NoTableCommand(), new SleepCommand(), new TableCommand(), new UserCommand(), new WhoAmICommand()};
        Command[] tableCommands = new Command[]{new CloneTableCommand(), new ConfigCommand(), new CreateTableCommand(), new DeleteTableCommand(), new DropTableCommand(), new DUCommand(), new ExportTableCommand(), new ImportTableCommand(), new OfflineCommand(), new OnlineCommand(), new RenameTableCommand(), new TablesCommand()};
        Command[] tableControlCommands = new Command[]{new AddSplitsCommand(), new CompactCommand(), new ConstraintCommand(), new FlushCommand(), new GetGroupsCommand(), new GetSplitsCommand(), new MergeCommand(), new SetGroupsCommand()};
        Command[] userCommands = new Command[]{new AddAuthsCommand(), new CreateUserCommand(), new DeleteUserCommand(), new DropUserCommand(), new GetAuthsCommand(), new PasswdCommand(), new SetAuthsCommand(), new UsersCommand()};
        this.commandGrouping.put("-- Writing, Reading, and Removing Data --", dataCommands);
        this.commandGrouping.put("-- Debugging Commands -------------------", debuggingCommands);
        this.commandGrouping.put("-- Shell Execution Commands -------------", execCommands);
        this.commandGrouping.put("-- Exiting Commands ---------------------", exitCommands);
        this.commandGrouping.put("-- Help Commands ------------------------", helpCommands);
        this.commandGrouping.put("-- Iterator Configuration ---------------", iteratorCommands);
        this.commandGrouping.put("-- Permissions Administration Commands --", permissionsCommands);
        this.commandGrouping.put("-- Shell State Commands -----------------", stateCommands);
        this.commandGrouping.put("-- Table Administration Commands --------", tableCommands);
        this.commandGrouping.put("-- Table Control Commands ---------------", tableControlCommands);
        this.commandGrouping.put("-- User Administration Commands ---------", userCommands);
        for (Command[] cmds : this.commandGrouping.values()) {
            for (Command cmd : cmds) {
                this.commandFactory.put(cmd.getName(), cmd);
            }
        }
        for (Command cmd : otherCommands) {
            this.commandFactory.put(cmd.getName(), cmd);
        }
        return this.configError;
    }

    protected void setInstance(CommandLine cl) {
        this.instance = null;
        if (cl.hasOption(this.fakeOption.getLongOpt())) {
            this.instance = new MockInstance("fake");
        } else if (cl.hasOption(this.hdfsZooInstance.getOpt())) {
            AccumuloConfiguration deprecatedSiteConfiguration = AccumuloConfiguration.getSiteConfiguration();
            this.instance = Shell.getDefaultInstance(deprecatedSiteConfiguration);
        } else if (cl.hasOption(this.zooKeeperInstance.getOpt())) {
            String[] zkOpts = cl.getOptionValues(this.zooKeeperInstance.getOpt());
            this.instance = new ZooKeeperInstance(zkOpts[0], zkOpts[1]);
        } else {
            AccumuloConfiguration deprecatedSiteConfiguration = AccumuloConfiguration.getSiteConfiguration();
            this.instance = Shell.getDefaultInstance(deprecatedSiteConfiguration);
        }
    }

    private static Instance getDefaultInstance(AccumuloConfiguration conf) {
        String keepers = conf.get(Property.INSTANCE_ZK_HOST);
        Path instanceDir = new Path(conf.get(Property.INSTANCE_DFS_DIR), "instance_id");
        return new ZooKeeperInstance(UUID.fromString(ZooKeeperInstance.getInstanceIDFromHdfs(instanceDir)), keepers);
    }

    public Connector getConnector() {
        return this.connector;
    }

    public static void main(String[] args) throws IOException {
        Shell shell = new Shell();
        shell.config(args);
        System.exit(shell.start());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int start() throws IOException {
        String home;
        if (this.configError) {
            return 1;
        }
        if (this.isVerbose()) {
            this.printInfo();
        }
        if ((home = System.getProperty("HOME")) == null) {
            home = System.getenv("HOME");
        }
        String configDir = home + "/.accumulo";
        String historyPath = configDir + "/shell_history.txt";
        File accumuloDir = new File(configDir);
        if (!accumuloDir.exists() && !accumuloDir.mkdirs()) {
            log.warn((Object)("Unable to make directory for history at " + accumuloDir));
        }
        try {
            History history = new History();
            history.setHistoryFile(new File(historyPath));
            this.reader.setHistory(history);
        }
        catch (IOException e) {
            log.warn((Object)("Unable to load history file at " + historyPath));
        }
        ShellCompletor userCompletor = null;
        if (this.execFile != null) {
            Scanner scanner = new Scanner(new File(this.execFile));
            try {
                while (scanner.hasNextLine() && !this.hasExited()) {
                    this.execCommand(scanner.nextLine(), true, this.isVerbose());
                }
            }
            finally {
                scanner.close();
            }
        } else if (this.execCommand != null) {
            for (String command : this.execCommand.split("\n")) {
                this.execCommand(command, true, this.isVerbose());
            }
            return this.exitCode;
        }
        while (!this.hasExited()) {
            if (this.tabCompletion) {
                if (userCompletor != null) {
                    this.reader.removeCompletor((Completor)userCompletor);
                }
                userCompletor = this.setupCompletion();
                this.reader.addCompletor((Completor)userCompletor);
            }
            this.reader.setDefaultPrompt(this.getDefaultPrompt());
            String input = this.reader.readLine();
            if (input == null) {
                this.reader.printNewline();
                return this.exitCode;
            }
            this.execCommand(input, this.disableAuthTimeout, false);
        }
        return this.exitCode;
    }

    public void printInfo() throws IOException {
        this.reader.printString("\nShell - Apache Accumulo Interactive Shell\n- \n- version: 1.5.0\n- instance name: " + this.connector.getInstance().getInstanceName() + "\n" + "- instance id: " + this.connector.getInstance().getInstanceID() + "\n" + "- \n" + "- type 'help' for a list of available commands\n" + "- \n");
        this.reader.flushConsole();
    }

    public void printVerboseInfo() throws IOException {
        StringBuilder sb = new StringBuilder("-\n");
        sb.append("- Current user: ").append(this.connector.whoami()).append("\n");
        if (this.execFile != null) {
            sb.append("- Executing commands from: ").append(this.execFile).append("\n");
        }
        if (this.disableAuthTimeout) {
            sb.append("- Authorization timeout: disabled\n");
        } else {
            sb.append("- Authorization timeout: ").append(String.format("%.2fs%n", (double)this.authTimeout / 1000.0));
        }
        sb.append("- Debug: ").append(Shell.isDebuggingEnabled() ? "on" : "off").append("\n");
        if (!this.scanIteratorOptions.isEmpty()) {
            for (Map.Entry<String, List<IteratorSetting>> entry : this.scanIteratorOptions.entrySet()) {
                sb.append("- Session scan iterators for table ").append(entry.getKey()).append(":\n");
                for (IteratorSetting setting : entry.getValue()) {
                    sb.append("-    Iterator ").append(setting.getName()).append(" options:\n");
                    sb.append("-        ").append("iteratorPriority").append(" = ").append(setting.getPriority()).append("\n");
                    sb.append("-        ").append("iteratorClassName").append(" = ").append(setting.getIteratorClass()).append("\n");
                    for (Map.Entry<String, String> optEntry : setting.getOptions().entrySet()) {
                        sb.append("-        ").append(optEntry.getKey()).append(" = ").append(optEntry.getValue()).append("\n");
                    }
                }
            }
        }
        sb.append("-\n");
        this.reader.printString(sb.toString());
    }

    public String getDefaultPrompt() {
        return this.connector.whoami() + "@" + this.connector.getInstance().getInstanceName() + (this.getTableName().isEmpty() ? "" : " ") + this.getTableName() + "> ";
    }

    public void execCommand(String input, boolean ignoreAuthTimeout, boolean echoPrompt) throws IOException {
        block22: {
            String[] fields;
            audit.log((Priority)AuditLevel.AUDIT, (Object)(this.getDefaultPrompt() + input));
            if (echoPrompt) {
                this.reader.printString(this.getDefaultPrompt());
                this.reader.printString(input);
                this.reader.printNewline();
            }
            try {
                fields = new QuotedStringTokenizer(input).getTokens();
            }
            catch (BadArgumentException e) {
                this.printException(e);
                ++this.exitCode;
                return;
            }
            if (fields.length == 0) {
                return;
            }
            String command = fields[0];
            fields = fields.length > 1 ? Arrays.copyOfRange(fields, 1, fields.length) : new String[]{};
            Command sc = null;
            if (command.length() > 0) {
                try {
                    sc = this.commandFactory.get(command);
                    if (sc == null) {
                        this.reader.printString(String.format("Unknown command \"%s\".  Enter \"help\" for a list possible commands.\n", command));
                        this.reader.flushConsole();
                        return;
                    }
                    if (!(sc instanceof ExitCommand) && !ignoreAuthTimeout && System.currentTimeMillis() - this.lastUserActivity > this.authTimeout) {
                        this.reader.printString("Shell has been idle for too long. Please re-authenticate.\n");
                        boolean authFailed = true;
                        do {
                            String pwd;
                            if ((pwd = this.readMaskedLine("Enter current password for '" + this.connector.whoami() + "': ", Character.valueOf('*'))) == null) {
                                this.reader.printNewline();
                                return;
                            }
                            try {
                                authFailed = !this.connector.securityOperations().authenticateUser(this.connector.whoami(), new PasswordToken(pwd));
                            }
                            catch (Exception e) {
                                ++this.exitCode;
                                this.printException(e);
                            }
                            if (!authFailed) continue;
                            this.reader.printString("Invalid password. ");
                        } while (authFailed);
                        this.lastUserActivity = System.currentTimeMillis();
                    }
                    Options parseOpts = sc.getOptionsWithHelp();
                    CommandLine cl = new BasicParser().parse(parseOpts, fields);
                    int actualArgLen = cl.getArgs().length;
                    int expectedArgLen = sc.numArgs();
                    if (cl.hasOption("?")) {
                        sc.printHelp(this);
                        break block22;
                    }
                    if (expectedArgLen != -1 && actualArgLen != expectedArgLen) {
                        ++this.exitCode;
                        this.printException(new IllegalArgumentException(String.format("Expected %d argument%s. There %s %d.", expectedArgLen, expectedArgLen == 1 ? "" : "s", actualArgLen == 1 ? "was" : "were", actualArgLen)));
                        sc.printHelp(this);
                        break block22;
                    }
                    int tmpCode = sc.execute(input, cl, this);
                    this.exitCode += tmpCode;
                    this.reader.flushConsole();
                }
                catch (ConstraintViolationException e) {
                    ++this.exitCode;
                    this.printConstraintViolationException(e);
                }
                catch (TableNotFoundException e) {
                    ++this.exitCode;
                    if (this.getTableName().equals(e.getTableName())) {
                        this.setTableName("");
                    }
                    this.printException(e);
                }
                catch (ParseException e) {
                    if (!(e instanceof MissingOptionException) || !Arrays.asList(fields).contains("-?") && !Arrays.asList(fields).contains("--help")) {
                        ++this.exitCode;
                        this.printException((Exception)((Object)e));
                    }
                    if (sc != null) {
                        sc.printHelp(this);
                    }
                }
                catch (Exception e) {
                    ++this.exitCode;
                    this.printException(e);
                }
            } else {
                ++this.exitCode;
                this.printException(new BadArgumentException("Unrecognized empty command", command, -1));
            }
        }
        this.reader.flushConsole();
    }

    private ShellCompletor setupCompletion() {
        this.rootToken = new Token();
        Set<String> tableNames = null;
        try {
            tableNames = this.connector.tableOperations().list();
        }
        catch (Exception e) {
            log.debug((Object)"Unable to obtain list of tables", (Throwable)e);
            tableNames = Collections.emptySet();
        }
        Set<String> userlist = null;
        try {
            userlist = this.connector.securityOperations().listLocalUsers();
        }
        catch (Exception e) {
            log.debug((Object)"Unable to obtain list of users", (Throwable)e);
            userlist = Collections.emptySet();
        }
        HashMap<Command.CompletionSet, Set<String>> options = new HashMap<Command.CompletionSet, Set<String>>();
        HashSet<String> commands = new HashSet<String>();
        for (String a : this.commandFactory.keySet()) {
            commands.add(a);
        }
        HashSet<String> modifiedUserlist = new HashSet<String>();
        HashSet<String> modifiedTablenames = new HashSet<String>();
        for (String a : tableNames) {
            modifiedTablenames.add(a.replaceAll("([\\s'\"])", "\\\\$1"));
        }
        for (String a : userlist) {
            modifiedUserlist.add(a.replaceAll("([\\s'\"])", "\\\\$1"));
        }
        options.put(Command.CompletionSet.USERNAMES, modifiedUserlist);
        options.put(Command.CompletionSet.TABLENAMES, modifiedTablenames);
        options.put(Command.CompletionSet.COMMANDS, commands);
        Iterator<String> i$ = this.commandGrouping.values().iterator();
        while (i$.hasNext()) {
            Command[] cmdGroup;
            for (Command c : cmdGroup = (Command[])i$.next()) {
                c.getOptionsWithHelp();
                c.registerCompletion(this.rootToken, options);
            }
        }
        return new ShellCompletor(this.rootToken, options);
    }

    public final void printLines(Iterator<String> lines, boolean paginate) throws IOException {
        this.printLines(lines, paginate, null);
    }

    public final void printLines(Iterator<String> lines, boolean paginate, PrintLine out) throws IOException {
        int linesPrinted = 0;
        String prompt = "-- hit any key to continue or 'q' to quit --";
        int lastPromptLength = prompt.length();
        int termWidth = this.reader.getTermwidth();
        int maxLines = this.reader.getTermheight();
        String peek = null;
        while (lines.hasNext()) {
            String nextLine = lines.next();
            if (nextLine == null) continue;
            for (String line : nextLine.split("\\n")) {
                if (out == null) {
                    if (peek != null) {
                        this.reader.printString(peek);
                        this.reader.printNewline();
                        if (paginate && (double)(linesPrinted = (int)((double)linesPrinted + (peek.length() == 0 ? 0.0 : Math.ceil((double)peek.length() * 1.0 / (double)termWidth)))) + Math.ceil((double)lastPromptLength * 1.0 / (double)termWidth) + Math.ceil((double)prompt.length() * 1.0 / (double)termWidth) + Math.ceil((double)line.length() * 1.0 / (double)termWidth) > (double)maxLines) {
                            linesPrinted = 0;
                            int numdashes = (termWidth - prompt.length()) / 2;
                            String nextPrompt = Shell.repeat("-", numdashes) + prompt + Shell.repeat("-", numdashes);
                            lastPromptLength = nextPrompt.length();
                            this.reader.printString(nextPrompt);
                            this.reader.flushConsole();
                            if (Character.toUpperCase((char)this.reader.readVirtualKey()) == 'Q') {
                                this.reader.printNewline();
                                return;
                            }
                            this.reader.printNewline();
                            termWidth = this.reader.getTermwidth();
                            maxLines = this.reader.getTermheight();
                        }
                    }
                    peek = line;
                    continue;
                }
                out.print(line);
            }
        }
        if (out == null && peek != null) {
            this.reader.printString(peek);
            this.reader.printNewline();
        }
    }

    public final void printRecords(Iterable<Map.Entry<Key, Value>> scanner, boolean printTimestamps, boolean paginate, Class<? extends Formatter> formatterClass, PrintLine outFile) throws IOException {
        this.printLines(FormatterFactory.getFormatter(formatterClass, scanner, printTimestamps), paginate, outFile);
    }

    public final void printRecords(Iterable<Map.Entry<Key, Value>> scanner, boolean printTimestamps, boolean paginate, Class<? extends Formatter> formatterClass) throws IOException {
        this.printLines(FormatterFactory.getFormatter(formatterClass, scanner, printTimestamps), paginate);
    }

    public final void printBinaryRecords(Iterable<Map.Entry<Key, Value>> scanner, boolean printTimestamps, boolean paginate, PrintLine outFile) throws IOException {
        this.printLines(FormatterFactory.getFormatter(this.binaryFormatterClass, scanner, printTimestamps), paginate, outFile);
    }

    public final void printBinaryRecords(Iterable<Map.Entry<Key, Value>> scanner, boolean printTimestamps, boolean paginate) throws IOException {
        this.printLines(FormatterFactory.getFormatter(this.binaryFormatterClass, scanner, printTimestamps), paginate);
    }

    public static String repeat(String s, int c) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < c; ++i) {
            sb.append(s);
        }
        return sb.toString();
    }

    public void checkTableState() {
        if (this.getTableName().isEmpty()) {
            throw new IllegalStateException("Not in a table context. Please use 'table <tableName>' to switch to a table, or use '-t' to specify a table if option is available.");
        }
    }

    private final void printConstraintViolationException(ConstraintViolationException cve) {
        this.printException((Exception)((Object)cve), "");
        int COL1 = 50;
        int COL2 = 14;
        int col3 = Math.max(1, Math.min(Integer.MAX_VALUE, this.reader.getTermwidth() - COL1 - COL2 - 6));
        this.logError(String.format("%" + COL1 + "s-+-%" + COL2 + "s-+-%" + col3 + "s%n", Shell.repeat("-", COL1), Shell.repeat("-", COL2), Shell.repeat("-", col3)));
        this.logError(String.format("%-" + COL1 + "s | %" + COL2 + "s | %-" + col3 + "s%n", "Constraint class", "Violation code", "Violation Description"));
        this.logError(String.format("%" + COL1 + "s-+-%" + COL2 + "s-+-%" + col3 + "s%n", Shell.repeat("-", COL1), Shell.repeat("-", COL2), Shell.repeat("-", col3)));
        for (TConstraintViolationSummary cvs : cve.violationSummaries) {
            this.logError(String.format("%-" + COL1 + "s | %" + COL2 + "d | %-" + col3 + "s%n", cvs.constrainClass, cvs.violationCode, cvs.violationDescription));
        }
        this.logError(String.format("%" + COL1 + "s-+-%" + COL2 + "s-+-%" + col3 + "s%n", Shell.repeat("-", COL1), Shell.repeat("-", COL2), Shell.repeat("-", col3)));
    }

    public final void printException(Exception e) {
        this.printException(e, e.getMessage());
    }

    private final void printException(Exception e, String msg) {
        this.logError(e.getClass().getName() + (msg != null ? ": " + msg : ""));
        log.debug((Object)(e.getClass().getName() + (msg != null ? ": " + msg : "")), (Throwable)e);
    }

    public static final void setDebugging(boolean debuggingEnabled) {
        Logger.getLogger((String)"org.apache.accumulo.core").setLevel(debuggingEnabled ? Level.TRACE : Level.INFO);
    }

    public static final boolean isDebuggingEnabled() {
        return Logger.getLogger((String)"org.apache.accumulo.core").isTraceEnabled();
    }

    private final void printHelp(String usage, String description, Options opts) {
        this.printHelp(usage, description, opts, Integer.MAX_VALUE);
    }

    private final void printHelp(String usage, String description, Options opts, int width) {
        PrintWriter pw = new PrintWriter(System.err);
        new HelpFormatter().printHelp(pw, width, usage, description, opts, 2, 5, null, true);
        pw.flush();
        if (this.logErrorsToConsole && this.writer != null) {
            new HelpFormatter().printHelp(this.writer, width, usage, description, opts, 2, 5, null, true);
            this.writer.flush();
        }
    }

    public int getExitCode() {
        return this.exitCode;
    }

    public void resetExitCode() {
        this.exitCode = 0;
    }

    public void setExit(boolean exit) {
        this.exit = exit;
    }

    public boolean getExit() {
        return this.exit;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public ConsoleReader getReader() {
        return this.reader;
    }

    public void updateUser(String principal, AuthenticationToken token) throws AccumuloException, AccumuloSecurityException {
        this.connector = this.instance.getConnector(principal, token);
        this.principal = principal;
        this.token = token;
    }

    public String getPrincipal() {
        return this.principal;
    }

    public AuthenticationToken getToken() {
        return this.token;
    }

    public Class<? extends Formatter> getFormatter() {
        return this.getFormatter(this.tableName);
    }

    public Class<? extends Formatter> getFormatter(String tableName) {
        Class<? extends Formatter> formatter = FormatterCommand.getCurrentFormatter(tableName, this);
        if (null == formatter) {
            this.logError("Could not load the specified formatter. Using the DefaultFormatter");
            return this.defaultFormatterClass;
        }
        return formatter;
    }

    public void setLogErrorsToConsole() {
        this.logErrorsToConsole = true;
    }

    private void logError(String s) {
        log.error((Object)s);
        if (this.logErrorsToConsole) {
            try {
                this.reader.printString("ERROR: " + s + "\n");
                this.reader.flushConsole();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public String readMaskedLine(String prompt, Character mask) throws IOException {
        this.masking = true;
        String s = this.reader.readLine(prompt, mask);
        this.masking = false;
        return s;
    }

    public boolean isMasking() {
        return this.masking;
    }

    public boolean hasExited() {
        return this.exit;
    }

    public static class PrintFile
    implements PrintLine {
        PrintWriter writer;

        public PrintFile(String filename) throws FileNotFoundException {
            this.writer = new PrintWriter(filename);
        }

        @Override
        public void print(String s) {
            this.writer.println(s);
        }

        @Override
        public void close() {
            this.writer.close();
        }
    }

    public static class PrintShell
    implements PrintLine {
        ConsoleReader reader;

        public PrintShell(ConsoleReader reader) {
            this.reader = reader;
        }

        @Override
        public void print(String s) {
            try {
                this.reader.printString(s + "\n");
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }

        @Override
        public void close() {
        }
    }

    public static interface PrintLine {
        public void print(String var1);

        public void close();
    }

    public static abstract class Command {
        static Set<String> getCommandNames(Map<CompletionSet, Set<String>> objects) {
            return objects.get((Object)CompletionSet.COMMANDS);
        }

        static Set<String> getTableNames(Map<CompletionSet, Set<String>> objects) {
            return objects.get((Object)CompletionSet.TABLENAMES);
        }

        static Set<String> getUserNames(Map<CompletionSet, Set<String>> objects) {
            return objects.get((Object)CompletionSet.USERNAMES);
        }

        public void registerCompletionGeneral(Token root, Set<String> args, boolean caseSens) {
            Token t = new Token(args);
            t.setCaseSensitive(caseSens);
            Token command = new Token(this.getName());
            command.addSubcommand(t);
            root.addSubcommand(command);
        }

        public void registerCompletionForTables(Token root, Map<CompletionSet, Set<String>> completionSet) {
            this.registerCompletionGeneral(root, completionSet.get((Object)CompletionSet.TABLENAMES), true);
        }

        public void registerCompletionForUsers(Token root, Map<CompletionSet, Set<String>> completionSet) {
            this.registerCompletionGeneral(root, completionSet.get((Object)CompletionSet.USERNAMES), true);
        }

        public void registerCompletionForCommands(Token root, Map<CompletionSet, Set<String>> completionSet) {
            this.registerCompletionGeneral(root, completionSet.get((Object)CompletionSet.COMMANDS), false);
        }

        public abstract int execute(String var1, CommandLine var2, Shell var3) throws Exception;

        public abstract String description();

        public abstract int numArgs();

        public String getName() {
            String s = this.getClass().getName();
            int st = Math.max(s.lastIndexOf(36), s.lastIndexOf(46));
            int i = s.indexOf("Command");
            return i > 0 ? s.substring(st + 1, i).toLowerCase(Locale.ENGLISH) : null;
        }

        public void registerCompletion(Token root, Map<CompletionSet, Set<String>> completion_set) {
            root.addSubcommand(new Token(this.getName()));
        }

        public final void printHelp(Shell shellState) {
            shellState.printHelp(this.usage(), "description: " + this.description(), this.getOptionsWithHelp());
        }

        public final void printHelp(Shell shellState, int width) {
            shellState.printHelp(this.usage(), "description: " + this.description(), this.getOptionsWithHelp(), width);
        }

        public final Options getOptionsWithHelp() {
            Options opts = this.getOptions();
            opts.addOption(new Option("?", "help", false, "display this help"));
            return opts;
        }

        public String usage() {
            return this.getName();
        }

        public Options getOptions() {
            return new Options();
        }

        public static enum CompletionSet {
            TABLENAMES,
            USERNAMES,
            COMMANDS;

        }
    }
}

