/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.master.tableOps;

import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.fate.Repo;
import org.apache.accumulo.server.client.HdfsZooInstance;
import org.apache.accumulo.server.master.Master;
import org.apache.accumulo.server.master.tableOps.CloneInfo;
import org.apache.accumulo.server.master.tableOps.FinishCloneTable;
import org.apache.accumulo.server.master.tableOps.MasterRepo;
import org.apache.accumulo.server.security.SecurityConstants;
import org.apache.accumulo.server.util.MetadataTable;
import org.apache.log4j.Logger;

class CloneMetadata
extends MasterRepo {
    private static final long serialVersionUID = 1L;
    private CloneInfo cloneInfo;

    public CloneMetadata(CloneInfo cloneInfo) {
        this.cloneInfo = cloneInfo;
    }

    @Override
    public long isReady(long tid, Master environment) throws Exception {
        return 0L;
    }

    @Override
    public Repo<Master> call(long tid, Master environment) throws Exception {
        Logger.getLogger(CloneMetadata.class).info((Object)String.format("Cloning %s with tableId %s from srcTableId %s", this.cloneInfo.tableName, this.cloneInfo.tableId, this.cloneInfo.srcTableId));
        Instance instance = HdfsZooInstance.getInstance();
        MetadataTable.deleteTable(this.cloneInfo.tableId, false, SecurityConstants.getSystemCredentials(), environment.getMasterLock());
        MetadataTable.cloneTable(instance, this.cloneInfo.srcTableId, this.cloneInfo.tableId);
        return new FinishCloneTable(this.cloneInfo);
    }

    @Override
    public void undo(long tid, Master environment) throws Exception {
        MetadataTable.deleteTable(this.cloneInfo.tableId, false, SecurityConstants.getSystemCredentials(), environment.getMasterLock());
    }
}

