/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.handler;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.executor.EventType;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.MasterCoprocessorHost;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.handler.TableEventHandler;

@InterfaceAudience.Private
public class TableModifyFamilyHandler
extends TableEventHandler {
    private final HColumnDescriptor familyDesc;

    public TableModifyFamilyHandler(TableName tableName, HColumnDescriptor familyDesc, Server server, MasterServices masterServices) {
        super(EventType.C_M_MODIFY_FAMILY, tableName, server, masterServices);
        this.familyDesc = familyDesc;
    }

    @Override
    protected void prepareWithTableLock() throws IOException {
        super.prepareWithTableLock();
        HTableDescriptor htd = this.getTableDescriptor();
        this.hasColumnFamily(htd, this.familyDesc.getName());
    }

    @Override
    protected void handleTableOperation(List<HRegionInfo> regions) throws IOException {
        MasterCoprocessorHost cpHost = ((HMaster)this.server).getCoprocessorHost();
        if (cpHost != null) {
            cpHost.preModifyColumnHandler(this.tableName, this.familyDesc);
        }
        this.masterServices.getMasterFileSystem().modifyColumn(this.tableName, this.familyDesc);
        if (cpHost != null) {
            cpHost.postModifyColumnHandler(this.tableName, this.familyDesc);
        }
    }

    @Override
    public String toString() {
        String name = "UnknownServerName";
        if (this.server != null && this.server.getServerName() != null) {
            name = this.server.getServerName().toString();
        }
        String family = "UnknownFamily";
        if (this.familyDesc != null) {
            family = this.familyDesc.getNameAsString();
        }
        return this.getClass().getSimpleName() + "-" + name + "-" + this.getSeqid() + "-" + this.tableName + "-" + family;
    }
}

